/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.cjk.CJKWidthFilter;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.ja.JapaneseBaseFormFilter;
import org.apache.lucene.analysis.ja.JapaneseKatakanaStemFilter;
import org.apache.lucene.analysis.ja.JapanesePartOfSpeechStopFilter;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.StopwordAnalyzerBase;
import org.apache.lucene.util.Version;

public class JapaneseAnalyzer
extends StopwordAnalyzerBase {
    private final JapaneseTokenizer.Mode mode;
    private final Set<String> stoptags;
    private final UserDictionary userDict;

    public JapaneseAnalyzer(Version matchVersion) {
        this(matchVersion, null, JapaneseTokenizer.DEFAULT_MODE, DefaultSetHolder.DEFAULT_STOP_SET, DefaultSetHolder.DEFAULT_STOP_TAGS);
    }

    public JapaneseAnalyzer(Version matchVersion, UserDictionary userDict, JapaneseTokenizer.Mode mode, CharArraySet stopwords, Set<String> stoptags) {
        super(matchVersion, stopwords);
        this.userDict = userDict;
        this.mode = mode;
        this.stoptags = stoptags;
    }

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public static Set<String> getDefaultStopTags() {
        return DefaultSetHolder.DEFAULT_STOP_TAGS;
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        JapaneseTokenizer tokenizer = new JapaneseTokenizer(reader, this.userDict, true, this.mode);
        TokenFilter stream = new JapaneseBaseFormFilter(tokenizer);
        stream = new JapanesePartOfSpeechStopFilter(this.matchVersion, stream, this.stoptags);
        stream = new CJKWidthFilter(stream);
        stream = new StopFilter(this.matchVersion, stream, this.stopwords);
        stream = new JapaneseKatakanaStemFilter(stream);
        stream = new LowerCaseFilter(this.matchVersion, stream);
        return new Analyzer.TokenStreamComponents(tokenizer, stream);
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;
        static final Set<String> DEFAULT_STOP_TAGS;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = JapaneseAnalyzer.loadStopwordSet(true, JapaneseAnalyzer.class, "stopwords.txt", "#");
                CharArraySet tagset = JapaneseAnalyzer.loadStopwordSet(false, JapaneseAnalyzer.class, "stoptags.txt", "#");
                DEFAULT_STOP_TAGS = new HashSet<String>();
                for (Object element : tagset) {
                    char[] chars = (char[])element;
                    DEFAULT_STOP_TAGS.add(new String(chars));
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword or stoptag set");
            }
        }
    }
}

