/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ja.tokenattributes.ReadingAttribute;
import org.apache.lucene.analysis.ja.util.ToStringUtil;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public final class JapaneseReadingFormFilter
extends TokenFilter {
    private final CharTermAttribute termAttr = this.addAttribute(CharTermAttribute.class);
    private final ReadingAttribute readingAttr = this.addAttribute(ReadingAttribute.class);
    private StringBuilder buffer = new StringBuilder();
    private boolean useRomaji;

    public JapaneseReadingFormFilter(TokenStream input, boolean useRomaji) {
        super(input);
        this.useRomaji = useRomaji;
    }

    public JapaneseReadingFormFilter(TokenStream input) {
        this(input, false);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            String reading = this.readingAttr.getReading();
            if (this.useRomaji) {
                if (reading == null) {
                    this.buffer.setLength(0);
                    ToStringUtil.getRomanization(this.buffer, this.termAttr);
                    this.termAttr.setEmpty().append(this.buffer);
                } else {
                    ToStringUtil.getRomanization(this.termAttr.setEmpty(), reading);
                }
            } else if (reading != null) {
                this.termAttr.setEmpty().append(reading);
            }
            return true;
        }
        return false;
    }
}

