/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.LuceneWrapper4;

import java.io.IOException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.greenstone.LuceneWrapper4.GSLuceneUtil;

public class GS2LuceneDelete {
    private boolean debug = true;
    private IndexWriter index_writer = null;

    public static void main(String[] stringArray) throws Exception {
        String string = "";
        int n = -1;
        for (int i = 0; i < stringArray.length; i += 2) {
            if (stringArray[i].equals("--index")) {
                string = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("--nodeid")) {
                n = Integer.parseInt(stringArray[i + 1]);
                continue;
            }
            System.out.println("Error! Unknown argument: " + stringArray[i]);
            GS2LuceneDelete.printUsage();
            System.exit(0);
        }
        if (string.equals("")) {
            System.out.println("Error! Missing index path");
            GS2LuceneDelete.printUsage();
            System.exit(0);
        }
        if (n == -1) {
            System.out.println("Error! Missing or invalid Node ID");
            GS2LuceneDelete.printUsage();
            System.exit(0);
        }
        GS2LuceneDelete gS2LuceneDelete = new GS2LuceneDelete(string);
        gS2LuceneDelete.deleteDocument(n);
        gS2LuceneDelete.destroy();
        gS2LuceneDelete = null;
    }

    public static void printUsage() {
        System.out.println("usage: GS2LuceneDelete --index <path> --nodeid <int>");
        System.out.println("");
        System.out.println("where:");
        System.out.println("  index    - is the full path to the directory containing the directory");
        System.out.println("             to edit, including the level (ie didx, sidx)");
        System.out.println("  nodeid   - the unique identifier of the document to delete. This is the");
        System.out.println("             same as the docnum in the GDBM");
        System.out.println("");
    }

    public GS2LuceneDelete(String string) throws IOException {
        this.index_writer = GSLuceneUtil.getIndexWriter(string);
    }

    public void debug(String string) {
        if (this.debug) {
            System.err.println(string);
        }
    }

    public void destroy() throws IOException {
        this.index_writer.close();
        this.index_writer = null;
    }

    public void deleteDocument(int n) throws IOException {
        this.debug("GS2LuceneDelete.deleteDocument(" + n + ")");
        this.debug("- Initial number of documents in index: " + this.index_writer.numDocs());
        this.index_writer.deleteDocuments(new Term("nodeid", "" + n));
        this.debug("- Final number of documents in index: " + this.index_writer.numDocs());
    }
}

