/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.LuceneWrapper4;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.FSDirectory;
import org.greenstone.LuceneWrapper4.GS2Analyzer;
import org.greenstone.LuceneWrapper4.GSLuceneConstants;

public final class GSLuceneUtil {
    private GSLuceneUtil() {
    }

    public static IndexWriter getIndexWriter(String string) throws IOException {
        return GSLuceneUtil.getIndexWriter(string, (Analyzer)new GS2Analyzer(), IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
    }

    public static IndexWriter getIndexWriter(String string, boolean bl) throws IOException {
        if (bl) {
            return GSLuceneUtil.getIndexWriter(string, (Analyzer)new GS2Analyzer(), IndexWriterConfig.OpenMode.CREATE);
        }
        return GSLuceneUtil.getIndexWriter(string, (Analyzer)new GS2Analyzer(), IndexWriterConfig.OpenMode.APPEND);
    }

    public static IndexWriter getIndexWriter(String string, Analyzer analyzer, boolean bl) throws IOException {
        if (bl) {
            return GSLuceneUtil.getIndexWriter(string, analyzer, IndexWriterConfig.OpenMode.CREATE);
        }
        return GSLuceneUtil.getIndexWriter(string, analyzer, IndexWriterConfig.OpenMode.APPEND);
    }

    public static IndexWriter getIndexWriter(String string, Analyzer analyzer, IndexWriterConfig.OpenMode openMode) throws IOException {
        IndexWriter indexWriter = null;
        FSDirectory fSDirectory = FSDirectory.open(new File(string));
        LimitTokenCountAnalyzer limitTokenCountAnalyzer = new LimitTokenCountAnalyzer(analyzer, Integer.MAX_VALUE);
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(GSLuceneConstants.MATCH_VERSION, limitTokenCountAnalyzer);
        if (openMode == null) {
            indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        } else {
            indexWriterConfig.setOpenMode(openMode);
        }
        indexWriter = new IndexWriter(fSDirectory, indexWriterConfig);
        return indexWriter;
    }
}

