/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.LuceneWrapper4;

import java.util.Vector;

public class SharedSoleneQueryResult {
    public static final int NO_ERROR = 0;
    public static final int PARSE_ERROR = 1;
    public static final int TOO_MANY_CLAUSES_ERROR = 2;
    public static final int IO_ERROR = 3;
    public static final int SERVER_ERROR = 4;
    public static final int OTHER_ERROR = 5;
    protected Vector docs_ = new Vector();
    protected Vector terms_ = new Vector();
    protected Vector stopwords_ = new Vector();
    protected int total_num_docs_ = 0;
    protected int start_results_ = 0;
    protected int end_results_ = 0;
    protected int error_ = 0;

    public void clear() {
        this.total_num_docs_ = 0;
        this.docs_.clear();
        this.terms_.clear();
        this.stopwords_.clear();
        this.error_ = 0;
    }

    public String toString() {
        int n;
        String string = "";
        string = string + "docs (ranks): ";
        for (n = 0; n < this.docs_.size(); ++n) {
            string = string + ((DocInfo)this.docs_.elementAt(n)).toString() + ", ";
        }
        string = string + "\nterms: ";
        for (n = 0; n < this.terms_.size(); ++n) {
            string = string + ((TermInfo)this.terms_.elementAt(n)).toString() + ", ";
        }
        string = string + "\nactual number of docs found = " + this.total_num_docs_;
        return string;
    }

    public String toShortString() {
        String string = "";
        string = string + "\nterms: ";
        for (int i = 0; i < this.terms_.size(); ++i) {
            string = string + ((TermInfo)this.terms_.elementAt(i)).toString() + ", ";
        }
        string = string + "\nactual number of docs found = " + this.total_num_docs_;
        return string;
    }

    public void setTotalDocs(int n) {
        this.total_num_docs_ = n;
    }

    public void setStartResults(int n) {
        this.start_results_ = n;
    }

    public void setEndResults(int n) {
        this.end_results_ = n;
    }

    public void addDoc(String string, float f, int n) {
        this.docs_.add(new DocInfo(string, f, n));
    }

    public void addTerm(String string, String string2, int n, int n2) {
        TermInfo termInfo = new TermInfo();
        termInfo.term_ = string;
        termInfo.field_ = string2;
        termInfo.match_docs_ = n;
        termInfo.term_freq_ = n2;
        this.terms_.add(termInfo);
    }

    public void addStopWord(String string) {
        this.stopwords_.add(string);
    }

    public Vector getDocs() {
        return this.docs_;
    }

    public int getError() {
        return this.error_;
    }

    public String getErrorString() {
        if (this.error_ == 1) {
            return "PARSE_EXCEPTION";
        }
        if (this.error_ == 2) {
            return "TOO_MANY_CLAUSES";
        }
        if (this.error_ == 3) {
            return "IO_ERROR";
        }
        if (this.error_ == 0) {
            return "NO_ERROR";
        }
        return "UNKNOWN";
    }

    public Vector getTerms() {
        return this.terms_;
    }

    public Vector getStopWords() {
        return this.stopwords_;
    }

    public int getTotalDocs() {
        return this.total_num_docs_;
    }

    public void setError(int n) {
        this.error_ = n;
    }

    public String getXMLString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<QueryTermsInfo num=\"" + this.terms_.size() + "\"/>\n");
        for (n = 0; n < this.terms_.size(); ++n) {
            stringBuffer.append(((TermInfo)this.terms_.elementAt(n)).toXMLString() + "\n");
        }
        for (n = 0; n < this.stopwords_.size(); ++n) {
            stringBuffer.append("<StopWord value=\"" + (String)this.stopwords_.elementAt(n) + "\" />\n");
        }
        stringBuffer.append("<MatchingDocsInfo num=\"" + this.total_num_docs_ + "\"/>\n");
        stringBuffer.append("<StartResults num=\"" + this.start_results_ + "\"/>\n");
        stringBuffer.append("<EndResults num=\"" + this.end_results_ + "\"/>\n");
        for (n = 0; n < this.docs_.size(); ++n) {
            stringBuffer.append(((DocInfo)this.docs_.elementAt(n)).toXMLString() + "\n");
        }
        return stringBuffer.toString();
    }

    public static String xmlSafe(String string) {
        string = string.replaceAll("&", "&amp;amp;");
        string = string.replaceAll("<", "&amp;lt;");
        string = string.replaceAll(">", "&amp;gt;");
        string = string.replaceAll("'", "&amp;#039;");
        string = string.replaceAll("\\\"", "&amp;quot;");
        return string;
    }

    public class DocInfo {
        public String id_ = "";
        public float rank_ = 0.0f;
        public int termfreq_ = 0;

        public DocInfo(String string, float f, int n) {
            this.id_ = string;
            this.rank_ = f;
            this.termfreq_ = n;
        }

        public String toString() {
            return "" + this.id_ + " (" + this.rank_ + ") (" + this.termfreq_ + ")";
        }

        public String toXMLString() {
            return "<Match id=\"" + this.id_ + "\" rank=\"" + this.rank_ + "\" termfreq=\"" + this.termfreq_ + "\" />";
        }
    }

    public class TermInfo {
        public String term_ = null;
        public String field_ = null;
        public int match_docs_ = 0;
        public int term_freq_ = 0;

        public String toString() {
            String string = "";
            string = string + "<" + this.field_ + ">\"" + this.term_ + " docs(" + this.match_docs_;
            string = string + ")freq(" + this.term_freq_ + ")";
            return string;
        }

        public String toXMLString() {
            return "<Term value=\"" + SharedSoleneQueryResult.xmlSafe(this.term_) + "\" field=\"" + this.field_ + "\" freq=\"" + this.term_freq_ + "\" />";
        }
    }
}

