/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.selfContained;

import java.io.StringReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.greenstone.gsdl3.selfContained.DocumentStream;
import org.greenstone.gsdl3.selfContained.GeneratedDocumentStream;
import org.w3c.dom.Document;

public class QueryDocumentStream
implements DocumentStream {
    public static final String DEFAULT_QUERY_STRING = "<xsl:stylesheet version=\"1.0\"                     xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">   <xsl:output omit-xml-declaration=\"yes\"/>   <xsl:template match=\"/*\">      <xsl:if test=\"contains(.,'the')\">         <xsl:copy-of select=\".\"/>      </xsl:if>   </xsl:template></xsl:stylesheet>";
    public static final String DEFAULT_QUERY_STRING_1_1 = "<xsl:stylesheet version=\"1.0\"                     xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">   <xsl:output omit-xml-declaration=\"yes\"/>   <xsl:template match=\"/*\">      <xsl:if test=\"contains(.,'";
    public static final String DEFAULT_QUERY_STRING_1_2 = "')\">         <xsl:copy-of select=\".\"/>      </xsl:if>   </xsl:template></xsl:stylesheet>";
    protected StreamSource query = new StreamSource(new StringReader("<xsl:stylesheet version=\"1.0\"                     xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">   <xsl:output omit-xml-declaration=\"yes\"/>   <xsl:template match=\"/*\">      <xsl:if test=\"contains(.,'the')\">         <xsl:copy-of select=\".\"/>      </xsl:if>   </xsl:template></xsl:stylesheet>"));
    protected DocumentStream stream = null;
    protected Document cached = null;
    TransformerFactory transformerFactory = null;
    Transformer transformer = null;

    public QueryDocumentStream() {
        this.query = new StreamSource(new StringReader(DEFAULT_QUERY_STRING));
        this.stream = new GeneratedDocumentStream();
        try {
            this.transformerFactory = TransformerFactoryImpl.newInstance();
            this.transformer = this.transformerFactory.newTransformer(this.query);
        }
        catch (TransformerConfigurationException e) {
            System.err.println("XMLTransformer: couldn't create transformer object: " + e.getMessage());
        }
    }

    public QueryDocumentStream(DocumentStream stream, String query) {
        String fullQuery = DEFAULT_QUERY_STRING_1_1 + query + DEFAULT_QUERY_STRING_1_2;
        this.query = new StreamSource(new StringReader(fullQuery));
        this.stream = stream;
        try {
            this.transformerFactory = TransformerFactoryImpl.newInstance();
            this.transformer = this.transformerFactory.newTransformer(this.query);
        }
        catch (TransformerConfigurationException e) {
            System.err.println("XMLTransformer: couldn't create transformer object: " + e.getMessage());
        }
    }

    public QueryDocumentStream(DocumentStream stream, StreamSource source) {
        this.query = source;
        this.stream = stream;
        try {
            this.transformerFactory = TransformerFactoryImpl.newInstance();
            this.transformer = this.transformerFactory.newTransformer(this.query);
        }
        catch (TransformerConfigurationException e) {
            System.err.println("XMLTransformer: couldn't create transformer object: " + e.getMessage());
        }
    }

    public QueryDocumentStream(DocumentStream stream) {
        this.query = new StreamSource(new StringReader(DEFAULT_QUERY_STRING));
        this.stream = stream;
        try {
            this.transformerFactory = TransformerFactoryImpl.newInstance();
            this.transformer = this.transformerFactory.newTransformer(this.query);
        }
        catch (TransformerConfigurationException e) {
            System.err.println("XMLTransformer: couldn't create transformer object: " + e.getMessage());
        }
    }

    public Document nextDocument() throws Exception {
        if (!this.hasNextDocument()) {
            throw new Error("no more docs");
        }
        Document result = this.cached;
        this.cached = null;
        return result;
    }

    public boolean hasNextDocument() throws Exception {
        this.lookInStream();
        return this.cached != null;
    }

    protected boolean lookInStream() throws Exception {
        while (this.stream.hasNextDocument() && this.cached == null) {
            Document candidate = this.stream.nextDocument();
            DOMSource input = new DOMSource(candidate);
            DOMResult output = new DOMResult();
            try {
                this.transformer.transform(input, output);
                if (output.getNode().getFirstChild() == null) continue;
                this.cached = (Document)output.getNode();
            }
            catch (TransformerConfigurationException e) {
                System.err.println("XMLTransformer: couldn't create transformer object: " + e.getMessage());
            }
            catch (TransformerException e) {
                System.err.println("XMLTransformer: couldn't transform the source: " + e.getMessage());
                this.cached = null;
                return false;
            }
            catch (Exception e) {
                System.err.println("Exception: " + e.getMessage());
                this.cached = null;
                return false;
            }
        }
        return this.cached == null;
    }

    public static void main(String[] args) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        GeneratedDocumentStream gStream = new GeneratedDocumentStream();
        QueryDocumentStream qStream = new QueryDocumentStream(gStream);
        while (qStream.hasNextDocument()) {
            Document document = qStream.nextDocument();
            StreamResult result = new StreamResult(System.out);
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
            System.out.println();
            System.out.println("======================================================");
        }
    }
}

