/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.greenstone.gsdl3.service.AbstractSearch;
import org.greenstone.gsdl3.util.GSFile;
import org.greenstone.gsdl3.util.GSXML;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LuceneSearch
extends AbstractSearch {
    static Logger logger = Logger.getLogger((String)LuceneSearch.class.getName());
    protected static final String INDEX_ELEM = "index";

    public boolean configure(Element info, Element extra_info) {
        if (!super.configure(info, extra_info)) {
            return false;
        }
        this.default_index = "idx";
        return true;
    }

    protected void getIndexData(ArrayList index_ids, ArrayList index_names, String lang) {
        Element index_list = (Element)GSXML.getChildByTagName(this.config_info, "indexList");
        if (index_list != null) {
            NodeList indexes = index_list.getElementsByTagName(INDEX_ELEM);
            int len = indexes.getLength();
            for (int i = 0; i < len; ++i) {
                Element index = (Element)indexes.item(i);
                index_ids.add(index.getAttribute("name"));
                index_names.add(GSXML.getDisplayText(index, "name", lang, "en"));
            }
        } else {
            index_ids.add(this.default_index);
            index_names.add("Default index");
        }
    }

    protected Element processTextQuery(Element request) {
        Element result = this.doc.createElement("response");
        result.setAttribute("from", "TextQuery");
        result.setAttribute("type", "process");
        Element doc_node_list = this.doc.createElement("documentNodeList");
        result.appendChild(doc_node_list);
        Element metadata_list = this.doc.createElement("metadataList");
        result.appendChild(metadata_list);
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        if (param_list == null) {
            logger.error((Object)"TextQuery request had no paramList.");
            GSXML.addMetadata(this.doc, metadata_list, "numDocsMatched", "0");
            return result;
        }
        HashMap params = GSXML.extractParams(param_list, false);
        String query_string = (String)params.get("query");
        if (query_string == null || query_string.equals("")) {
            logger.error((Object)"TextQuery request had no query string.");
            GSXML.addMetadata(this.doc, metadata_list, "numDocsMatched", "0");
            return result;
        }
        String index = (String)params.get(INDEX_ELEM);
        if (index == null || index.equals("")) {
            index = this.default_index;
        }
        try {
            String index_dir = GSFile.collectionIndexDir(this.site_home, this.cluster_name);
            index_dir = index_dir + File.separator + index;
            IndexSearcher searcher = new IndexSearcher(index_dir);
            StandardAnalyzer analyzer = new StandardAnalyzer();
            Term term = new Term("content", query_string);
            TermQuery query = new TermQuery(term);
            Hits hits = searcher.search((Query)query);
            GSXML.addMetadata(this.doc, metadata_list, "numDocsMatched", "" + hits.length());
            for (int i = 0; i < hits.length(); ++i) {
                Document luc_doc = hits.doc(i);
                String node_id = luc_doc.get("nodeID");
                Element node = this.doc.createElement("documentNode");
                node.setAttribute("nodeID", node_id);
                doc_node_list.appendChild(node);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

