/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.core.MessageRouter;
import org.greenstone.gsdl3.core.ModuleInterface;
import org.greenstone.gsdl3.util.CollectionClassLoader;
import org.greenstone.gsdl3.util.Dictionary;
import org.greenstone.gsdl3.util.GSPath;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ServiceRack
implements ModuleInterface {
    static Logger logger = Logger.getLogger((String)ServiceRack.class.getName());
    protected String site_home = null;
    protected String site_http_address = null;
    protected String library_name = null;
    protected String cluster_name = null;
    protected MessageRouter router = null;
    protected XMLConverter converter = new XMLConverter();
    protected Element config_info = null;
    protected Document doc = null;
    protected Element short_service_info = null;
    protected HashMap format_info_map = null;
    CollectionClassLoader class_loader = null;

    public void setClusterName(String cluster_name) {
        this.cluster_name = cluster_name;
    }

    public void setCollectionName(String coll_name) {
        this.setClusterName(coll_name);
    }

    public void cleanUp() {
    }

    public void setSiteHome(String site_home) {
        this.site_home = site_home;
    }

    public void setSiteAddress(String site_address) {
        this.site_http_address = site_address;
    }

    public void setLibraryName(String library_name) {
        this.library_name = library_name;
    }

    public String getLibraryName() {
        return this.library_name;
    }

    public void setMessageRouter(MessageRouter m) {
        this.router = m;
        this.setLibraryName(m.getLibraryName());
    }

    public ServiceRack() {
        ServiceRack serviceRack = this;
        this.doc = serviceRack.converter.newDOM();
        this.short_service_info = this.doc.createElement("serviceList");
        this.format_info_map = new HashMap();
    }

    public boolean configure(Element info) {
        return this.configure(info, null);
    }

    public boolean configure(Element info, Element extra_info) {
        this.class_loader = new CollectionClassLoader(this.getClass().getClassLoader(), this.site_home, this.cluster_name);
        return true;
    }

    public String process(String xml_in) {
        Document doc = this.converter.getDOM(xml_in);
        if (doc == null) {
            logger.error((Object)"Couldn't parse request");
            logger.error((Object)xml_in);
            return null;
        }
        Node res = this.process(doc);
        return XMLConverter.getString(res);
    }

    public Node process(Node message_node) {
        Element message = XMLConverter.nodeToElement(message_node);
        NodeList requests = message.getElementsByTagName("request");
        Document mess_doc = message.getOwnerDocument();
        Element mainResult = this.doc.createElement("message");
        if (requests.getLength() == 0) {
            return mainResult;
        }
        for (int i = 0; i < requests.getLength(); ++i) {
            Element response;
            Element request = (Element)requests.item(i);
            String type = request.getAttribute("type");
            if (type.equals("describe")) {
                response = this.processDescribe(request);
                if (response == null) continue;
                mainResult.appendChild(this.doc.importNode(response, true));
                continue;
            }
            if (type.equals("format")) {
                response = this.processFormat(request);
                mainResult.appendChild(this.doc.importNode(response, true));
                continue;
            }
            StringBuffer error_string = new StringBuffer();
            String to = GSPath.getFirstLink(request.getAttribute("to"));
            Element response2 = null;
            try {
                Class<?> c = this.getClass();
                Class[] params = new Class[]{Class.forName("org.w3c.dom.Element")};
                String method_name = "process" + to;
                Method m = null;
                while (c != null) {
                    try {
                        m = c.getDeclaredMethod(method_name, params);
                        break;
                    }
                    catch (NoSuchMethodException e) {
                        c = c.getSuperclass();
                    }
                    catch (SecurityException e) {
                        logger.error((Object)("security exception for finding method " + method_name));
                        error_string.append("ServiceRack.process: security exception for finding method " + method_name);
                    }
                }
                if (m != null) {
                    Object[] args = new Object[]{request};
                    try {
                        response2 = (Element)m.invoke((Object)this, args);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Trying to call a processService type method (process" + to + ") on a subclass(" + this.getClass().getName() + "), but an exception happened:" + e.toString()));
                        error_string.append("Trying to call a processService type method (process" + to + ") on a subclass(" + this.getClass().getName() + "), but an exception happened:" + e.toString());
                    }
                } else {
                    logger.error((Object)("method " + method_name + " not found for class " + this.getClass().getName()));
                    error_string.append("ServiceRack.process: method " + method_name + " not found for class " + this.getClass().getName());
                }
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)"Element class not found");
                error_string.append("Element class not found");
            }
            if (response2 != null) {
                mainResult.appendChild(this.doc.importNode(response2, true));
                continue;
            }
            logger.error((Object)"adding in an error element\n");
            response2 = this.doc.createElement("response");
            GSXML.addError(this.doc, response2, error_string.toString());
            mainResult.appendChild(response2);
        }
        return mainResult;
    }

    protected Element processDescribe(Element request) {
        Element response = this.doc.createElement("response");
        response.setAttribute("type", "describe");
        String lang = request.getAttribute("lang");
        String to = GSPath.getFirstLink(request.getAttribute("to"));
        if (to.equals("")) {
            response.appendChild(this.getServiceList(lang));
            return response;
        }
        response.setAttribute("from", to);
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        Element description = null;
        if (param_list == null) {
            description = this.getServiceDescription(to, lang, null);
        } else {
            NodeList params = param_list.getElementsByTagName("param");
            for (int i = 0; i < params.getLength(); ++i) {
                Element param = (Element)params.item(i);
                if (!param.getAttribute("name").equals("subset")) continue;
                String info = param.getAttribute("value");
                if (description == null) {
                    description = this.getServiceDescription(to, lang, info);
                    continue;
                }
                Element temp = this.getServiceDescription(to, lang, info);
                GSXML.mergeElements(description, temp);
            }
        }
        if (description != null) {
            response.appendChild(description);
        }
        return response;
    }

    protected Element processFormat(Element request) {
        Element response = this.doc.createElement("response");
        response.setAttribute("type", "format");
        String to = GSPath.getFirstLink(request.getAttribute("to"));
        if (to.equals("")) {
            return response;
        }
        if (this.format_info_map.containsKey(to)) {
            response.appendChild(this.getServiceFormat(to));
            response.setAttribute("from", to);
            return response;
        }
        logger.error((Object)("ServiceRack describe request: no format info for " + to + "."));
        return response;
    }

    protected Element getServiceList(String lang) {
        return (Element)this.short_service_info.cloneNode(true);
    }

    protected abstract Element getServiceDescription(String var1, String var2, String var3);

    protected Element getServiceFormat(String service) {
        Element format = (Element)((Element)this.format_info_map.get(service)).cloneNode(true);
        return format;
    }

    protected String getTextString(String key, String lang) {
        return this.getTextString(key, lang, null, null);
    }

    protected String getTextString(String key, String lang, String dictionary) {
        return this.getTextString(key, lang, dictionary, null);
    }

    protected String getTextString(String key, String lang, String[] args) {
        return this.getTextString(key, lang, null, args);
    }

    protected String getTextString(String key, String lang, String dictionary, String[] args) {
        if (dictionary != null) {
            Dictionary dict = new Dictionary(dictionary, lang, this.class_loader);
            String result = dict.get(key, args);
            if (result == null) {
                return "_" + key + "_";
            }
            return result;
        }
        String class_name = this.getClass().getName();
        Dictionary dict = new Dictionary(class_name = class_name.substring(class_name.lastIndexOf(46) + 1), lang, this.class_loader);
        String result = dict.get(key, args);
        if (result != null) {
            return result;
        }
        for (Class<?> c = this.getClass().getSuperclass(); result == null && c != null; c = c.getSuperclass()) {
            class_name = c.getName();
            if ((class_name = class_name.substring(class_name.lastIndexOf(46) + 1)).equals("ServiceRack")) break;
            dict = new Dictionary(class_name, lang, this.class_loader);
            result = dict.get(key, args);
        }
        if (result == null) {
            return "_" + key + "_";
        }
        return result;
    }

    protected String getMetadataNameText(String key, String lang) {
        String properties_name = "metadata_names";
        Dictionary dict = new Dictionary(properties_name, lang);
        String result = dict.get(key);
        if (result == null) {
            return null;
        }
        return result;
    }
}

