/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.sql;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.sql.MetadataDBWrapper;
import org.greenstone.gsdl3.sql.SQLServer;
import org.greenstone.gsdl3.sql.SQLStatements;

public class DatabaseFactory {
    private static HashMap serverMap = new HashMap();
    private static Logger logger = Logger.getLogger((String)DatabaseFactory.class.getName());

    public static String properDBName(String name_in) {
        String name_out = "";
        if ((name_in = name_in.toLowerCase()).length() >= 1) {
            String firstLetter = name_in.substring(0, 1).toUpperCase();
            name_out = firstLetter + name_in.substring(1);
        }
        return name_out;
    }

    public static final SQLServer getDatabaseServer(String dbname) {
        if (serverMap.containsKey(dbname = DatabaseFactory.properDBName(dbname))) {
            return (SQLServer)serverMap.get(dbname);
        }
        String fullName = "org.greenstone.gsdl3.sql." + dbname.toLowerCase() + "." + dbname + "SQLServer";
        try {
            SQLServer server = (SQLServer)Class.forName(fullName).newInstance();
            serverMap.put(dbname, server);
            return server;
        }
        catch (Exception e) {
            logger.debug((Object)("Couldn't load the database server " + fullName));
            return null;
        }
    }

    public static final SQLStatements getSQLStatements(String sqlstate) {
        String fullsqlstate = "org.greenstone.gsdl3.sql." + sqlstate;
        try {
            SQLStatements state = (SQLStatements)Class.forName(fullsqlstate).newInstance();
            return state;
        }
        catch (Exception e) {
            try {
                SQLStatements state = (SQLStatements)Class.forName(sqlstate).newInstance();
                return state;
            }
            catch (Exception e2) {
                logger.debug((Object)("Couldn't load the sql statement  " + sqlstate));
                return null;
            }
        }
    }

    public static final MetadataDBWrapper getMetadataDBWrapper(String dbname, String sqlstate) {
        block9: {
            dbname = DatabaseFactory.properDBName(dbname);
            String fullName = "org.greenstone.gsdl3.sql." + dbname.toLowerCase() + "." + dbname + "DBWrapper";
            try {
                MetadataDBWrapper wrapper = (MetadataDBWrapper)Class.forName(fullName).newInstance();
                if (wrapper == null) break block9;
                SQLServer server = DatabaseFactory.getDatabaseServer(dbname);
                if (server != null) {
                    wrapper.setSQLServer(server);
                }
                String fullsqlstate = "org.greenstone.gsdl3.sql." + sqlstate;
                try {
                    SQLStatements state = (SQLStatements)Class.forName(fullsqlstate).newInstance();
                    if (state != null) {
                        wrapper.setSQLStatements(state);
                        return wrapper;
                    }
                }
                catch (Exception e) {
                    try {
                        SQLStatements state = (SQLStatements)Class.forName(sqlstate).newInstance();
                        if (state != null) {
                            wrapper.setSQLStatements(state);
                            return wrapper;
                        }
                    }
                    catch (Exception e2) {
                        logger.debug((Object)("Couldn't load the sql statement  " + sqlstate));
                    }
                }
            }
            catch (Exception e) {
                logger.debug((Object)("Couldn't load the database wrapper " + fullName));
            }
        }
        return null;
    }
}

