/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.greenstone.gsdl3.util.DBInfo;
import org.greenstone.gsdl3.util.Dictionary;
import org.greenstone.gsdl3.util.MacroResolver;
import org.greenstone.gsdl3.util.OID;
import org.greenstone.gsdl3.util.SimpleCollectionDatabase;

public class GS2MacroResolver
extends MacroResolver {
    protected SimpleCollectionDatabase coll_db = null;

    public GS2MacroResolver(SimpleCollectionDatabase db) {
        this.coll_db = db;
    }

    public GS2MacroResolver() {
    }

    public void setDB(SimpleCollectionDatabase db) {
        this.coll_db = db;
    }

    public String resolve(String text, String lang, String scope, String doc_oid) {
        if (text == null || text.equals("")) {
            return text;
        }
        if (scope.equals("text") && this.text_macros.size() == 0) {
            return text;
        }
        if (scope.equals("metadata") && this.metadata_macros.size() == 0) {
            return text;
        }
        DBInfo node_info = null;
        DBInfo root_info = null;
        boolean new_lang = false;
        if (this.lang == null || !this.lang.equals(lang)) {
            new_lang = true;
            this.lang = lang;
        }
        ArrayList macros = scope.equals("text") ? this.text_macros : this.metadata_macros;
        block5: for (int i = 0; i < macros.size(); ++i) {
            String new_text = null;
            MacroResolver.Macro m = (MacroResolver.Macro)macros.get(i);
            switch (m.type) {
                case 2: {
                    if (m.text == null || new_lang) {
                        Dictionary dict = new Dictionary(m.bundle, lang);
                        m.text = dict.get(m.key, null);
                    }
                    text = text.replaceAll(m.macro, m.text);
                    continue block5;
                }
                case 0: {
                    Pattern p_text = Pattern.compile(".*" + m.macro + ".*", 32);
                    Matcher match_text = p_text.matcher(text);
                    if (!match_text.matches()) continue block5;
                    new_text = m.resolve ? this.resolve(m.text, lang, scope, doc_oid) : m.text;
                    text = text.replaceAll(m.macro, new_text);
                    if (!m.macro.endsWith("\\\\")) continue block5;
                    Pattern p_back_slash = Pattern.compile("\\\"");
                    Matcher m_slash = p_back_slash.matcher(text);
                    String clean_str = "";
                    int s = 0;
                    while (m_slash.find()) {
                        clean_str = !text.substring(m_slash.end() - 2, m_slash.end() - 1).equals("\\") ? clean_str + text.substring(s, m_slash.end() - 1) : clean_str + text.substring(s, m_slash.end() - 2);
                        s = m_slash.end();
                        clean_str = clean_str + "\"";
                    }
                    text = clean_str + text.substring(s, text.length());
                    continue block5;
                }
                case 1: {
                    Pattern p = Pattern.compile(".*" + m.macro + ".*", 32);
                    Matcher match = p.matcher(text);
                    if (!match.matches() || node_info == null && (node_info = this.coll_db.getInfo(doc_oid)) == null) continue block5;
                    new_text = node_info.getInfo(m.text);
                    if (new_text == null || new_text.equals("")) {
                        if (root_info == null && !OID.isTop(doc_oid)) {
                            root_info = this.coll_db.getInfo(OID.getTop(doc_oid));
                        }
                        if (root_info == null) continue block5;
                        new_text = root_info.getInfo(m.text);
                    }
                    if (new_text == null) continue block5;
                    if (m.resolve) {
                        new_text = this.resolve(new_text, lang, scope, doc_oid);
                    }
                    text = text.replaceAll(m.macro, new_text);
                }
            }
        }
        return text;
    }
}

