/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.util;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.util.Dictionary;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Node;

public class XSLTUtil {
    static Logger logger = Logger.getLogger((String)XSLTUtil.class.getName());

    public static boolean equals(String s1, String s2) {
        return s1.equals(s2);
    }

    public static boolean notEquals(String s1, String s2) {
        return !s1.equals(s2);
    }

    public static boolean exists(String s1, String s2) {
        return !s1.equals("");
    }

    public static boolean contains(String s1, String s2) {
        return s1.indexOf(s2) != -1;
    }

    public static boolean startsWith(String s1, String s2) {
        return s1.startsWith(s2);
    }

    public static boolean endsWith(String s1, String s2) {
        return s1.endsWith(s2);
    }

    public static boolean lessThan(String s1, String s2) {
        return s1.compareTo(s2) < 0;
    }

    public static boolean lessThanOrEquals(String s1, String s2) {
        return s1.compareTo(s2) <= 0;
    }

    public static boolean greaterThan(String s1, String s2) {
        return s1.compareTo(s2) > 0;
    }

    public static boolean greaterThanOrEquals(String s1, String s2) {
        return s1.compareTo(s2) >= 0;
    }

    public static String toLower(String orig) {
        return orig.toLowerCase();
    }

    public static String toUpper(String orig) {
        return orig.toUpperCase();
    }

    public static byte[] toUTF8(String orig) {
        try {
            byte[] utf8 = orig.getBytes("UTF-8");
            return utf8;
        }
        catch (Exception e) {
            logger.error((Object)"unsupported encoding");
            return orig.getBytes();
        }
    }

    public static String getNumberedItem(String list, int number) {
        String[] items = list.split(",", -1);
        if (items.length > number) {
            return items[number];
        }
        return "";
    }

    public static String tidyWhitespace(String original) {
        if (original == null || original.equals("")) {
            return original;
        }
        String new_s = original.replaceAll("\\s+", " ");
        return new_s;
    }

    public static String getInterfaceText(String interface_name, String lang, String key) {
        return XSLTUtil.getInterfaceText(interface_name, lang, key, null);
    }

    public static String getInterfaceText(String interface_name, String lang, String key, String args_str) {
        String sep_interface_dir;
        Dictionary dict;
        String result;
        String[] args = null;
        if (args_str != null && !args_str.equals("")) {
            args = args_str.split(";");
        }
        if ((result = (dict = new Dictionary("interface_" + interface_name, lang)).get(key, args)) == null && (result = (dict = new Dictionary(sep_interface_dir = interface_name + File.separatorChar + lang + File.separatorChar + "interface", lang)).get(key, args)) != null) {
            return result;
        }
        if (result == null && !interface_name.equals("default")) {
            dict = new Dictionary("interface_default", lang);
            result = dict.get(key, args);
        }
        if (result == null) {
            return "_" + key + "_";
        }
        return result;
    }

    public static String getInterfaceTextWithDOM(String interface_name, String lang, String key, Node arg_node) {
        String sep_interface_dir;
        String node_str = XMLConverter.getString(arg_node);
        String[] args = new String[]{node_str};
        Dictionary dict = new Dictionary("interface_" + interface_name, lang);
        String result = dict.get(key, args);
        if (result == null && (result = (dict = new Dictionary(sep_interface_dir = interface_name + File.separatorChar + lang + File.separatorChar + "interface", lang)).get(key, args)) != null) {
            return result;
        }
        if (result == null && !interface_name.equals("default")) {
            dict = new Dictionary("interface_default", lang);
            result = dict.get(key, args);
        }
        if (result == null) {
            return "_" + key + "_";
        }
        return result;
    }

    public static String getInterfaceTextWithDOM(String interface_name, String lang, String key, Node arg1_node, Node arg2_node) {
        String sep_interface_dir;
        String node_str = XMLConverter.getString(arg1_node);
        String[] args = new String[]{node_str, node_str = XMLConverter.getString(arg2_node)};
        Dictionary dict = new Dictionary("interface_" + interface_name, lang);
        String result = dict.get(key, args);
        if (result == null && (result = (dict = new Dictionary(sep_interface_dir = interface_name + File.separatorChar + lang + File.separatorChar + "interface", lang)).get(key, args)) != null) {
            return result;
        }
        if (result == null && !interface_name.equals("default")) {
            dict = new Dictionary("interface_default", lang);
            result = dict.get(key, args);
        }
        if (result == null) {
            return "_" + key + "_";
        }
        return result;
    }

    public static boolean isImage(String mimetype) {
        return mimetype.startsWith("image/");
    }

    public static String formatDate(String date, String lang) {
        String in_pattern = "yyyyMMdd";
        String out_pattern = "dd MMMM yyyy";
        if (date.length() == 6) {
            in_pattern = "yyyyMM";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(in_pattern, new Locale(lang));
        try {
            Date d = formatter.parse(date);
            formatter.applyPattern(out_pattern);
            String new_date = formatter.format(d);
            return new_date;
        }
        catch (Exception e) {
            return date;
        }
    }

    public static String formatLanguage(String display_lang, String lang) {
        return new Locale(display_lang).getDisplayLanguage(new Locale(lang));
    }

    public static String cgiSafe(String original, String lang) {
        original = original.replace('&', ' ');
        original = original.replaceAll(" ", "%20");
        return original;
    }

    public static String formatBigNumber(String num) {
        String num_str = num;
        char[] num_chars = num_str.toCharArray();
        String zero_str = "";
        String formatted_str = "";
        for (int i = num_chars.length - 4; i >= 0; --i) {
            zero_str = zero_str + '0';
        }
        String sig_str = "";
        for (int i = 0; i < 3 && i < num_chars.length; ++i) {
            sig_str = sig_str + num_chars[i];
            if (i != 1 || i + 1 >= num_chars.length) continue;
            sig_str = sig_str + ".";
        }
        int sig_int = Math.round(Float.parseFloat(sig_str));
        String new_sig_str = sig_int + "";
        if (sig_str.length() > 2) {
            new_sig_str = sig_int + "0";
        }
        char[] final_chars = (new_sig_str + zero_str).toCharArray();
        int count = 1;
        for (int i = final_chars.length - 1; i >= 0; --i) {
            formatted_str = final_chars[i] + formatted_str;
            if (count == 3 && i != 0) {
                formatted_str = "," + formatted_str;
                count = 1;
                continue;
            }
            ++count;
        }
        return formatted_str;
    }
}

