/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import jdbm.recman.BlockView;

public final class BlockIo
implements Externalizable {
    public static final long serialVersionUID = 2L;
    private long blockId;
    private transient byte[] data;
    private transient BlockView view = null;
    private transient boolean dirty = false;
    private transient int transactionCount = 0;

    public BlockIo() {
    }

    BlockIo(long l, byte[] byArray) {
        if (l > 10000000000L) {
            throw new Error("bogus block id " + l);
        }
        this.blockId = l;
        this.data = byArray;
    }

    byte[] getData() {
        return this.data;
    }

    void setBlockId(long l) {
        if (this.isInTransaction()) {
            throw new Error("BlockId assigned for transaction block");
        }
        if (l > 10000000000L) {
            throw new Error("bogus block id " + l);
        }
        this.blockId = l;
    }

    long getBlockId() {
        return this.blockId;
    }

    public BlockView getView() {
        return this.view;
    }

    public void setView(BlockView blockView) {
        this.view = blockView;
    }

    void setDirty() {
        this.dirty = true;
    }

    void setClean() {
        this.dirty = false;
    }

    boolean isDirty() {
        return this.dirty;
    }

    boolean isInTransaction() {
        return this.transactionCount != 0;
    }

    synchronized void incrementTransactionCount() {
        ++this.transactionCount;
        this.setClean();
    }

    synchronized void decrementTransactionCount() {
        --this.transactionCount;
        if (this.transactionCount < 0) {
            throw new Error("transaction count on block " + this.getBlockId() + " below zero!");
        }
    }

    public byte readByte(int n) {
        return this.data[n];
    }

    public void writeByte(int n, byte by) {
        this.data[n] = by;
        this.setDirty();
    }

    public short readShort(int n) {
        return (short)((short)(this.data[n + 0] & 0xFF) << 8 | (short)(this.data[n + 1] & 0xFF) << 0);
    }

    public void writeShort(int n, short s) {
        this.data[n + 0] = (byte)(0xFF & s >> 8);
        this.data[n + 1] = (byte)(0xFF & s >> 0);
        this.setDirty();
    }

    public int readInt(int n) {
        return (this.data[n + 0] & 0xFF) << 24 | (this.data[n + 1] & 0xFF) << 16 | (this.data[n + 2] & 0xFF) << 8 | (this.data[n + 3] & 0xFF) << 0;
    }

    public void writeInt(int n, int n2) {
        this.data[n + 0] = (byte)(0xFF & n2 >> 24);
        this.data[n + 1] = (byte)(0xFF & n2 >> 16);
        this.data[n + 2] = (byte)(0xFF & n2 >> 8);
        this.data[n + 3] = (byte)(0xFF & n2 >> 0);
        this.setDirty();
    }

    public long readLong(int n) {
        return (long)((this.data[n + 0] & 0xFF) << 24 | (this.data[n + 1] & 0xFF) << 16 | (this.data[n + 2] & 0xFF) << 8 | this.data[n + 3] & 0xFF) << 32 | (long)((this.data[n + 4] & 0xFF) << 24 | (this.data[n + 5] & 0xFF) << 16 | (this.data[n + 6] & 0xFF) << 8 | this.data[n + 7] & 0xFF) & 0xFFFFFFFFFFFFFFFFL;
    }

    public void writeLong(int n, long l) {
        this.data[n + 0] = (byte)(0xFFL & l >> 56);
        this.data[n + 1] = (byte)(0xFFL & l >> 48);
        this.data[n + 2] = (byte)(0xFFL & l >> 40);
        this.data[n + 3] = (byte)(0xFFL & l >> 32);
        this.data[n + 4] = (byte)(0xFFL & l >> 24);
        this.data[n + 5] = (byte)(0xFFL & l >> 16);
        this.data[n + 6] = (byte)(0xFFL & l >> 8);
        this.data[n + 7] = (byte)(0xFFL & l >> 0);
        this.setDirty();
    }

    public String toString() {
        return "BlockIO(" + this.blockId + "," + this.dirty + "," + this.view + ")";
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.blockId = objectInput.readLong();
        int n = objectInput.readInt();
        this.data = new byte[n];
        objectInput.readFully(this.data);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.blockId);
        objectOutput.writeInt(this.data.length);
        objectOutput.write(this.data);
    }
}

