/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.gif;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.decoder.gif.GIFColorTable;
import com.sun.jimi.core.util.LEDataInputStream;
import java.io.IOException;

public class GIFFileHeader {
    static final int CT_SIZE = 7;
    static final int CT_SORT = 8;
    static final int CT_RES = 112;
    static final int CT_GLOBAL = 128;
    byte[] sig = new byte[3];
    byte[] ver = new byte[3];
    int screenWidth;
    int screenHeight;
    byte packed;
    byte backgroundColor;
    byte aspectRatio;
    int colorTableNumBits;
    GIFColorTable colorTable;

    public String toString() {
        return "GIF Header " + this.screenWidth + " " + this.screenHeight;
    }

    public GIFFileHeader(LEDataInputStream lEDataInputStream) throws JimiException, IOException {
        this.sig[0] = lEDataInputStream.readByte();
        this.sig[1] = lEDataInputStream.readByte();
        this.sig[2] = lEDataInputStream.readByte();
        if (this.sig[0] != 71 || this.sig[1] != 73 || this.sig[2] != 70) {
            throw new JimiException("Not a GIF");
        }
        this.ver[0] = lEDataInputStream.readByte();
        this.ver[1] = lEDataInputStream.readByte();
        this.ver[2] = lEDataInputStream.readByte();
        if (this.ver[0] != 56 || this.ver[1] != 55 && this.ver[1] != 57 || this.ver[2] != 97) {
            throw new JimiException("Unknown GIF version");
        }
        this.screenWidth = lEDataInputStream.readUnsignedShort();
        this.screenHeight = lEDataInputStream.readUnsignedShort();
        this.packed = lEDataInputStream.readByte();
        this.backgroundColor = lEDataInputStream.readByte();
        this.aspectRatio = lEDataInputStream.readByte();
        this.colorTableNumBits = (this.packed & 7) + 1;
        if ((this.packed & 0x80) != 0) {
            this.colorTable = new GIFColorTable(lEDataInputStream, this.colorTableNumBits);
            return;
        }
        this.colorTable = new GIFColorTable(this.colorTableNumBits);
    }
}

