/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.xpm;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.util.x11.XpmParser;
import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.io.InputStream;

public class XPMDecoder
extends JimiDecoderBase {
    protected XpmParser parser_;
    protected AdaptiveRasterImage jimiImage_;
    protected int state_;

    public void initDecoder(InputStream inputStream, AdaptiveRasterImage adaptiveRasterImage) {
        this.parser_ = new XpmParser(inputStream);
        this.jimiImage_ = adaptiveRasterImage;
        this.state_ = 0;
    }

    public boolean driveDecoder() throws JimiException {
        try {
            if (!this.parser_.parse()) {
                throw new JimiException("Image does not parse.");
            }
            XPMDecoder xPMDecoder = this;
            xPMDecoder.xpmInitialize(xPMDecoder.parser_.getWidth(), this.parser_.getHeight(), this.parser_.getPixmap(), this.parser_.getColorTable());
        }
        catch (JimiException jimiException) {
            this.state_ = 1;
            throw jimiException;
        }
        catch (RuntimeException runtimeException) {
            this.state_ = 1;
            throw new JimiException(runtimeException.getMessage());
        }
        this.state_ = 4;
        this.jimiImage_.addFullCoverage();
        return false;
    }

    public int getState() {
        return this.state_;
    }

    public void freeDecoder() {
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.jimiImage_;
    }

    protected void xpmInitialize(int n, int n2, byte[] byArray, Color[] colorArray) throws JimiException {
        int n3 = colorArray.length;
        byte[] byArray2 = new byte[3 * n3];
        int n4 = -1;
        int n5 = 0;
        while (n5 < n3) {
            if (colorArray[n5] == null) {
                n4 = n5;
            } else {
                byArray2[3 * n5] = (byte)colorArray[n5].getRed();
                byArray2[3 * n5 + 1] = (byte)colorArray[n5].getGreen();
                byArray2[3 * n5 + 2] = (byte)colorArray[n5].getBlue();
            }
            ++n5;
        }
        IndexColorModel indexColorModel = new IndexColorModel(8, n3, byArray2, 0, false, n4);
        this.jimiImage_.setSize(n, n2);
        this.jimiImage_.setColorModel(indexColorModel);
        this.jimiImage_.setPixels();
        this.jimiImage_.setChannel(0, 0, 0, n, n2, byArray, 0, n);
    }
}

