@echo off

:: http://ss64.com/nt/syntax-args.html
:: Doing this will make the command prompt go into short filenames mode for this directory.
:: This will be helpful during compiling if there are spaces (or brackets) in the filepath,
:: since apache's own batch scripts do not allow for the possibility of spaces or brackets.
if "%1"=="amd64" (
	cmd /c rem
) else (
	command /c rem
)

:: if running in silent mode (%1 or %2, depending on if "amd64" is passed in in %1), bypass the user-choice sections
:: auto mode unzips everything and does a compile on ALL (local server, webserver and apache) but no debug
:: auto mode is used by the diffcol process which checks out gs2, compiles it and tests tutorial collections
set MODE=user
if "%1"=="silent" set MODE=auto
if "%2"=="silent" set MODE=auto

pushd "%CD%"
CD /D "%~dp0"

:: Change this if the extracted folder name of the apache-httpd2 within runtime-src\packages\apache-httpd ever changes
set httpddir=httpd-2.2.11

:: Set this to "true" if this script can attempt to setup the environment for compilation for you (leave empty if you will do it)
set SET_GS_ENV=

:: Path to VCVARS32.bat -- You can set this variable manually if needed
:: e.g. set VCVARS="C:\Program Files\Microsoft Visual Studio\VC98\Bin\VCVARS32.BAT"
set VCVARS=

:: Path to Microsoft Platform SDK's SetEnv.cmd -- You can set this variable manually if needed
::e.g. set SDK_ENV="C:\Program Files\Microsoft Platform SDK\SetEnv.Cmd"
set SDK_ENV=

rem Move PDFv2Plugin.pm to PDFv2Plugin.tmp as it needs pdfboxconverter extension which doesn't
rem  come with GS2 by default, so pluginfo.pl -describeall fails and GLI can't launch properly
move perllib\plugins\PDFv2Plugin.pm perllib\plugins\PDFv2Plugin.tmp

rem Checking for Winbin and Unzip utility

:: try getting it from svn
IF NOT EXIST .\bin\windows\*.* (
	echo Getting winbin FROM https://svn.greenstone.org/main/trunk/binaries/windows/bin INTO bin/windows
	cd bin
	svn co https://svn.greenstone.org/main/trunk/binaries/windows/bin windows
	cd ..
)

IF NOT EXIST .\bin\windows\*.* GOTO ENDNOWINBIN
IF NOT EXIST .\bin\windows\choice32.exe GOTO ENDNOWINBIN

echo.
echo.
echo  ####                        #                  ###  
echo ##                           #                     # 
echo #     ###  ##   ##  ### ### ###  ##  ###  ##       # 
echo #   # #   #### #### # # ##   #  #  # # # ####    ##  
echo ##  # #   #    #    # #   #  #  #  # # # #      ##   
echo  #### #    ###  ### # # ###  ##  ##  # #  ###   #### 
echo   (C) 2008, New Zealand Digital Library Project
echo.
echo.
echo.


rem Checking for existance of the packages extracted / zipped
IF NOT EXIST .\common-src\packages\windows\crypt\crypt\nul IF NOT EXIST .\common-src\packages\windows\crypt\crypt.zip GOTO ENDNOWINPACK

IF NOT EXIST .\common-src\packages\expat\expat* IF NOT EXIST .\common-src\packages\expat\expat*.tar.gz GOTO ENDNOWINPACK

:: IF NOT EXIST .\common-src\packages\windows\gdbm\gdbm\nul IF NOT EXIST .\common-src\packages\windows\gdbm\gdbm.zip GOTO ENDNOWINPACK

IF NOT EXIST .\common-src\packages\windows\stlport\stlport\nul IF NOT EXIST .\common-src\packages\windows\stlport\stlport.zip GOTO ENDNOWINPACK


set ICONVZIP=iconv-VS14-PLUS.zip
:: Following line loosely based on
::   https://stackoverflow.com/questions/32578014/how-to-extract-version-number-in-a-windows-batch-file/32578368
set VISUAL_STUDIO_MAJORVERSION=%VisualStudioVersion:.=& set VSMinor=%
echo VISUAL_STUDIO_MAJORVERSION = "%VISUAL_STUDIO_MAJORVERSION%"
if %VISUAL_STUDIO_MAJORVERSION% LSS 14 set ICONVZIP=iconv-PRE-VS14.zip
echo Selected iconv to unzip: %ICONVZIP%

IF NOT EXIST .\common-src\indexers\packages\windows\iconv\iconv\nul IF NOT EXIST .\common-src\indexers\packages\windows\iconv\%ICONVZIP% GOTO ENDNOICONV

IF NOT EXIST .\common-src\packages\sqlite\sqlite* IF NOT EXIST .\common-src\packages\sqlite\sqlite*.tar.gz GOTO ENDNOSQLITE


if "%MODE%"=="auto" GOTO UNZIP

rem Ask the user to extract now or to directly compile
echo Do you want to extract the required packages (Recommended)? This will be the default action in 10 seconds.
if "%1"=="amd64" (.\bin\windows\choice64.exe /D Y /T 10 /C YN
	IF errorlevel 2 GOTO COMPILE
	IF errorlevel 1 GOTO UNZIP
	IF errorlevel 0 GOTO END
) else (.\bin\windows\choice32.exe /T:Y,10 /C:YN
	IF errorlevel 2 GOTO COMPILE
	IF errorlevel 1 GOTO UNZIP
	IF errorlevel 0 GOTO END
)
	
:UNZIP
IF NOT EXIST .\bin\windows\unzip.exe GOTO ENDNOUNZIP
IF NOT EXIST .\bin\windows\gunzip.exe GOTO ENDNOUNZIP
IF NOT EXIST .\bin\windows\tar.exe GOTO ENDNOUNZIP

rem Extracting the packages
IF EXIST .\common-src\packages\windows\crypt\crypt.zip .\bin\windows\unzip.exe -o .\common-src\packages\windows\crypt\crypt.zip -d .\common-src\packages\windows\crypt\

IF EXIST .\common-src\packages\expat\expat*.tar.gz .\bin\windows\gunzip.exe -cd .\common-src\packages\expat\expat*.tar.gz | .\bin\windows\tar.exe xv --directory=./common-src/packages/expat

IF EXIST .\common-src\packages\windows\gdbm\gdbm.zip .\bin\windows\unzip.exe -o .\common-src\packages\windows\gdbm\gdbm.zip -d .\common-src\packages\windows\gdbm\

IF EXIST .\common-src\packages\windows\stlport\stlport.zip .\bin\windows\unzip.exe -o .\common-src\packages\windows\stlport\stlport.zip -d .\common-src\packages\windows\stlport\

IF EXIST .\common-src\indexers\packages\windows\iconv\%ICONVZIP% .\bin\windows\unzip.exe -o .\common-src\indexers\packages\windows\iconv\%ICONVZIP% -d .\common-src\indexers\packages\windows\iconv\

IF EXIST .\common-src\packages\sqlite\sqlite*.tar.gz .\bin\windows\gunzip.exe -cd .\common-src\packages\sqlite\sqlite*.tar.gz | .\bin\windows\tar.exe xv --directory=./common-src/packages/sqlite


echo.
echo.
:COMPILE

rem Last check if all the packages have been extracted prior to compilation
IF NOT EXIST .\common-src\packages\windows\crypt\crypt\*.* GOTO NEEDUNZIP
IF NOT EXIST .\common-src\packages\expat\expat* GOTO NEEDUNZIP
:: IF NOT EXIST .\common-src\packages\windows\gdbm\gdbm\*.* GOTO NEEDUNZIP
IF NOT EXIST .\common-src\packages\windows\stlport\stlport\*.* GOTO NEEDUNZIP
IF NOT EXIST .\common-src\indexers\packages\windows\iconv\iconv\*.* GOTO NEEDUNZIP
IF NOT EXIST .\common-src\packages\sqlite\sqlite* GOTO NEEDUNZIP

:: Do nothing if  we are not to set the environment for compiling in this file (if it was set before)
if not "SET_GS_ENV"=="true" goto :PROMPT

rem Check some known paths to VCVARS32.BAT
:: if the user has set VCVARS32 don't look in the default places at all
IF NOT %VCVARS%=="" echo ******* VCVARS set, checking for MS Platform SDK...& GOTO SET_SDK

:: Visual Studio 2005 Pro --- NOT READY YET
IF EXIST "%programfiles%\Microsoft Visual Studio 8\VC\bin\vcvars32.bat" set VCVARS="%programfiles%\Microsoft Visual Studio 8\VC\bin\vcvars32.bat"

:: Visual Studio 2003 \ VS7
IF %VCVARS%=="" IF EXIST "%programfiles%\Microsoft Visual Studio .NET 2003\Vc7\bin\vcvars32.bat" set VCVARS="%programfiles%\Microsoft Visual Studio .NET 2003\Vc7\bin\vcvars32.bat"

:: Visual Studio 6 \ VS6
IF %VCVARS%=="" IF EXIST "%programfiles%\Microsoft Visual Studio\VC98\Bin\VCVARS32.BAT" set VCVARS="%programfiles%\Microsoft Visual Studio\VC98\Bin\VCVARS32.BAT"

IF %VCVARS%=="" GOTO ENDNOVCVARS32
:: Now VCVARS has been set so it can be used when we need it

:SET_SDK
rem Check known path(s) to SetEnv.cmd
:: if the user has set SDK_ENV don't look in the default places at all
IF NOT %SDK_ENV%=="" GOTO CALL_SDK

IF EXIST "%programfiles%\Microsoft Platform SDK\SetEnv.cmd" set SDK_ENV="%programfiles%\Microsoft Platform SDK\SetEnv.cmd"

IF %SDK_ENV%=="" GOTO ENDNOSDKENV

:CALL_SDK
call %SDK_ENV%
echo.
echo.

call %VCVARS%
echo.
echo.

:PROMPT
if "%MODE%"=="auto" GOTO WITHALL
echo.
rem Ask the user what to compile
echo What do you want to compile?
echo.
echo 1. Local library only
echo 2. Web library only
echo 3. Apache local library (needs Microsoft Platform SDK)
echo 4. All
echo 5. All (with Debugging ON)
echo 6. Clean (when re-compiling all, do this before step 5)
echo 7. Quit
echo.
echo Please choose a number from the menu. Otherwise both libraries will be compiled in 15 seconds.
if "%1"=="amd64" (.\bin\windows\choice64.exe /N /D 3 /T 15 /C 1234567
	IF errorlevel 7 GOTO END
	IF errorlevel 6 GOTO DOCLEAN
	IF errorlevel 5 GOTO WITHALLDEBUG
	IF errorlevel 4 GOTO WITHALL
	IF errorlevel 3 GOTO WITHAPACHE
	IF errorlevel 2 GOTO WITHOUTLOCALLIB
	IF errorlevel 1 GOTO WITHLOCALLIB
	IF errorlevel 0 GOTO END
) else (.\bin\windows\choice32.exe /N /T:3,15 /C:1234567
	IF errorlevel 7 GOTO END
	IF errorlevel 6 GOTO DOCLEAN
	IF errorlevel 5 GOTO WITHALLDEBUG
	IF errorlevel 4 GOTO WITHALL
	IF errorlevel 3 GOTO WITHAPACHE
	IF errorlevel 2 GOTO WITHOUTLOCALLIB
	IF errorlevel 1 GOTO WITHLOCALLIB
	IF errorlevel 0 GOTO END
)

:DOCLEAN
echo.
echo.
nmake /f win32.mak CLEAN
GOTO ENDOK
	
:WITHAPACHE
:: Only compile up the Apache web server if we're asked to
:: After unpacking apache httpd 2, patch up the .mak files to prevent the compile failure
:: due to a race condition. (The release kit does this patch for GS2 using custom ant tasks)
:: Then can finally start compiling GS2 with apache-httpd.

:: Now unpack the custom GS2 apache web server tar.gz file
IF NOT EXIST .\runtime-src\packages\apache-httpd\%httpddir%\nul (
	.\bin\windows\gunzip.exe -cd .\runtime-src\packages\apache-httpd\httpd-*.tar.gz | .\bin\windows\tar.exe xv --directory=./runtime-src/packages/apache-httpd
	call runtime-src\packages\apache-httpd\adjust-winmak-files.bat %httpddir%	
)
nmake /f win32.mak APACHE_HTTPD=1
GOTO ENDOK


:WITHOUTLOCALLIB
echo.
echo.
nmake /f win32.mak
GOTO ENDOK

:WITHLOCALLIB
echo.
echo.
nmake /f win32.mak LOCAL_LIBRARY=1
GOTO ENDOK

:WITHALL
:: Now unpack the custom GS2 apache web server tar.gz file, if not already unpacked
IF NOT EXIST .\runtime-src\packages\apache-httpd\%httpddir%\nul (
	.\bin\windows\gunzip.exe -cd .\runtime-src\packages\apache-httpd\httpd-*.tar.gz | .\bin\windows\tar.exe xv --directory=./runtime-src/packages/apache-httpd
	call runtime-src\packages\apache-httpd\adjust-winmak-files.bat %httpddir%
)

echo.
echo.
nmake /f win32.mak
nmake /f win32.mak LOCAL_LIBRARY=1
nmake /f win32.mak APACHE_HTTPD=1
GOTO ENDOK

:WITHALLDEBUG
:: Now unpack the custom GS2 apache web server tar.gz file, if not already unpacked
IF NOT EXIST .\runtime-src\packages\apache-httpd\%httpddir%\nul (
	.\bin\windows\gunzip.exe -cd .\runtime-src\packages\apache-httpd\httpd-*.tar.gz | .\bin\windows\tar.exe xv --directory=./runtime-src/packages/apache-httpd
	call runtime-src\packages\apache-httpd\adjust-winmak-files.bat %httpddir%
)

echo.
echo.
nmake /f win32.mak DEBUG=1
nmake /f win32.mak LOCAL_LIBRARY=1 DEBUG=1
nmake /f win32.mak APACHE_HTTPD=1 DEBUG=1
GOTO ENDOK

:NEEDUNZIP
if "%MODE%"=="auto" GOTO ENDNOUNZIP
echo.
echo /!\ Error /!\ - Some or all the packages are not properly extracted.
echo.
echo If you wish to compile Greenstone 2 you need to unzip the required packages now.
echo.
rem Ask to Unzip the packages now otherwise quit
echo Do you want to unzip these required packages now? This will be the default action in 10 seconds.
if "%1"=="amd64" (.\bin\windows\choice64.exe /D Y /T 10 /C YN
	IF errorlevel 2 GOTO END
	IF errorlevel 1 GOTO UNZIP
	IF errorlevel 0 GOTO END
) else (.\bin\windows\choice32.exe /T:Y,10 /c:YN
	IF errorlevel 2 GOTO END
	IF errorlevel 1 GOTO UNZIP
	IF errorlevel 0 GOTO END
)

:ENDNOWINBIN
echo.
echo /!\ Error /!\ - Winbin has not been found.
echo (FAILED trying to get it from http://svn.greenstone.org/main/trunk/binaries/windows/bin.)
echo Winbin is required to get the conversion tools used for importing different types of files.
echo For more info please visit this page:
echo http://wiki.greenstone.org/wiki/index.php/Installing_Greenstone_2_from_SVN_source_on_Windows#Getting_winbin
GOTO END

:ENDNOUNZIP
echo.
echo /!\ Error /!\ - Extacting tools are missing.
echo They are required to extract all packages needed for compilation.
echo These tools are contained in the Winbin folder, more info on this web page:
echo http://wiki.greenstone.org/wiki/index.php/Installing_Greenstone_2_from_SVN_source_on_Windows#Getting_winbin
GOTO END

:ENDNOWINPACK
echo.
echo /!\ Error /!\ - Windows packages are missing.
echo Some required packages are missing in .\common-src\packages\windows\
echo Please go to this page for more information on how to get everything:
echo http://wiki.greenstone.org/wiki/index.php/Installing_Greenstone_2_from_SVN_source_on_Windows
GOTO END

:ENDNOSQLITE
echo.
echo /!\ Error /!\ - SQLite is missing.
echo Some required packages are missing in .\common-src\packages\sqlite\
echo Please go to this page for more information on how to get everything:
echo http://wiki.greenstone.org/wiki/index.php/Installing_Greenstone_2_from_SVN_source_on_Windows
GOTO END

:ENDNOICONV
echo.
echo /!\ Error /!\ - Indexers are missing.
echo Some required packages are missing in .\common-src\indexers\packages\windows\
echo Please go to this page for more information on how to get everything:
echo http://wiki.greenstone.org/wiki/index.php/Installing_Greenstone_2_from_SVN_source_on_Windows
GOTO END

:ENDNOVCVARS32
echo.
echo /!\ Error /!\ - Not able to find 'vcvars32.bat'.
echo You need Visual Studio to compile the source code but we were
echo unable to find the file vcvars32.bat in your system.
echo.
echo Please edit this bat file and manually set the full path to 
echo vcvars32.bat then run this script again.
GOTO END

:ENDNOSDKENV
echo.
echo /!\ Error /!\ - Not able to find 'SetEnv.cmd'.
echo We were unable to find the SDK file SetEnv.cmd on your system.
echo You need Microsoft Platform SDK (which is available for free) to compile 
echo up the Apache web server. You also need it if you're working with
echo Microsoft Visual Studio 8 or higher.
echo.
echo If you already have it installed, please edit the makegs2.bat file and
echo manually set the full path to SetEnv.cmd, then run this script again.
echo If you have an older version of Visual Studio, then you do not need the
echo Platform SDK and can compile the Web and/or Local libraries up from the
echo DOS command prompt using:
echo	nmake /f win32.mak
echo and/or
echo	nmake /f win32.mak LOCAL_LIBRARY=1
GOTO END

:ENDOK
echo.
echo Done!
echo.
echo This program is free software; you can redistribute it and/or
echo modify it under the terms of the GNU General Public License
echo as published by the Free Software Foundation; either version 2
echo of the License, or (at your option) any later version.
echo.
echo This program is distributed in the hope that it will be useful,
echo but WITHOUT ANY WARRANTY; without even the implied warranty of
echo MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
echo GNU General Public License for more details.
echo.
GOTO END

:END
echo.
echo **** Note that this command prompt has been left in Short-Filename mode.
echo **** This can make command line building go weird, so please use a fresh
echo **** terminal for that.
echo.
popd
