###########################################################################
#
# win32 makefile -- hashfile
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################
 
GSDLHOME = ..\..\..
GSDL_VC4 = 0
DEBUG = 0

AR = lib
CC = cl

!IF $(DEBUG)
CXXFLAGS = -DEBUG -Z7 /errorReport:prompt
LDFLAGS = -DEBUG -Z7 /errorReport:prompt
!ELSE
CXXFLAGS =
LDFLAGS =
!ENDIF

!IF $(GSDL_VC4)
CXXFLAGS = $(CXXFLAGS) -GX
!ELSE
CXXFLAGS = $(CXXFLAGS) -EHsc
!ENDIF

DEFS = -DHAVE_CONFIG_H -D__WIN32__ -D_CRT_SECURE_NO_DEPRECATE
INCLUDES = -I"$(GSDLHOME)\src\hashfile"
LIBS =

COMPILE = $(CC) -nologo -c $(CXXFLAGS) $(DEFS) $(INCLUDES)
LINK = $(CC) -nologo $(LDFLAGS)

.SUFFIXES:
.SUFFIXES: .cpp .obj
.cpp.obj:
	$(COMPILE) $<

ANSI2KNR = 
o = .obj
e = .exe
 
HEADERS = 

SOURCES = hashfile.cpp

OBJECTS = hashfile$o

EXEC = hashfile$e
 
all : $(EXEC)

install: $(EXEC)
	if NOT EXIST "$(GSDLHOME)\bin\windows" mkdir "$(GSDLHOME)\bin\windows"
	copy $(EXEC) "$(GSDLHOME)\bin\windows"

clean:
	del *$o
	del $(EXEC)

HASHFILE_OBJS = hashfile$o

hashfile$e: $(HASHFILE_OBJS) $(LIBS)
	    $(LINK) $(HASHFILE_OBJS) $(LIBS)
