static char *help_str[] = {
"\n",
"			  HELP for mgquery\n",
"		   ================================\n",
"\n",
"The text is a summary of the information in the \"mgquery\" manual pages.\n",
"\n",
"The input to 'mgquery' consists of a series of input lines. The backslash\n",
"character (\"\\\") is used at the end of lines to indicate that input \n",
"continues on the next line.\n",
"\n",
"Input lines on which the first character is a dot (\".\") are commands to\n",
"the mgquery program. Input lines that do not start with a dot are queries.\n",
"\n",
"A query consists of two parts. One part is a boolean or ranked query that\n",
"identifies documents. The second part is a post-processing pattern matching\n",
"operation. Any text between the first speech mark (\") and the last speech\n",
"mark is considered to the a post-processing pattern. \n",
"\n",
"\n",
"The following command are available :-\n",
"\n",
"    .help	     - displays this text.\n",
"    .quit            - quits the program.\n",
"    .set name value  - sets parameter \"name\" to \"value\" . If the parameter\n",
"                       is a boolean parameter and value is omitted the\n",
"	    	       parameter will be inverted (i.e. if it is true it\n",
"		       will change to false, if it is false it will change\n",
"		       to true).\n",
"    .unset name      - deletes parameter \"name\"\n",
"    .reset           - sets all the parameters to their initial state.\n",
"    .display         - displays the values of all the current parameters.\n",
"    .push            - pushes the current parameters on to a stack.\n",
"    .pop             - destroys the current parameters and pops a new set\n",
"                       of parameters off the stack.\n",
"    .output arg      - This is used to specify where to send the documents.\n",
"                       Arg may one be of the following:\n",
"		       > filename  : Send output to the specified file.\n",
"		       >> filename : Append output to the specified file.\n",
"                       | command   : The output is piped into command, \n",
"                                     which is executed by sh.\n",
"    .input arg       - This is used to specify where input comes from.\n",
"                       Arg may one be of the following:\n",
"		       < filename  : Get the input from the specified\n",
"                                     file.\n",
"                       | command   : The input comes from the standard\n",
"                                     output of command, which is executed\n",
"                                     by sh.\n",
"\n",
"On startup the mgquery program reads from the file .mgrc a sequence \n",
"of commands (NOTE: The .mgrc file may not contain any queries). mgquery \n",
"first looks for .mgrc in the current directory and then in the users home \n",
"directory. Lines starting with a '#' in the .mgrc file are considered to\n",
"be comments and are ignored.\n",
"\n",
"The following parameters (used in the .set and .unset commands) are \n",
"predefined and have special significance :-\n",
"\n",
"accumulator_method = `array'\n",
"	This parameter is used during ranking, and specifies how the\n",
"	weight for each document should be accumulated. The following\n",
"	methods are available `array', `splay_tree', `hash_table', and\n",
"	`list'.\n",
"\n",
"briefstats = `off'\n",
"	This is a boolean parameter that determines whether the the\n",
"	totals for disk, memory and time usage statistics will be \n",
"	displayed. at the end of each query. \n",
"	NOTE: this takes precedence over the parameters \"diskstats\",\n",
"	\"memstats\" and \"timestats\". This parameter may take the values \n",
"	`yes', `no', `true', `false', `on' or `off'.\n",
"\n",
"buffer = `1048576'\n",
"	When the documents are being read in they are read into a \n",
"	buffer of this size and then displayed from this buffer. If \n",
"        the documents are larger than this buffer the buffer is\n",
"	expanded automatically. Having a large buffer gives a very\n",
"	slight performance improvement because it allows the order of \n",
"	disk operations to be optimised. The buffer size is measured\n",
"	in bytes.\n",
"\n",
"diskstats = `off'\n",
"	This is a boolean parameter that determines whether the disk\n",
"	usage statistics for the preceding query will be displayed\n",
"	after each query. This parameter may take the values `yes',\n",
"	`no', `true', `false', `on' or `off'.\n",
"\n",
"doc_sepstr = `---------------------------------- %n\\n'\n",
"	This specifies the string that will be used to separate \n",
"	documents when they are displayed for `boolean' or `docnums'\n",
"	queries. The standard C escape character sequences (see the \n",
"	man page) may be used to place special characters in the \n",
"	string. For example, a newline would the `\\n'. To include a `%'\n",
"	use the sequence `%%'. To include the MG document number use\n",
"	the sequence `%n'.\n",
"\n",
"expert = `false'\n",
"	If this is true then a lot of the waffle that the program \n",
"	spits out is suppressed. This parameter may take the values\n",
"	`yes', `no', `true', `false', `on' or `off'.\n",
"\n",
"hash_tbl_size = `1000'\n",
"	One of the options during ranking queries is to use a hash \n",
"	table to accumulate the weights for each document. The hash \n",
"	table is a simple chained type. This parameter specifies the \n",
"	size of the hash table and may take any value between 8 and\n",
"	268435456. \n",
"\n",
"heads_length = `50'\n",
"	When the mode is `heads' this specifies the number of \n",
"	characters that	will be output for each document.\n",
"\n",
"maxdocs = `all'\n",
"	The maximum number of documents to display in response to a\n",
"	query. This parameter may take on a numeric value between 1 \n",
"	and 429467295 or the word `all'.\n",
"\n",
"maxparas = `1000'\n",
"	The maximum number of paragraphs to identify during a ranked\n",
"	query with paragraph indexing. After the paragraphs have been\n",
"	identified the paragraphs are converted into documents, and \n",
"	because some of the paragraphs may refer to the same documents \n",
"	the final number of answers may be less that maxparas. The \n",
"	maxdocs parameter will then be applied. This parameter may \n",
"	take on a numeric value between 1 and 429467295.\n",
"\n",
"max_accumulators = `50000'\n",
"	This parameter limits the number of different paragraph/\n",
"	document numbers to be accumulated during ranked queries when \n",
"	the parameter `accumulator_method` is set to `splay_tree',\n",
"	`hash_table', or `list'.  This parameter may take any value \n",
"	between 8 and 268435456.\n",
"\n",
"max_terms = `all'\n",
"	This parameter limits the number of terms that will actually\n",
"	be used during a ranked query. If more terms than the number\n",
"	specified by max_terms are entered, then the extra terms will\n",
"	be discarded. If `sorted_terms' is on then the limiting will \n",
"	be done after the terms have been sorted. This parameter may\n",
"	take any value between 1 and 429467295 or the word `all'.\n",
"\n",
"memstats = `off'\n",
"	This is a boolean parameter that determines whether the memory \n",
"	usage statistics for the preceding query will be displayed\n",
"	after each query. This parameter may take the values `yes', \n",
"	`no', `true', `false', `on' or `off'.\n",
"\n",
"mgdir = `.'\n",
"	This specifies the directory where the MG files may be found.\n",
"	If the environment variable `MGDATA' is set then `mgdir' is\n",
"	initialised to the value in `MGDATA'.\n",
"\n",
"mgname = `'\n",
"	This specifies the name of the MG database to process.\n",
"\n",
"mode = `text'\n",
"	This specifies how documents should be displayed when they\n",
"	are retrieved it may take four different values `text', \n",
"	`docnums', `silent', `heads' or `count'. `text' displays \n",
"	the contents of the document. `docnums' displays only the\n",
"	document numbers. `Silent' retrieves all the documents but\n",
"	displays nothing except how many documents were retrieved.\n",
"	This mode is intended to be used in timing experiments. \n",
"	`Heads` is used to print out the head of each document.\n",
"	`Count' does the minimum amount of work required to determine\n",
"	how many documents would be retrieved, but does not retrieve\n",
"	them.\n",
"\n",
"pager = `more'\n",
"	This is the name of the program that will be used to display\n",
"	the help and the retrieved documents. If the environment \n",
"	variable \"PAGER\" is defined then `pager' takes on that value.\n",
"\n",
"para_sepstr = `\\n######## PARAGRAPH %n ########\\n'\n",
"	This specifies the string that will be used to separate \n",
"	paragraphs. The standard C escape character sequences (see the \n",
"	man page) may be used to place special characters in the \n",
"	string. For example, a newline would the `\\n'. To include a `%'\n",
"	use the sequence `%%'. To include the paragraph number within\n",
"	the document use the sequence `%n'.\n",
"\n",
"para_start = `***** Weight = %w *****\\n'\n",
"	This specifies the string that will be used at the head of \n",
"	paragraphs for a paraghaph level index following a ranked query.\n",
"	The standard C escape character sequences (see the man page)\n",
"	may be used to place special characters in the string. For \n",
"	example, a newline would the `\\n'. To include a `%' use the\n",
"	sequence `%%'. To include the paragraph weight use the \n",
"	sequence `%w'.\n",
"\n",
"qfreq = `true'\n",
"	This determine whether the ranked queries will take into \n",
"	account the number of times each query term is specified.\n",
"	When this is `true' the number of times a term appears in\n",
"	the query is used in the ranking. When this is `false' all \n",
"	query term are assumed to occur only once. This parameter\n",
"	may take the values `yes', `no', `true', `false', `on' or\n",
"	`off'.\n",
"\n",
"query = `boolean'\n",
"	This specifies the type of queries that are to be specified.\n",
"	It can take four different values `boolean', `ranked', \n",
"	`docnums' or `approx-ranked'. \n",
"\n",
"	`boolean' is for boolean queries. \n",
"		The yacc grammar for boolean queries is as follows :-\n",
"\n",
"		query   : or;\n",
" \n",
"		or      : or '|' and\n",
"		        | and ;	\n",
" \n",
"		and     : and '&' not\n",
"        		| and not\n",
"        		| not ;\n",
"\n",
"		not     : term\n",
"		        | '!' not ;\n",
" \n",
"		term    : TERM\n",
"		        | '(' or ')' ;\n",
" \n",
"\n",
"\n",
"\n",
"	`ranked' and `approx-ranked' are for queries ranked by the\n",
"		cosine measure. `approx-ranked' uses only the low\n",
"		precision document lengths, and therefore only\n",
"		produces an approximation to full cosine ranking.\n",
"\n",
"		query   : TERM\n",
"      			| query TERM ;\n",
"	\n",
"	`docnums' allows the entry of document numbers. Multiple \n",
"		numbers separated by spaces may be specified\n",
"		or ranges separated by hyphens.\n",
"\n",
"\n",
"		query   : range\n",
"			| query range ;\n",
"\n",
"\n",
"		range   : num\n",
"			| num '-' num ;\n",
"\n",
"\n",
"ranked_doc_sepstr = `---------------------------------- %n %w\\n'\n",
"	This specifies the string that will be used to separate \n",
"	documents when they are displayed for `ranked' or \n",
"	`approx-ranked'	queries. The standard C escape character \n",
"	sequences (see the man page) may be used to place special\n",
"	characters in the string. For example, a newline would the\n",
"	`\\n'. To include a `%' use the sequence `%%'. To include the\n",
"	MG document number use the sequence `%n'. To include the\n",
"	document weight use the sequence `%w'.\n",
"\n",
"sizestats = `false'\n",
"	If this is true then various numbers are output at the end\n",
"	of each query indicating what went on during the query. \n",
"	This parameter may take the values `yes', `no', `true', \n",
"	`false', `on' or `off'.\n",
"\n",
"skip_dump = `skips.%d'\n",
"	If this parameter is set then during ranked queries on skipped\n",
"	inverted files when `accumulator_method' is set to `splay_tree',\n",
"	`hash_table', or `list` a file will be produced in the current\n",
"	directory. The name of the file is the value of this parameter,\n",
"	a `%d' in the file name will be replaced with the process id of\n",
"	mgquery. This file will contain information about the usage of\n",
"	skips during the query processing. This option is expensive; \n",
"	use `.unset skip_dump' to obtain optimal performance.\n",
"\n",
"sorted_terms = `on'\n",
"	This specifies whether of not the terms should be sorted into\n",
"	decreasing occurrence in documents so that the least often\n",
"	occurring terms are processed first when ranked queries are\n",
"	being done. When this is true the terms are sorted. When this\n",
"	is false the terms are not sorted and are instead processed in\n",
"	order of occurrence. This parameter may take the values `yes',\n",
"	`no', `true', `false', `on' or `off'.\n",
"\n",
"\n",
"stop_at_max_accum = `on'\n",
"	This specifies what should happen when the maximum number of\n",
"	accumulators set by `max_accumulators' is reached. When this\n",
"	is true the the processing of terms is stopped at the completion\n",
"	of the current term. When this is false processing continues but\n",
"	no new accumulators are created. This parameter may take the \n",
"	values `yes', `no', `true', `false', `on' or `off'.\n",
"\n",
"terminator = `'\n",
"	This specifies the string that will be output after the	last\n",
"	document from the previous query has been output. The standard\n",
"	C escape character sequences (see the man page) may be used to\n",
"	place special characters in the string. For example, a newline\n",
"	would the `\\n'. To include a `%' use the sequence `%%'.\n",
"	\n",
"\n",
"timestats = `false'\n",
"	If this is true then the time to process a query is displayed\n",
"	in both real time and CPU time. This parameter may take the\n",
"	values `yes', `no', `true', `false', `on' or `off'.\n",
"\n",
"verbatim = `off'\n",
"	This is a boolean parameter that determines whether the program\n",
"	should attempt to do a regular expression match on the retrieved\n",
"	text. If verbatim is `on' and a post-processing strng is specified\n",
"	with the query then the post-processing string will be searched for\n",
"	in the documents just before they are displayed. If the string is\n",
"	found the document will be displayed, if not the document will not\n",
"	be displayed. If verbatim is `off' the post-processing string will\n",
"	be considered a regular expression like in `vi' or `egrep'.\n",
"	E.G. If verbatim is `on', \"and.*the\" will look for the 8 character\n",
"	     sequence \"and.*the\". If verbatim is `off', \"and.*the\" will\n",
"	     look for the sequence \"and\" followed somewhere later in the\n",
"	     document by the sequence \"the\".\n",
"	This parameter may take the values `yes', `no', `true', `false',\n",
"	`on' or `off'.\n",
"\n",
"\n"};
