/**************************************************************************
 *
 * FragLevelConvert.h -- converting between fragment and document numbers
 * Copyright (C) 1999  Rodger McNab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef FRAGLEVELCONVERT_H
#define FRAGLEVELCONVERT_H

#include "mglong.h"
#include <stdio.h>
#include "UCArray.h"

/*Notes about levelStarts (kjm18) - this is my interpretation of
whats going on, feel free to correct this if its wrong.

say you have 5 docs, consisting of fragments:
1:  1-55
2: 56-83
3: 84-106
4: 107-152
5: 153-211

then levelStarts would have the values
0  1  2   3   4   5 
0  55 83 106 152 211

*/
class FragLevelConvert {
protected:
  // note fragment start is one before before real start
  vector<mg_u_long> levelStarts;
  mg_u_long numFrags;
  mg_u_long numLevelDocs;
  
public:
  FragLevelConvert ();

  bool Read (FILE *invfFile, mg_u_long levelPtr,
	     mg_u_long _numFrags, mg_u_long _numLevelDocs);

  bool FragToLevel (mg_u_long fragNum, mg_u_long &levelDocNum) const;

  // this function converts from one level number to another
  // the FragLevelConvert thats calling the method should be loaded with
  // the level that you want to convert to, while the sectionLevelConvert
  // should be loaded with the level converting from.
  // level Num has the old level, DocNum will be returned with the new
  // coresponding level
  bool LevelToLevel (FragLevelConvert sectionLevelConvert,
		   mg_u_long levelNum, mg_u_long &DocNum);
};


#endif
