/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Author: John Thompson and David Bainbridge, 
 *         Greenstone Digital Library, University of Waikato
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer;

import java.io.*;
import org.greenstone.gatherer.util.StaticStrings; 
import org.greenstone.gatherer.util.Utility;

public class GetOpt
{
    public boolean testing_mode = false; // true if running GLI for tutorial testing: want names assigned to GUI components
    
    public boolean debug = false;
    public boolean feedback_enabled = false;
    public boolean no_load = false;
    public boolean use_remote_greenstone = false;
    public boolean webswing = false;
    public boolean new_set = false;
    public boolean run_gsdl3 = false;

    public String client_operating_system = null;
    public String collect_directory_path = null;
    public String filename = null;
    public String gliserver_url_string = null;
    public String gsdl_path = null;
    public String gsdl3_web_path = null;
    public String gsdl3_writableweb_path = null;
    public String gsdl3_src_path = null;
    public String library_url_string = null;
    public String local_library_path = null;
    public String perl_path = null;
    public String site_name = null; // for GS3
    public String servlet_path = null;
    public String metadata_path = null;
  public String language = null;
  
    protected FedoraInfo fedora_info = null;

    public String userJSessionID = null;
    public String username = null;
    public String usergroups = null;
    
    public GetOpt(String[] args)
    {
	// Default dictionary. Only used for starting error messages.
	Dictionary dictionary = new Dictionary(null, null); 

	fedora_info = new FedoraInfo();

	// Parse arguments
	int argument_index = 0;
	String next_token = null;

	while(argument_index < args.length || next_token != null) {
	    // 1. We start by attempting to parse an argument name. An argument
	    //    must start with a '-', and should not contain spaces. If
	    //    anything else is encountered it is ignored.

	    String argument_name = null;
	    if(next_token == null) {
		next_token = args[argument_index];
		argument_index++;
	    }

	    if(next_token.startsWith(StaticStrings.MINUS_CHARACTER)) {
		// Trim second '-' just to be kind to Unixy-type people
		if(next_token.startsWith(StaticStrings.MINUS_CHARACTER + StaticStrings.MINUS_CHARACTER)) {
		    argument_name = next_token.substring(1);
		}
		else {
		    argument_name = next_token;
		}
	    }
	    next_token = null;
	    // 2. If we now have an argument name we continue by attempting
	    //    to parse a value. A value is taken to be the sequence of
	    //    space seperated Strings between the last argument name
	    //    and up to but not including the next argument name. Of
	    //    course an argument needn't have any value (ie -debug,
	    //    -help), in which case value will be null.
	    if(argument_name != null) {
		String argument_value = null;
		StringBuffer argument_value_buffer = new StringBuffer("");
		while(argument_index < args.length && next_token == null) {
		    next_token = args[argument_index];
		    argument_index++;
		    // If we just parsed an arbitary String then append it to value, followed by a single space
		    if(!next_token.startsWith(StaticStrings.MINUS_CHARACTER)) {
			argument_value_buffer.append(next_token);
			argument_value_buffer.append(StaticStrings.SPACE_CHARACTER);
			next_token = null;
		    }
		    // If the argument token retrieved is an argument name,
		    // then leave it in next_token, which will cause the
		    // argument parsing process to move onto the next step.
		}
		// If a value now exists in argument buffer, retrieve
		// it. Remove the last character as it will be an erroneous
		// space.
		if(argument_value_buffer.length() > 0) {
		    argument_value = argument_value_buffer.substring(0, argument_value_buffer.length() - 1);
		}
		
		// 3. We now have the argument name, and any associated
		//    value. We are ready to store the data in the
		//    appropriate variables.
		DebugStream.println("Parsed Argument: name=" + argument_name + (argument_value != null ? (", value=" + argument_value) : ", no value"));
		// 3a. First those arguments that have no associated value
		if(argument_value == null) {
		    if(argument_name.equals(StaticStrings.HELP_ARGUMENT)) {
			System.out.println(Dictionary.get("General.Usage"));
			System.exit(0);
		    }
		    // Run GLI in testing mode. Will assign names to GUI Components
		    else if(argument_name.equals(StaticStrings.TESTING_ARGUMENT)) {
			testing_mode = true;
		    }
		    // Run GLI in debug mode. Produces debug log plus extra
		    // messages.
		    else if(argument_name.equals(StaticStrings.DEBUG_ARGUMENT)) {
			debug = true;
		    }
		    // Run GLI with feedback enabled. 
		    else if(argument_name.equals(StaticStrings.FEEDBACK_ARGUMENT)) {
			feedback_enabled = true;
		    }
		    // Forces no loading on previous collection.
		    else if(argument_name.equals(StaticStrings.NO_LOAD_ARGUMENT)) {
			no_load = true;
			filename = null;
		    }
		    // Use a remote Greenstone rather than a local one
		    else if (argument_name.equals(StaticStrings.USE_REMOTE_GREENSTONE_ARGUMENT)) {
			use_remote_greenstone = true;
			//Use a remote Greenstone
		    }
		    // We are running inside webswing
		    else if (argument_name.equals(StaticStrings.WEBSWING_ARGUMENT)) {
			webswing = true;
		    }
//		    else if (argument_name.equals(StaticStrings.GSDL3_WEB_ARGUMENT)){
//			//Use a remote Greenstone3
//			run_gsdl3=true;
//		    }
		    else if (argument_name.equals(StaticStrings.NEW_METADATASET)) {
			new_set = true;
		    }
		    else if(argument_name.equals(StaticStrings.FEDORA_MODE)) {
			// Running FLI remotely
			fedora_info.setActive(true);
		    }
		}
		// 3b. Now for those that do
		else {
		    // Parse the path to the GSDL. Required argument.
		    if(argument_name.equals(StaticStrings.GSDL_ARGUMENT)) {
			if(argument_value.endsWith(File.separator)) {
			    gsdl_path = argument_value;
			}
			else {
			    gsdl_path = argument_value + File.separator;
			}
		    }
		    // GSDL3 paths
                    // web folder containing sites
		    if(argument_name.equals(StaticStrings.GSDL3_WEB_ARGUMENT)) {
			if(argument_value.endsWith(File.separator)) {
			    gsdl3_web_path = argument_value;
			}
			else {
			    gsdl3_web_path = argument_value + File.separator;
			}
		    }
                    //web folder containing WEB-INF
		    if(argument_name.equals(StaticStrings.GSDL3_WRITABLEWEB_ARGUMENT)) {
			if(argument_value.endsWith(File.separator)) {
			    gsdl3_writableweb_path = argument_value;
			}
			else {
			    gsdl3_writableweb_path = argument_value + File.separator;
			}
		    }
		    // GSDL3 src path
		    if(argument_name.equals(StaticStrings.GSDL3_SRC_ARGUMENT)) {
			if(argument_value.endsWith(File.separator)) {
			    gsdl3_src_path = argument_value;
			}
			else {
			    gsdl3_src_path = argument_value + File.separator;
			}
		    }
		    // Client operating system
		    else if (argument_name.equals(StaticStrings.GSDLOS_ARGUMENT)) {
			client_operating_system = argument_value;
		    }
		    
		    else if (argument_name.equals(StaticStrings.SITE_ARGUMENT)) {
			site_name = argument_value;
		    }
		    else if (argument_name.equals(StaticStrings.SERVLET_ARGUMENT)) {
			if (argument_value.startsWith(StaticStrings.URL_SEPARATOR_CHARACTER)) {
			    servlet_path = argument_value;
			} else {
			    servlet_path = StaticStrings.URL_SEPARATOR_CHARACTER + argument_value;
			}
		    }
		    // Specify a non-standard collect directory to use (for running one GLI in a network environment)
		    else if (argument_name.equals(StaticStrings.COLLECTDIR_ARGUMENT)) {
			collect_directory_path = argument_value;
			System.err.println("Non standard collect directory specified: " + collect_directory_path);
		    }
		    // Specify a collection to load initially. Could be used for file associations.
		    else if(argument_name.equals(StaticStrings.LOAD_ARGUMENT)) {
			filename = argument_value;
			no_load = false;
		    }
		    // If logged in userdata specified: -username <user> -groups <grps> -uid JSESSIONID
		    else if(argument_name.equals(StaticStrings.USERNAME_ARGUMENT)) {
			username = argument_value;
		    }
		    else if(argument_name.equals(StaticStrings.USERGROUPS_ARGUMENT)) {
			usergroups = argument_value;
		    }
		    else if(argument_name.equals(StaticStrings.USERID_ARGUMENT)) {
			userJSessionID = argument_value;
		    }
		    // Parse the file path of the local library server
		    else if (argument_name.equals(StaticStrings.LOCAL_LIBRARY_ARGUMENT)) {
			local_library_path = argument_value;
		    }
		    // Manually specify the Greenstone library URL
		    else if (argument_name.equals(StaticStrings.LIBRARY_URL_ARGUMENT)) {
			library_url_string = argument_value;
		    }
		    // Specify the URL to the gliserver CGI script for remote collection building
		    else if (argument_name.equals(StaticStrings.GLISERVER_URL_ARGUMENT)) {
			gliserver_url_string = argument_value;
		    }
                    else if (argument_name.equals(StaticStrings.LANGUAGE_ARGUMENT)) {
                      language = argument_value;
                    }
		    // Parse the path to PERL. If not provided it assumes
		    // perl should be available on the PATH.
		    else if(argument_name.equals(StaticStrings.PERL_ARGUMENT)) {
			perl_path = argument_value;
			// Test whether this points to the Perl bin
			// directory or the Perl executable itself.
			File perl_file = new File(perl_path);
			if(perl_file.isDirectory()) {
			    // If this is windows we create a child file
			    // perl.exe, otherwise we create perl
			    if(Utility.isWindows()) {
				perl_file = new File(perl_file, Utility.PERL_EXECUTABLE_WINDOWS);
			    }
			    else {
				perl_file = new File(perl_file, Utility.PERL_EXECUTABLE_UNIX);
			    }
			    // And store this new path.
			    perl_path = perl_file.getAbsolutePath();
			    perl_file = null;
			}
			// Otherwise it is fine as it is
		    }
                    else if(argument_name.equals(StaticStrings.METADATA_PATH)){
			if (argument_value != null && !argument_value.equals("")) {
			    File metadata_file = new File(argument_value);
			    if (metadata_file.exists()) {
				metadata_path = argument_value;
			    } 
			}
		    }

		    // Fedora home - when running Fedora locally
		    if(argument_name.equals(StaticStrings.FEDORA_HOME)) {
			if(argument_value.endsWith(File.separator)) {
			    fedora_info.setHome(argument_value);
			}
			else {
			    fedora_info.setHome(argument_value + File.separator);
			}
		    }

		    if(argument_name.equals(StaticStrings.FEDORA_VERSION)) {
			fedora_info.setVersion(argument_value);
		    }
		    
		    // Fedora hostname
		    if(argument_name.equals(StaticStrings.FEDORA_HOSTNAME)) {
			if(argument_value.endsWith(File.separator)) {
			    fedora_info.setHostname(argument_value);
			}
			else {
			    fedora_info.setHostname(argument_value + File.separator);
			}
		    }
		    // Fedora port
		    if(argument_name.equals(StaticStrings.FEDORA_PORT)) {
			if(argument_value.endsWith(File.separator)) {
			    fedora_info.setPort(argument_value);
			}
			else {
			    fedora_info.setPort(argument_value + File.separator);
			}
		    }
		    // Fedora username
		    if(argument_name.equals(StaticStrings.FEDORA_USERNAME)) {
			if(argument_value.endsWith(File.separator)) {
			    fedora_info.setUsername(argument_value);
			}
			else {
			    fedora_info.setUsername(argument_value + File.separator);
			}
		    }
		    // Fedora password
		    if(argument_name.equals(StaticStrings.FEDORA_PASSWORD)) {
			if(argument_value.endsWith(File.separator)) {
			    fedora_info.setPassword(argument_value);
			}
			else {
			    fedora_info.setPassword(argument_value + File.separator);
			}
		    }
		    // Fedora protocol, e.g. http or https
		    if(argument_name.equals(StaticStrings.FEDORA_PROTOCOL)) {
			if(argument_value.endsWith(File.separator)) {
			    fedora_info.setProtocol(argument_value);
			}
			else {
			    fedora_info.setProtocol(argument_value + File.separator);
			}
		    }




                  
		}
	    }
	    // Argument name was null, nothing to be done.
	}
	next_token = null;
	// Arguments all parsed.
    }
}
