/** This class is not currently used and therefore will not be compiled by makegli. */

package org.greenstone.gatherer.feedback;

import javax.swing.*;
import javax.swing.text.*;
import java.util.Date;
import java.awt.Color;

/**
 * This class will allow us to changed what should be inputted to the 
 * text area as the user inputted the text to the text area.
 * @author Veronica Liesaputra
 */
public class MyTextArea extends JTextArea 
{
    /**
     * Creating an empty JTextArea.
     */
    public MyTextArea ()
    {
	super();
    }

    /**
     * Creating a JTextArea already appended with cols.
     * (Precondition: (cols != null))
     * @param cols the text to be appended.
     */
    public MyTextArea(String cols) 
    {
	super(cols);
    }
 
    /**
     * It will give the default model this text area should use.
     * @return the default model this text area used.
     */
    protected Document createDefaultModel() 
    {
	return new UpperCaseDocument();
    }
 
    /**
     * This class will be used as the default model of MyTextArea.
     * Here we can control and modified the string that is going to be inserted to 
     * the document.
     */
    static class UpperCaseDocument extends PlainDocument 
    {
	/**
	 * This method will caused the document to be appended with the date followed by newline
	 * everytime user trying to insert a new line to the document.
	 * (Precondition : (offs >= 0) && (str != null))
	 * @param offs is the offset placted to insert the string.
	 * @param str is the string to be inserted.
	 * @param a is the attribute set to be used.
	 */
	public void insertString(int offs, String str, AttributeSet a) 
	    throws BadLocationException 
	{
	    if (str == null) 
		{
		    return;
		}
	    
	    char[] upper;
	    upper = str.toCharArray();

	    if (str.endsWith("\n") == true)
		{
		    String str2;
		    str2 = str + ((new Date()).toString()) + "\n\n>";
		    upper = str2.toCharArray();
		}
	   
	    super.insertString(offs, new String(upper), a);
	}
    }
}





