/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * <BR><BR>
 *
 * Author: Katherine Don, Greenstone Digital Library, University of Waikato
 *
 * <BR><BR>
 *
 * Copyright (C) 2006 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.gems;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;

public class NewMetadataElementNamePrompt
    extends ModalDialog {
    private Dimension SIZE = new Dimension(350, 120);

    private boolean cancelled = false;
    private String element_name = null;
    private JTextField name_textfield = null;
    private JDialog prompt;
    private Object model;
    public NewMetadataElementNamePrompt(Frame parent, boolean subelement, Object model) {
	super(parent, true);
	setSize(SIZE);
	prompt = this;
	this.model = model;
	JPanel content_pane = (JPanel) getContentPane();
	content_pane.setOpaque(true);
        content_pane.setComponentOrientation(Dictionary.getOrientation());
        
	JLabel name_label = new JLabel();
	name_label.setComponentOrientation(Dictionary.getOrientation());
        if (subelement) {
	    setTitle(Dictionary.get("GEMS.NewMetadataElementNamePrompt.SubTitle"));
	    name_label.setText(Dictionary.get("GEMS.NewMetadataElementNamePrompt.SubName"));
	} else {
	    setTitle(Dictionary.get("GEMS.NewMetadataElementNamePrompt.Title"));
	    name_label.setText(Dictionary.get("GEMS.NewMetadataElementNamePrompt.Name"));
	}

	name_textfield = new JTextField();
        name_textfield.setComponentOrientation(Dictionary.getOrientation());
	name_textfield.addKeyListener(new KeyAdapter() {
		public void keyPressed(KeyEvent e) {
		    if (e.getKeyCode() == KeyEvent.VK_ENTER) {
			//same as clicking OK button
			validateElementName();
		    }
		}
	    });

	JPanel details_pane = new JPanel();
        details_pane.setComponentOrientation(Dictionary.getOrientation());
	details_pane.setLayout(new GridLayout(2,1));
	details_pane.add(name_label);
	details_pane.add(name_textfield);
	    
	JPanel button_pane = new JPanel();
	button_pane.setLayout(new GridLayout(1,2));
	GLIButton ok_button = new GLIButton(Dictionary.get("General.OK"), Dictionary.get("General.OK_Tooltip"));       	
	GLIButton cancel_button = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Cancel_Tooltip"));
	button_pane.add(ok_button);
	button_pane.add(cancel_button);
	    
	// Add listeners
	ok_button.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent event) {
		    validateElementName();
		}
	    });
	cancel_button.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent event) {
		    cancelled = true;
		    prompt.dispose();
		}
	    });
	    
	content_pane.setLayout(new BorderLayout(5,5));
	content_pane.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
	content_pane.add(details_pane, BorderLayout.CENTER);
	content_pane.add(button_pane, BorderLayout.SOUTH);
	    
	Dimension screen_size = Configuration.screen_size;
	setLocation((screen_size.width - SIZE.width) / 2, (screen_size.height - SIZE.height) / 2);
	setVisible(true);
	    
    }

    public String getName() {
	return element_name;
    }

    public boolean isCancelled() {
	return cancelled;
    }

    private void validateElementName() {
	String name = name_textfield.getText();
	if (name.equals("")) {
	    JOptionPane.showMessageDialog(prompt,Dictionary.get("GEMS.NewMetadataElementNamePrompt.EmptyName_Error_Message"), Dictionary.get("GEMS.NewMetadataElementNamePrompt.Name_Error"), JOptionPane.ERROR_MESSAGE);
	    return;
	} 
	boolean already_used = false;
	if (model instanceof MetadataSetModel) {
	    already_used = ((MetadataSetModel)model).doesChildWithThisNameExist(name);
	} else if (model instanceof MetadataElementModel) {
	    already_used = ((MetadataElementModel)model).doesChildWithThisNameExist(name);
	}
	if (!already_used) {
	    element_name = name;
	    prompt.dispose();
	} else {
	    JOptionPane.showMessageDialog(prompt,Dictionary.get("GEMS.NewMetadataElementNamePrompt.Name_Error_Message"), Dictionary.get("GEMS.NewMetadataElementNamePrompt.Name_Error"), JOptionPane.ERROR_MESSAGE);
	}
    }
}
