/* ------------------------------------------------------------------- */
/* sweMARC    : Convert a metatag struct to LIBRISMARC                 */
/*                                                                     */
/* Author     : Ole Husby                                              */
/* Last update: 1998-09-30                                             */
/* ------------------------------------------------------------------- */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "d2m.h" 




/* ---------------------------------------------------------------------- */
/* Decides on first indicator for personal name                           */
/*                                                                        */
/* f : no comma                                                           */
/* e : comma, with only one word preceeding                               */
/* s : comma, with more than one word preceeding (delimiter blank or "-") */
/* ---------------------------------------------------------------------- */

int personal_indicator(char *pname)
{
  char *comma, *blank, *hyphen;

  comma = strstr(pname, ",");
  if (!comma)
    return (int) 'f';

  blank = strstr(pname, " ");
  hyphen = strstr(pname, "-");

  if ( (blank && blank < comma) || (hyphen && hyphen < comma) )
    return (int) 's';
  else
    return (int) 'e';
}



/* ---------------------------------------------------------------------- */
/* Decides tag for type                                                   */
/* ---------------------------------------------------------------------- */

int parse_swetype(char *str, char *tag)
{
   if ( (strcasecmp(str, "diss."             ) == 0) 
     || (strcasecmp(str, "dissertation"      ) == 0) 
     || (strcasecmp(str, "thesis"            ) == 0) 
     || (strcasecmp(str, "domkap.avh."       ) == 0) 
     || (strcasecmp(str, "hab.-schr"         ) == 0) 
     || (strcasecmp(str, "prstmsteavh."    ) == 0)
     || (strcasecmp(str, "avhandling"        ) == 0) ) 
     strcpy(tag, "502");
   else
     strcpy(tag, "500");

   return 1;
}


/* ---------------------------------------------------------------------- */
/* sweMARC()                                                              */
/* ---------------------------------------------------------------------- */

int sweMARC(struct metatag *mt, struct marcrec *mr)
{
  char pre[64], creator_tag[4], type_tag[4];
  int ind1;

  *pre = 0;

  if (strcasecmp(mt->name, "title") == 0)
  {
    if ( (!*mt->type)
         | (strcasecmp(mt->type, "main") == 0)
         | (strcasecmp(mt->type, "long") == 0) )
    {
      if (mr->ntitles)
        strcpy(pre, "740  $a");
      else
      {
        mr->ntitles++;
        strcpy(pre, "245  $a");
      }
    }
  }


  else if (strcasecmp(mt->name, "creator") == 0)
  {
    if (!*mt->type)
      strcpy(pre, "720  $a");
    else if (strcasecmp(mt->type, "personal") == 0) 
    {
      ind1 = personal_indicator(mt->value);
      if (mr->ncreators)
        strcpy(creator_tag, "700");
      else
      {
        strcpy(creator_tag, "100");
        mr-> ncreators++;
      }
      sprintf(pre, "%s%c $a", creator_tag, ind1);
    }
    else if (strcasecmp(mt->type, "corporate") == 0)
    {
      if (mr->ncreators)
        strcpy(creator_tag, "710");
      else
      {
        strcpy(creator_tag, "110");
        mr-> ncreators++;
      }
      sprintf(pre, "%sc $a", creator_tag);
    }
  }


  else if (strncasecmp(mt->name, "contributor", 11) == 0)     /* Note both pl and sgl allowed */
  {
    if (!*mt->type)
      strcpy(pre, "720  $a");
    else if (strcasecmp(mt->type, "personal") == 0) 
    {
      ind1 = personal_indicator(mt->value);
      sprintf(pre, "700%cm$a", ind1);
    }
    else if (strcasecmp(mt->type, "corporate") == 0)
      strcpy(pre, "710  $a");
  }


  else if (strcasecmp(mt->name, "publisher") == 0)          /* Note both should go to same tag! */
  {
    if (!*mt->type)
      strcpy(pre, "260  $b");
    else if (strcasecmp(mt->type, "email") == 0)
      strcpy(pre, "260  $d");
  }



  else if (strcasecmp(mt->name, "description") == 0)
    strcpy(pre, "520  $a");



  else if (strcasecmp(mt->name, "coverage") == 0)
  {
    if (!*mt->type)
      strcpy(pre, "500  $a");
    else if (strcasecmp(mt->type , "spatial") == 0)
      strcpy(pre, "651  $a");
    else if (strcasecmp(mt->type,  "temporal") == 0)
      strcpy(pre, "650  $a");
  }

  else if (strcasecmp(mt->name, "source") == 0)
    strcpy(pre, "786  $a");


  else if (strcasecmp(mt->name, "relation") == 0)
    strcpy(pre, "787  $a");


  else if (strcasecmp(mt->name, "rights") == 0)
  {
    if (!*mt->scheme)
      strcpy(pre, "500  $a");
    if (strcasecmp(mt->scheme, "url") == 0)
      strcpy(pre, "856  $u");
    if (strcasecmp(mt->scheme, "urn") == 0)
      strcpy(pre, "856  $g");
  }

  else if (strcasecmp(mt->name, "identifier") == 0)
  {
    if (!*mt->scheme)
      strcpy(mr->url, mt->value);
    else if (strcasecmp(mt->scheme, "url") == 0)
      strcpy(mr->url, mt->value);
    else if (strcasecmp(mt->scheme, "urn") == 0)
      strcpy(pre, "856  $g");
    else if (strcasecmp(mt->scheme, "ismn") == 0)
      strcpy(pre, "538  $a ISMN $b");
    else if (strcasecmp(mt->scheme, "sici") == 0)
      strcpy(pre, "538  $a SICI $b");
    else 
      sprintf(pre, "538  $a %s $b", mt->scheme);
  }

  else if (strcasecmp(mt->name, "type") == 0)
  {
    parse_swetype(mt->value, (char *) type_tag);
    sprintf(pre, "%s  $a", type_tag);
  }

  else if (strcasecmp(mt->name, "language") == 0)
  {
    strcpy(pre, "506  $a");
    if (strcasecmp(mt->scheme, "z39.53") == 0)
      put008(mr->s008, mt->value, F008_LANGUAGE);
  }

  else if (strcasecmp(mt->name, "format") == 0)
  {
    if ( (!*mt->scheme)
      || (strcasecmp(mt->scheme, "imt") == 0)
      || (strcasecmp(mt->scheme, "mime") == 0) )
      strcpy(pre, "856  $q");
  }

  else if (strcasecmp(mt->name, "subject") == 0)
  {
    if (!*mt->scheme)
      strcpy(pre, "697  $a");
    else if (strcasecmp(mt->scheme, "udc") == 0)
      strcpy(pre, "080  $a");
    else if (strcasecmp(mt->scheme, "lcsh") == 0)
      strcpy(pre, "650  $a");
    else if (strcasecmp(mt->scheme, "ddc") == 0)
      strcpy(pre, "082  $a");
    else if (strcasecmp(mt->scheme, "lcc") == 0)
      strcpy(pre, "087  $a");
    else if (strcasecmp(mt->scheme, "sab") == 0)
      strcpy(pre, "081  $a");
    else if (strcasecmp(mt->scheme, "mesh") == 0)
      strcpy(pre, "660  $a");
    else
      strcpy(pre, "650  $a");
  }

  else if (strcasecmp(mt->name, "date") == 0)
  {
    if ( (!*mt->type) || ( strcasecmp(mt->type, "current") == 0) )
    {
      if ( (strncasecmp(mt->scheme, "ans", 3) == 0) 
         || (strncasecmp(mt->scheme, "iso", 3) == 0) )
      {
        if (find_year(mt->value))
        {
          strcpy(mr->year, mt->value);
          put008(mr->s008, mt->value, F008_DATE1);
        }
      }
    }
  }

  if (*pre)
  {
    strcat(mr->marcline, pre);
    strcat(mr->marcline, " ");
    strcat(mr->marcline, mt->value);
    strcat(mr->marcline, "\n");
  }
}
