/**********************************************************************
 *
 * oaidispatcher.h --
 *
 * Copyright (C) 2004-2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "oaiaction.h"

#if defined(GSDL_USE_OBJECTSPACE)
#  include <ospace\std\map>
#elif defined(GSDL_USE_STL_H)
#  include <map.h>
#else
#  include <map>
#endif

typedef map<text_t, oaiaction *, lttext_t> oaiactionmap;

class oaidispatcher
{
 private:
  oaiactionmap actions;
  oaiconfig   *configuration;
 public:
  oaidispatcher();
  ~oaidispatcher();
  void setConfiguration(oaiconfig *configuration) { this->configuration = configuration; }
  void addAction(oaiaction *thisAction);
  void doAction(ostream &stream, recptproto *protocol, oaiargs &args);
};
