/**********************************************************************
 *
 * rfc1807.cpp --
 *
 * Copyright (C) 2004-2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "rfc1807.h"

rfc1807::rfc1807() : metaformat(){
  // These element names taken from the schema
  // http://www.openarchives.org/OAI/1.1/rfc1807.xsd
  elementSet.insert("bib-version");
  elementSet.insert("id");
  elementSet.insert("entry"); 
  elementSet.insert("organization");
  elementSet.insert("title");
  elementSet.insert("type");
  elementSet.insert("revision");
  elementSet.insert("withdraw");
  elementSet.insert("author"); 
  elementSet.insert("corp-author");
  elementSet.insert("contact"); 
  elementSet.insert("date");
  elementSet.insert("pages");
  elementSet.insert("copyright");
  elementSet.insert("handle"); 
  elementSet.insert("other_access");
  elementSet.insert("retrieval");
  elementSet.insert("keyword"); 
  elementSet.insert("cr-category");
  elementSet.insert("period"); 
  elementSet.insert("series"); 
  elementSet.insert("monitoring");
  elementSet.insert("funding");
  elementSet.insert("contract");
  elementSet.insert("grant");
  elementSet.insert("language");
  elementSet.insert("notes"); 
  elementSet.insert("abstract");
 
}; 

const text_t rfc1807::formatName() 
{
  return "rfc1807";
}

const text_t rfc1807::formatPrefix() {
  return "rfc1807";
}

bool rfc1807::output_record(ostream &output, recptproto *protocol, const text_t &collection, 
			    const text_t &record_OID) 
{
  return metaformat::output_record(output, protocol, collection, record_OID);
}

void rfc1807::output_metadata_header(ostream &output)
{
  output << "<metadata>\n";
  
  if(this->oaiConfigure->getOAIVersion() <= 110){
  // output rfc1807 wrapper for OAI v1.1
    output << "<rfc1807 xmlns=\"http://info.internet.isi.edu:80/in-notes/rfc/files/rfc1807.txt\"" << endl;
    output << "         xmlns:xsi=\"http://www.w3c.org/2001/XMLSchema-instance\"" << endl;
    output << "         xsi:schemaLocation=\"http://info.internet.isi.edu:80/in-notes/rfc/files/rfc1807.txt" 
	   << endl;
    output << "                            http://www.openarchives.org/OAI/1.1/rfc1807.xsd\">" << endl;
  }
  else {
    // TODO: output rfc1807 wrapper for OAI v2.0
    output << "<rfc1807 xmlns=\"http://info.internet.isi.edu:80/in-notes/rfc/files/rfc1807.txt\"" << endl;
    output << "         xmlns:xsi=\"http://www.w3c.org/2001/XMLSchema-instance\"" << endl;
    output << "         xsi:schemaLocation=\"http://info.internet.isi.edu:80/in-notes/rfc/files/rfc1807.txt"
	   << endl;
    output << "                            http://www.openarchives.org/OAI/1.1/rfc1807.xsd\">" << endl;
  } 
}

void rfc1807::output_metadata_footer(ostream &output)
{
  // end rfc1807 wrapper
  output << "</rfc1807>" << endl;
    
  output << "</metadata>\n";
}

bool rfc1807::output_formatdata(ostream &output)
{
  // Both versions of the protocol use the same schema (yes?)
  output << "    <metadataPrefix>rfc1807</metadataPrefix>" << endl;
  output << "    <schema>http://www.openarchives.org/OAI/1.1/rfc1807.xsd</schema>" << endl;
  // Correct namespace for rfc1807 according to OAI documentation, even though this link seems to be broken
  output << "    <metadataNamespace>http://info.internet.isi.edu/in-notes/rfc/files/rfc1807.txt</metadataNamespace>" << endl;

  return true;
}


