/**********************************************************************
 *
 * pagedbrowserclass.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "gsdl_modules_cfg.h"
#ifdef GSDL_USE_PAGED_BROWSER

#include "pagedbrowserclass.h"
#include <assert.h>
#include "recptprototools.h"
#include "OIDtools.h"
#include "gsdltools.h"
#include "securitytools.h"

pagedbrowserclass::pagedbrowserclass () {
}

pagedbrowserclass::~pagedbrowserclass () {
}

// returns the name that specifies the browserclass type
text_t pagedbrowserclass::get_browser_name () {
  return "Paged";
}

browserclass* pagedbrowserclass::clone()
{
  return new pagedbrowserclass();
}

void pagedbrowserclass::load_metadata_defaults (text_tset &metadata) {
  metadata.insert ("Title");
}

// if the "gp" (go to page) argument is set we need to set
// the "d" argument to the corresponding page
// also want to set "d" argument to first child if we're at
// an 'Invisible' top level
void pagedbrowserclass::processOID (cgiargsclass &args, recptproto *collectproto,
                                    ostream &logout) {

  text_t &arg_d = args["d"];
  text_t &arg_gp = args["gp"];
  text_tset metadata;
  bool getParents = false;
  FilterResponse_t response;

  if (!arg_d.empty() && !arg_gp.empty()) {
    text_t immediate_parent = get_parent (arg_d);

    metadata.insert("Title");
    get_children (immediate_parent, args["c"], args["l"], metadata,
		  getParents, collectproto, response, logout);
    ResultDocInfo_tarray::iterator dochere = response.docInfo.begin();
    ResultDocInfo_tarray::iterator docend = response.docInfo.end();
    while (dochere != docend) {
      if ((*dochere).metadata["Title"].values[0] == arg_gp) {
        arg_d = (*dochere).OID;
        return;
      }
      ++dochere;
    }
  }

  // The "gp" argument was either empty or invalid, so display the first child if given a document OID
  if (!arg_d.empty() && is_top(arg_d)) { // if top level doc, check if not invisible
    metadata.insert("thistype");
    if (get_info(arg_d, args["c"], args["l"], metadata, getParents, collectproto, response, logout)) {
      text_t type = response.docInfo[0].metadata["thistype"].values[0];
      if (type=="Invisible") { // display first child
        arg_d = arg_d + ".fc";
      }
    }
  }
}

int pagedbrowserclass::output_section_group (ResultDocInfo_t &section, cgiargsclass &args,
					     const text_t &/*collection*/, int /*colnumber*/, 
					     format_t * /*formatlistptr*/, bool /*use_table*/, 
					     text_tset &/*metadata*/, bool &/*getParents*/,
					     recptproto * /*collectproto*/, displayclass &disp, 
					     outconvertclass &outconvert, ostream &textout, 
					     ostream &/*logout*/) {

  // this browser class only handles document levels
  if (args["d"].empty()) return 0;

  if (section.OID != args["d"]) {
    text_t httpprevarrow = "_httpdocument_&cl=" + encodeForURL(args["cl"]) + "&d=" + dm_safe(section.OID);
    text_t parentarrow = "<a href=\"" + httpprevarrow + "\">_iconprev_</a>\n";
    disp.setmacro ("httpprevarrow", "document", httpprevarrow);
    disp.setmacro ("parentarrow", "document", parentarrow);
    return 0;
  }

  // must be at top level to get to here!
  textout << outconvert << disp << "<b>" << section.metadata["Title"].values[0] 
	  << "_document:textintro_</b>\n";
  
  return 0;
}

int pagedbrowserclass::output_section_group (FilterResponse_t &sections, cgiargsclass &args,
					     const text_t &/*collection*/, int /*colnumber*/, 
					     format_t * /*formatlistptr*/, bool /*use_table*/, 
					     text_tset &/*metadata*/, bool &/*getParents*/,
					     recptproto * /*collectproto*/, displayclass &disp, 
					     outconvertclass &outconvert, ostream &textout, 
					     ostream &/*logout*/) {

  text_t &arg_d = args["d"];

  // this browser class only handles document levels
  if (arg_d.empty()) return 0;

  text_t previousOID, previoustitle, nextOID, nexttitle;
  text_t prevarrow, nextarrow, httpprevarrow, httpnextarrow;
  bool found = false;

  // this should be our list of pages

  ResultDocInfo_tarray::iterator thissection = sections.docInfo.begin();
  ResultDocInfo_tarray::iterator endsection = sections.docInfo.end();

  while (thissection != endsection) {
    if (arg_d == (*thissection).OID) {
      found = true;
      textout << outconvert << disp 
	      << "<table><tr valign=top><td colspan=3><center><b>_page_"
	      << (*thissection).metadata["Title"].values[0] << "</b>\n";
      if (thissection != sections.docInfo.begin()) {
	previousOID = (*(thissection-1)).OID;
	previoustitle = (*(thissection-1)).metadata["Title"].values[0];
      } else {
	prevarrow = "_document:parentarrow_";
      }

      if ((thissection+1) != endsection) {
	nextOID = (*(thissection+1)).OID;
	nexttitle = (*(thissection+1)).metadata["Title"].values[0];
      }
      break;
    }
    ++thissection;
  }

  if (!found) {
    textout << outconvert << disp 
	    << "<table><tr valign=top> <td colspan=3><center>\n";
  }
  int numpages = sections.docInfo.size();
  textout << outconvert << disp 
	  << ("_document:textnumpages_(" + text_t(numpages) + ")</center></td></tr>\n");

  disp.setmacro ("numpages", "document", numpages);

  if (!found) {
    httpnextarrow = "_httpdocument_&cl=" + encodeForURL(args["cl"]) + "&d=" + sections.docInfo[0].OID;
    nextarrow = "<a href=\"" + httpnextarrow + "\">" + 
      sections.docInfo[0].metadata["Title"].values[0] + "_iconnext_</a>\n";

  } else {
    if (!previousOID.empty()) {
      httpprevarrow = "_httpdocument_&cl=" + encodeForURL(args["cl"]) + "&d=" + dm_safe(previousOID);
      prevarrow = "<a href=\"" + httpprevarrow + "\">_iconprev_" + previoustitle + "</a>\n";
    }
    if (!nextOID.empty()) {
      httpnextarrow = "_httpdocument_&cl=" + encodeForURL(args["cl"]) + "&d=" + dm_safe(nextOID);
      nextarrow = "<a href=\"" + httpnextarrow + "\">" + nexttitle + "_iconnext_</a>\n";
    }
  }

  if (!httpprevarrow.empty()) disp.setmacro ("httpprevarrow", "document", httpprevarrow);
  if (!httpnextarrow.empty()) disp.setmacro ("httpnextarrow", "document", httpnextarrow);

  if (!prevarrow.empty()) disp.setmacro ("prevarrow", "document", prevarrow);
  if (!nextarrow.empty()) disp.setmacro ("nextarrow", "document", nextarrow);

  if (!previoustitle.empty()) disp.setmacro ("prevtitle", "document", previoustitle);
  if (!nexttitle.empty())     disp.setmacro ("nexttitle", "document", nexttitle);


  textout << outconvert << disp << "<tr valign=middle>\n"
	  << "<td align=right>" << prevarrow << "</td>\n"
	  << "<td align=center valign=top>_document:gotoform_</td>"
	  << "<td align=left>" << nextarrow << "</td>\n"
	  << "</tr></table>\n";

  return 0;
}

#endif //GSDL_USE_PAGED_BROWSER
