/**********************************************************************
 *
 * sqlqueryaction.h -- 
 * Copyright (C) 2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef SQLQUERYACTION_H
#define SQLQUERYACTION_H


#include "basequeryaction.h"


class sqlqueryaction : public basequeryaction {

protected:
  virtual text_t query_filter_name () {return "SQLQueryFilter";}

  virtual void get_formatted_query_string (text_t &formattedstring, 
					   bool segment, 
					   cgiargsclass &args, 
					   displayclass &disp, 
					   ostream &logout);

  virtual void set_queryfilter_options (FilterRequest_t &request, 
					const text_t &querystring,
					cgiargsclass &args);

  virtual void define_form_macros (displayclass &disp, cgiargsclass &args, 
				   recptprotolistclass *protos, 
				   ostream &logout);


  void set_sfselection_macro(text_t current_value, 
			     const FilterOption_t &option_domain, 
			     const FilterOption_t &option_range, 
			     displayclass &disp);


  virtual bool save_search_history(cgiargsclass &args, int numdocs, 
				   isapprox isApprox);

public:
  sqlqueryaction ();
  virtual ~sqlqueryaction ();

  void configure (const text_t &key, const text_tarray &cfgline);
  bool init (ostream &logout);
  
  virtual text_t get_action_name () {return "sqlq";}

  virtual bool check_cgiargs (cgiargsinfoclass &argsinfo, cgiargsclass &args, 
			      recptprotolistclass *protos, ostream &logout);

  virtual void define_external_macros (displayclass &disp, cgiargsclass &args, 
				       recptprotolistclass *protos, ostream &logout);
  
  virtual bool do_action (cgiargsclass &args, recptprotolistclass *protos, 
		  browsermapclass *browsers, displayclass &disp, 
		  outconvertclass &outconvert, ostream &textout, 
			  ostream &logout);

};

#endif
