/**********************************************************************
 *
 * IsisDef.h
 * Copyright (C) 2003  UNESCO
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef __ISIS_DEFINITION_H__
#define __ISIS_DEFINITION_H__

// disable warning C4786: symbol greater than 255 character,
// okay to ignore
#pragma warning(disable: 4786)

#ifndef __ISIS_TYPE_H__
#include "IsisTypes.h"
#endif

#include <sstream>

typedef std::string ustring;
typedef std::string cstring;
// typedef std::wstring awstring;
typedef std::stringstream ustringstream;
typedef std::stringstream cstringstream;
typedef wchar_t WCHAR;


const size_t INVALID_NPOS = ~(size_t)0;

namespace FileSystem {
    // Generic File access/open mode enumeration
    enum AccessMode { 
       FILE_READONLY,   // Open file with read access only
       FILE_WRITEONLY,  // Open file with write access only
       FILE_READWRITE,  // Open file with read and write access
       FILE_CREATE,     // Create the file if it does not exist
       FILE_NO_CREATE,  // Do not create the file if it does not exist
       FILE_TRUNCATE,   // Truncate the file  
       FILE_APPEND,     // Append to the file
       FILE_SHARE,      // Enable file sharing  (Platform specific)
       FILE_EXCLUSIVE   // Disable file sharing (Platform specific)
	};


    // Generic File seek mode enumeration
    enum SeekMode { 
      FILE_SEEK_BEG, // Seek starting from the beginning of the file
      FILE_SEEK_CUR, // Seek starting from the current location
      FILE_SEEK_END  // Seek starting from the end of the file
    };
};

#ifndef __FILE_SYSTEM__
#include "FileSystem.h"
#endif

#ifndef __FILE_BASE__
#include "File.h"
#endif

#ifndef __ISIS_ERROR_H__
#include "IErrors.h"
#endif

#ifdef _MSC_VER
#ifndef __DEBUG_H__
#define _DEBUG
#define _CONSOLE
#include "debug.h"
#endif
#endif

#ifndef __ABSTRACT_ISISDB_H__
#include "AbstractIsisDb.h"
#endif

#ifndef __ISISDB_H__
#include "IsisDb.h"
#endif


#ifndef __MASTER_RECORD_H__
#include "Master.h"
#endif

#ifndef __FDT_H__
#include "Fdt.h"
#endif


enum { RecordDeleted=0, RecordUpdated=1, RecordCreated=2};
enum { Active=0, LogicalyDeleted=1, PhysicalyDeleted=2,
       EndOfFile=-1, NewRecord = 3 };




// Class declarations for exceptions representing program errors. 
// This implementation is provided for use C++'s built-in exception
// handling routines.

class CIsisDbException { 
public:
	int m_iError;
	CIsisDbException(const int iError, const char* file_name, const mg_s_long line_number) 
	{
		m_iError = iError;
#ifdef _MSC_VER
		AssertFailed(isisExceptionMessage((IsisError) m_iError), file_name, line_number);
#else
		std::cout << isisExceptionMessage((IsisError) m_iError) << file_name
			      << " Line=" << line_number;
#endif
	}
};  


#endif // __ISIS_DEFINITION_H__
