/**********************************************************************
 *
 * IsisGdl.cpp
 * Copyright (C) 2003  UNESCO
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

// IsisGdl.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "IsisDb.h"
#include <iostream>

void PausePrg()
{
	std::cout << "\n";
	std::cout << "Press enter to continue..." << "\n";
	std::cin.get();
}

void ClearInputStream(std::istream &s)
// Used to clear istream
{
	char c;
	s.clear();
	while(s.get(c) && c != '\n') { ; }
}

// Should be called with the master file name as parameter
// IsisGdl "full_path\master_file_name" 
// IsisGdl C:\IsisGdl\cds.mst for ex


int main(int argc, _TCHAR* argv[])
{

	if (argc < 2 || argc > 3)
	{
		std::cout << "usage: IsisGdl [-include_logically_deleted_records] master_file_full_name" << std::endl;
		return 1;
	}
	// Instantiation of the IsisDb Object
	IsisDb db;
	try
	{
		// The file name should be prefixed with the full path
		// and should be the master file name with extension ".mst"
		// "C:\IsisGdl\cds.mst" for ex
		db.OpenDb(argv[argc - 1]);
	}
	catch(CIsisDbException e)
	{
		std::string msg = "Cannot open isis db: ";
		msg += argv[argc - 1];
		msg += isisExceptionMessage((IsisError) e.m_iError);
		std::cerr<< msg << std::endl;
		return false;
	}

	// Create a Master File object without the Field Definition
	// Information
	MfRecord mfr(0); 

	// Extract the number of the next master file number to
	// assign
	const mg_s_long nextMfn = db.GetNextMfn();



	// Browse the master file in increasing order of Master
	// file numbers (MFN is the record ID)
	for (mg_s_long i=1; i<nextMfn; i++)
	{

		int status = db.ReadDbRecord(i, mfr);

		if (status == Active || (strcmp(argv[1], "-include_logically_deleted_records") == 0 && status == LogicalyDeleted))
		{
			// If the record is physically on the master file
			// then get the vector of field tags.
			
			// 1) Repetitive fields have the same tag and are stored in
			//    a single field but are separated by the "%" char
			// 2) Subfields are separated by "^"letter (^a ^b ^c ...)
			//
			// 3) Terms or Phrases between "<>" are terms/Phrases to 
			//    index
			std::vector<int> vf = mfr.GetFieldTags();
			std::cout << "----------" << std::endl;
			  //				      << "mfn=" << i  
				// 	  << " nvf=" << vf.size() << std::endl;

			for (int j=0; j<vf.size(); j++)
			{
				std::string stemp;
				// Special case when tag is <=0
				if (vf[j]<=0 || vf[j]>SHRT_MAX)
					continue;
				// Extract the field with tag contained into vf[j]
				bool rc = mfr.GetField(vf[j], stemp);
				if (rc)
				{
					std::cout << "tag=" << vf[j]
					          << " data=" << stemp << std::endl;
				}
			}

		}
		else
			continue;
		// PausePrg();

	}
	return 0;
}

