/**
 *############################################################################
 * A component of the Greenstone Librarian Interface, part of the Greenstone
 * digital library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Copyright (C) 2025 New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *############################################################################
 */

package org.greenstone.gatherer.collection;


import java.io.*;
import javax.swing.*;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.file.FileNode;
import org.greenstone.gatherer.metadata.FilenameEncoding;
import org.greenstone.gatherer.util.JarTools;
import java.util.Set;
import java.util.Iterator;


/** This class represents one node in the full collection tree in the 
    Files panel */
public class FullCollectionTreeNode
    extends FileNode
{
    
    public FullCollectionTreeNode(File file)
    {
	super(file);
        // the super call will additionally call calcDisplayString() which will get any
        // applicable the filename encoding and apply it to the file's name for display.

    
    }


    public FileNode addChildNode(File file)
    {
	FullCollectionTreeNode child_node = new FullCollectionTreeNode(file);
	child_node.setModel(model);
	child_node.setParent(this);
	return child_node;
    }

      public boolean isZipFile() {
	if(this.file != null) {
	    if(file.getPath().endsWith(".zip")) {
		return true;
	    }
	}

	return false;
    }

  public boolean isEditable() {
    if (this.file != null) {
      String ext = this.file.getName();
      if (!ext.contains(".")) {
        return false;
      }
      ext = ext.substring(ext.lastIndexOf(".")+1);
      if (ext.matches("xml|xsl|txt|css|csv|js|log|nul|mds|col|properties|json|pm|pl|dtd|rdf|htm|html")) {
        return true;
      }
    }
    return false;
  }
}

