/* ------------------------------------------------------------------- */
/* MARCmake  : Convert a metatag struct to MARC and add it to the      */
/*             marcrecord struct.                                      */
/*                                                                     */
/*             This is where the format-dependent conversion           */
/*             program is selected.                                    */
/*                                                                     */
/* Author    : Ole Husby                                               */
/* Updated   : 1998-09-30                                              */
/* ------------------------------------------------------------------- */

#include <stdio.h>
#include "d2m.h" 



int MARCmake(struct metatag *mt, struct marcrec *mr, int format)
{
  char pre[64], creator_tag[4];

  if (format == DANMARC)
    return danMARC(mt, mr);
  else if (format == FINMARC)
    return finMARC(mt, mr);
  else if (format == ISMARC)
    return isMARC(mt, mr);
  else if (format == USMARC)
    return usMARC(mt, mr);
  else if (format == UNIMARC)
    return uniMARC(mt, mr);
  else if (format == SWEMARC)
    return sweMARC(mt, mr);
  else
    return norMARC(mt, mr);
}
