/* ------------------------------------------------------------------- */
/* finMARC    : Convert a metatag struct to FINMARC                    */
/*                                                                     */
/* Author     : Ole Husby                                              */
/* Last update: 1998-09-30                                             */
/* ------------------------------------------------------------------- */

#include <stdio.h>
#include <string.h>
#include "d2m.h" 


/* Decides tag for format                                                    */

int parse_format(char *str, char *format)
{
   if (strcasecmp(str, "text/html") == 0)
     strcpy(format, "HTML"); 

   return 1;
}


/* Decides tag for type                                                      */

int parse_type(char *str, char *tag)
{
   strcpy(tag, "500");

   if ( (strcasecmp(str, "diss."             ) == 0) 
     || (strcasecmp(str, "dissertation"      ) == 0) 
     || (strcasecmp(str, "phd thesis"        ) == 0) 
     || (strcasecmp(str, "vitskirja"       ) == 0) 
     || (strcasecmp(str, "vitsk."          ) == 0) 
     || (strcasecmp(str, "avhandling"        ) == 0) ) 
     strcpy(tag, "502");

   else
   if ( (strcasecmp(str, "masters thesis"    ) == 0) 
     || (strcasecmp(str, "honours thesis"    ) == 0) 
     || (strcasecmp(str, "opinnyte"         ) == 0) 
     || (strcasecmp(str, "opinn."            ) == 0) ) 
     strcpy(tag, "509");

   return 1;
}


int finMARC(struct metatag *mt, struct marcrec *mr)
{
  char pre[64], type_tag[4];

  *pre = 0;

  if (strcasecmp(mt->name, "title") == 0)
  {
    if ( (!*mt->type)
         | (strcasecmp(mt->type, "main") == 0)
         | (strcasecmp(mt->type, "long") == 0) )
    {
      if (mr->ntitles)
      {
        strcat(mr->partitle, "$r ");
        strcat(mr->partitle, mt->value);

      }
      else
      {
        mr->ntitles++;
        strcpy(pre, "245  $a");
      }
    }
  }

  else if (strcasecmp(mt->name, "creator") == 0)
  {
    if (!*mt->type)
    {
      strcpy(pre, "720  $a");
      split_name(mt->value);
    }
    else if ( (strcasecmp(mt->type, "name") == 0) 
            || (strcasecmp(mt->type, "personal") == 0) )
    {
      strcpy(pre, "100  $a");
      split_name(mt->value);
    }
    else if (strcasecmp(mt->type, "corporate") == 0)
      strcpy(pre, "110  $a");
  }

  else if (strcasecmp(mt->name, "publisher") == 0)
  {
    if (!*mt->type)
      strcpy(pre, "260  $b");
    else if (strcasecmp(mt->type, "name") == 0)
      strcpy(pre, "260  $b");
  }

  else if (strcasecmp(mt->name, "description") == 0)
    strcpy(pre, "519  $a");

  else if (strncasecmp(mt->name, "contributor", 11) == 0)     /* Note both pl and sgl allowed */
  {
    if (!*mt->type)
    {
      strcpy(pre, "720  $a");
      split_name(mt->value);
    }
    else if ( (strcasecmp(mt->type, "name") == 0) 
            || (strcasecmp(mt->type, "personal") == 0) )
    {
      strcpy(pre, "700  $a");
      split_name(mt->value);
    }
    else if (strcasecmp(mt->type, "corporate") == 0)
      strcpy(pre, "710  $a");
  }

  else if (strcasecmp(mt->name, "coverage") == 0)
  {
    if (!*mt->type)
      strcpy(pre, "500  $a");
    else if (strcasecmp(mt->type , "spatial") == 0)
    {
      strcpy(pre, "655  $a");
      split_subj(mt->value);
    }
    else if (strcasecmp(mt->type,  "temporal") == 0)
    {
      strcpy(pre, "652  $a");
      split_subj(mt->value);
    }
  }

  else if (strcasecmp(mt->name, "source") == 0)
    strcpy(pre, "501  $a");

  else if (strcasecmp(mt->name, "rights") == 0)
  {
    if (strcasecmp(mt->scheme, "url") == 0)
      strcpy(pre, "856  $u");
  }

  else if (strcasecmp(mt->name, "identifier") == 0)
  {
    if (!*mt->scheme)
      strcpy(mr->url, mt->value);
    else if (strcasecmp(mt->scheme, "url") == 0)
      strcpy(mr->url, mt->value);
    else if (strcasecmp(mt->scheme, "urn") == 0)
      strcpy(pre, "856  $g");
    else if (strcasecmp(mt->scheme, "isbn") == 0)
      strcpy(pre, "021  $a");
    else if (strcasecmp(mt->scheme, "issn") == 0)
      strcpy(pre, "022  $a");
    else if (strcasecmp(mt->scheme, "nbn") == 0)
      strcpy(pre, "015  $a");
    else if (strcasecmp(mt->scheme, "isrc") == 0)
      strcpy(pre, "015  $a");
    else if (strcasecmp(mt->scheme, "ismn") == 0)
      strcpy(pre, "024  $a");
    else if (strcasecmp(mt->scheme, "isrn") == 0)
      strcpy(pre, "027  $a");
  }

  else if (strcasecmp(mt->name, "type") == 0)
  {
    parse_type(mt->value, (char *) type_tag);
    sprintf(pre, "%s  $a", type_tag);
  }

  else if (strcasecmp(mt->name, "language") == 0)
  {
    if (strcasecmp(mt->scheme, "z39.53") == 0)
    {
      strcpy(pre, "041  $a");
      if (strlen(mt->value) == 3)
        put008(mr->s008, mt->value, F008_LANGUAGE);
    }
  }

  else if (strcasecmp(mt->name, "format") == 0)
  {
    if ( (!*mt->scheme)
      || (strcasecmp(mt->scheme, "imt") == 0)
      || (strcasecmp(mt->scheme, "mime") == 0) )
      parse_format(mt->value, (char *) mr->fmat);
  }

  else if (strcasecmp(mt->name, "subject") == 0)
  {
    if (!*mt->scheme)
      strcpy(pre, "692  $a");
    else if (strcasecmp(mt->scheme, "udc") == 0)
      strcpy(pre, "080  $a");
    else if (strcasecmp(mt->scheme, "lcsh") == 0)
      strcpy(pre, "650  $a");
    else if (strcasecmp(mt->scheme, "ddc") == 0)
      strcpy(pre, "082  $a");
    else if (strcasecmp(mt->scheme, "mesh") == 0)
      strcpy(pre, "690  $a");
    else if (strcasecmp(mt->scheme, "ykl") == 0)
      strcpy(pre, "098  $a");
    else if (strcasecmp(mt->scheme, "ysa") == 0)
    {
      strcpy(pre, "652  $a");
      split_subj(mt->value);
    }
    else if (strcasecmp(mt->scheme, "fimu") == 0)
    {
      strcpy(pre, "653  $a");
      split_subj(mt->value);
    }
    else if (strcasecmp(mt->scheme, "fige") == 0)
    {
      strcpy(pre, "655  $a");
      split_subj(mt->value);
    }
    else if (strcasecmp(mt->scheme, "file") == 0)
    {
      strcpy(pre, "665  $a");
      split_subj(mt->value);
    }
    else if (strcasecmp(mt->scheme, "fiso") == 0)
    {
      strcpy(pre, "670  $a");
      split_subj(mt->value);
    }
    else if (strcasecmp(mt->scheme, "fire") == 0)
    {
      strcpy(pre, "680  $a");
      split_subj(mt->value);
    }
    else if (strcasecmp(mt->scheme, "fifo") == 0)
    {
      strcpy(pre, "685  $a");
      split_subj(mt->value);
    }
    else if (strcasecmp(mt->scheme, "fiag") == 0)
    {
      strcpy(pre, "686  $a");
      split_subj(mt->value);
    }
    else if (strcasecmp(mt->scheme, "fiep") == 0)
    {
      strcpy(pre, "660  $a");
      split_subj(mt->value);
    }
  }

  else if (strcasecmp(mt->name, "date") == 0)
  {
    if ( (!*mt->type) || ( strcasecmp(mt->type, "current") == 0) )
    {
      if ( (strncasecmp(mt->scheme, "ans", 3) == 0) 
         || (strncasecmp(mt->scheme, "iso", 3) == 0) )
      {
        if (find_year(mt->value))
        {
          strcpy(mr->year, mt->value);
          put008(mr->s008, mt->value, F008_DATE1);
        }
      }
    }
  }

  if (*pre)
  {
    strcat(mr->marcline, pre);
    strcat(mr->marcline, " ");
    strcat(mr->marcline, mt->value);
    strcat(mr->marcline, "\n");
  }
}
