/* ------------------------------------------------------------------- */
/* usMARC   : Convert a metatag struct to USMARC                       */
/*                                                                     */
/* 1998-09-30: Ole Husby                                               */
/* ------------------------------------------------------------------- */

#include <stdio.h>
#include <string.h>
#include "d2m.h" 



void usMARC(struct metatag *mt, struct marcrec *mr)
{
  char pre[64], title_tag[4];

  *pre = 0;

  if (strcasecmp(mt->name, "title") == 0)
  {
    if ( (!*mt->type)
         | (strcasecmp(mt->type, "main") == 0)
         | (strcasecmp(mt->type, "long") == 0) )
    {
      if (mr->ntitles)
        strcpy(title_tag, "2460");
      else
        strcpy(title_tag, "245 ");

      mr->ntitles++;

      sprintf(pre, "%s $a", title_tag);
    }
  }

  else if (strcasecmp(mt->name, "creator") == 0) 
  {
    if (!*mt->type)
      strcpy(pre, "720  $a");
    else if ( (strcasecmp(mt->type, "name") == 0)
            || (strcasecmp(mt->type, "personal") == 0) )
      strcpy(pre, "700  $a");
    else if (strcasecmp(mt->type, "corporate") == 0)
      strcpy(pre, "710  $a");
  }


  else if (strcasecmp(mt->name, "publisher") == 0)
  {
    if (!*mt->type)
      strcpy(pre, "260  $b");
    else if (strcasecmp(mt->type, "name") == 0)
      strcpy(pre, "260  $b");
  }

  else if (strncasecmp(mt->name, "contributor", 11) == 0)     /* Note both pl and sgl allowed */
  {
    if (!*mt->type)
      strcpy(pre, "720  $a");
    else if ( (strcasecmp(mt->type, "name") == 0)
            || (strcasecmp(mt->type, "personal") == 0) )
      strcpy(pre, "700  $a");
    else if (strcasecmp(mt->type, "corporate") == 0)
      strcpy(pre, "710  $a");
  }


  else if (strcasecmp(mt->name, "coverage") == 0)
  {
    if (!*mt->type)
      strcpy(pre, "500  $a");
    else if (strcasecmp(mt->type , "spatial") == 0)
      strcpy(pre, "255  $c");
    else if (strcasecmp(mt->type,  "temporal") == 0)
      strcpy(pre, "513  $b");
  }


  else if (strcasecmp(mt->name, "source") == 0)
    strcpy(pre, "7860 $n");

  else if (strcasecmp(mt->name, "rights") == 0)
  {
    if (!*mt->scheme)
      strcpy(pre, "540  $a");
    else if (strcasecmp(mt->scheme, "url") == 0)
      strcpy(pre, "856  $3 rights $a");
  }

  else if (strcasecmp(mt->name, "identifier") == 0)

/* Not supported: Indicator for urn! (See crosswalk)            */

  {
    if (!*mt->scheme)
      strcpy(mr->url, mt->value);
    else if (strcasecmp(mt->scheme, "url") == 0)
      strcpy(mr->url, mt->value);
    else if (strcasecmp(mt->scheme, "urn") == 0)
      strcpy(pre, "856  $u urn:");
    else if (strcasecmp(mt->scheme, "isbn") == 0)
      strcpy(pre, "020  $a");
    else if (strcasecmp(mt->scheme, "issn") == 0)
      strcpy(pre, "022  $a");
    else
      strcpy(pre, "0248 $a");
  }

  else if (strcasecmp(mt->name, "format") == 0)
  {
    if (!*mt->scheme)
      strcpy(mr->fmat, mt->value);
    else if (strcasecmp(mt->scheme, "imt") == 0)
      strcpy(mr->fmat, mt->value);
    else if (strcasecmp(mt->scheme, "mime") == 0)
      strcpy(mr->fmat, mt->value);
  }

  else if (strcasecmp(mt->name, "subject") == 0)
  {
    if (!*mt->scheme)
      strcpy(pre, "653  $a");
    else if (strcasecmp(mt->scheme, "lcc") == 0)
      strcpy(pre, "050  $a");
    else if (strcasecmp(mt->scheme, "lcsh") == 0)
      strcpy(pre, "650  $a");
    else if (strcasecmp(mt->scheme, "ddc") == 0)
      strcpy(pre, "082  $a");
  }


  else if (strcasecmp(mt->name, "language") == 0)
  {
    if (strcasecmp(mt->scheme, "z39.53") == 0)
    {
      if (strlen(mt->value) == 3)
        put008(mr->s008, mt->value, F008_LANGUAGE);
    }
  }


  else if (strcasecmp(mt->name, "date") == 0)
  {
    if ( (strncasecmp(mt->scheme, "ans", 3) == 0) ||
         (strncasecmp(mt->scheme, "iso", 3) == 0) )
    {
      if ( (!*mt->type) || ( strcasecmp(mt->type, "current") == 0) )
      {
        if (find_year(mt->value))
        {
          strcpy(mr->year, mt->value);
          put008(mr->s008, mt->value, F008_DATE1);
        }
      }
    }
  }

  if (*pre)
  {
    strcat(mr->marcline, pre);
    strcat(mr->marcline, " ");
    strcat(mr->marcline, mt->value);
    strcat(mr->marcline, "\n");
  }
}
