/**********************************************************************
 *
 * mgppqueryfilter.h -- new queryfilter to use mgpp 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mgppqueryfilter.h 27064 2013-03-12 01:37:44Z kjdon $
 *
 *********************************************************************/

#ifndef MGPPQUERYFILTER_H
#define MGPPQUERYFILTER_H

#include "fieldedqueryfilter.h"


class mgppqueryfilterclass : public fieldedqueryfilterclass {
protected:


  // textsearchptr and db_ptr are assumed to be valid
  void do_multi_query (const FilterRequest_t &request,
		       const vector<queryparamclass> &query_params,
		       queryresultsclass &multiresults,
		       comerror_t &err, ostream &logout);


public:
  mgppqueryfilterclass ();
  virtual ~mgppqueryfilterclass ();

  void configure (const text_t &key, const text_tarray &cfgline);
  //  bool init (ostream &logout);
  void filter (const FilterRequest_t &request,
		       FilterResponse_t &response,
		       comerror_t &err, ostream &logout);
  
  void browsefilter(const FilterRequest_t &request,
		    FilterResponse_t &response,
		    comerror_t &err, ostream &logout);  
};


#endif
