/**********************************************************************
 *
 * phrasequeryfilter.cpp -- 
 * Copyright (C) 1999  DigiLib Systems Limited, New Zealand
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "phrasequeryfilter.h"
#include "queryinfo.h"

#include "phrasesearch.h"



// do aditional query processing
void phrasequeryfilterclass::post_process (const queryparamclass &queryparams,
					   queryresultsclass &queryresults) {
  bool results_shrunk = false;

  // post-process the results if needed
  if (queryresults.orgterms.size() > 1 && !queryresults.docs.docset.empty()) {
    // get the long version of the index
    text_t longindex;
    indexmap.to2from (queryparams.index, longindex);
      
    // process each of the matched documents
    docresultmap::iterator docs_here = queryresults.docs.docset.begin();
    docresultmap::iterator docs_end = queryresults.docs.docset.end();
    while (docs_here != docs_end) {
      if ((*docs_here).second.num_query_terms_matched == queryresults.orgterms.size() &&
	  OID_phrase_search (*(mgsearchclass *)textsearchptr, *db_ptr, queryparams.index,
			     queryparams.subcollection, queryparams.language, 
			     longindex, queryparams.collection, queryresults.orgterms,
			     (*docs_here).second.docnum)) {
	++docs_here->second.num_phrase_match;
	++docs_here;

      } else {
	docresultmap::iterator this_doc_here = docs_here;
	++docs_here;
	if (queryparams.match_mode == 1) {
	  // need to delete this element, there was no exact match
	  queryresults.docs.docset.erase(this_doc_here);
	  results_shrunk = true;
	}
      }
    }
  }

  if (results_shrunk) queryresults.docs_matched = queryresults.docs.docset.size();
}


void phrasequeryfilterclass::sort_doc_results (const FilterRequest_t &/*request*/,
					 docresultsclass &docs) {
  resultsorderer_t resultsorderer;
  resultsorderer.compare_phrase_match = true;
  resultsorderer.compare_terms_match = true;
  resultsorderer.compare_doc_weight = true;
  resultsorderer.docset = &(docs.docset);

  // first get a list of document numbers
  docs.docnum_order();

  sort (docs.docorder.begin(), docs.docorder.end(), resultsorderer);
}
