/**********************************************************************
 *
 * sqlfilter.h -- 
 * Copyright (C) 2008  DL Consulting Ltd
 * Copyright (C) 2010  New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef SQLFILTER_H
#define SQLFILTER_H


#include "filter.h"
#include "comtypes.h"
#include "sqldbclass.h"
#include "text_t.h"


class sqlfilterclass : public filterclass {
protected:
  text_t sql_db_filename;
  text_t indexstem;
  sqldbclass *sql_db_ptr;

public:
  sqlfilterclass ();
  virtual ~sqlfilterclass ();

  text_t get_filter_name () { return "SQLFilter"; }

  // configure should be called once for each configuration line
  // default configures the default filter options
  virtual void configure (const text_t &key, const text_tarray &cfgline);

  // the sql db ptr remains the responsibility of the calling code and
  // should be destroyed after this sqlfilter is destroyed
  void set_sql_db_ptr (sqldbclass *sql_db_ptr_arg) { sql_db_ptr = sql_db_ptr_arg; }

  bool init (ostream &logout);

  bool connect_to_sqldb (FilterResponse_t &response,
			 comerror_t &err, ostream &logout);
  void disconnect_from_sqldb ();

};


#endif
