/**********************************************************************
 *
 * argdb.cpp -- 
 * Copyright (C) 2001  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "gsdl_modules_cfg.h"
#ifdef GSDL_USE_COLLECTOR_ACTION

#include "fileutil.h"

// argdb is used by the collector for storing cgi arguments on disk (in a database)

#include "argdb.h"

#if defined(USE_GDBM)
#include "gdbmclass.h"
#define DBCLASS gdbmclass
#define DBFNAME "argdb.gdb"

#elif defined(USE_JDBM)
#include "jdbmnaiveclass.h"
#define DBCLASS jdbmnaiveclass
#define DBFNAME "argdb.jdb"

#elif defined(USE_SQLITE)
#include "sqlitedbclass.h"
#define DBCLASS sqlitedbclass
#define DBFNAME "argdb.litedb"

#elif defined(USE_MSSQL)
#include "mssqldbclass.h"
#define DBCLASS mssqldbclass
#define DBFNAME "argdb.msdb"

#else
#error "Unable to compile Greenstone. Need at least one database backend enabled."
#endif


argdb::argdb (const text_t& gsdlhome, const text_t &args_tmp) {

  gsdlhome_ = gsdlhome;
  dbfile_ = filename_cat(gsdlhome, "tmp", args_tmp, DBFNAME);

}
  
bool argdb::update_args (text_tmap &argmap) {

  DBCLASS argdb(gsdlhome_);
  if (!argdb.opendatabase(dbfile_, DB_WRITER_CREATE, 1000, true)) return false;
  infodbclass info;
  
  argdb.getinfo("savedargs", info);

  text_tmap::iterator here = argmap.begin();
  text_tmap::iterator end = argmap.end();
  while (here != end) {
    if (!(*here).second.empty()) {
      info.setinfo((*here).first, (*here).second);
    }
    ++here;
  }

  bool rv = argdb.setinfo ("savedargs", info);
  argdb.closedatabase();
  return rv;
}

bool argdb::get_args (text_tmap &argmap) {
  argmap.erase(argmap.begin(), argmap.end());
  DBCLASS argdb(gsdlhome_);
  if (!argdb.opendatabase(dbfile_, DB_READER, 1000, true)) return false;
  infodbclass info;
  
  if (!argdb.getinfo("savedargs", info)) return false;
  
  infodbclass::const_iterator here = info.begin();
  infodbclass::const_iterator end = info.end();
  while (here != end) {
    argmap[(*here).first] = info[(*here).first];
    ++here;
  }
  argdb.closedatabase();
  return true;
}

#endif //GSDL_USE_COLLECTOR_ACTION
