/**********************************************************************
 *
 * formatconverter.cpp -- 
 * Copyright (C) 2013  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "formattools.h"

#include<string> // string
#include <cstring> // char *, strlen, strcpy
#include<iostream>
using namespace std;

/*********************************************************************
Takes a GS2 format statement as input, which can be multi-line. It prints out a GS3 format statement.

E.g. {If}{[ex.FileFormat] eq 'PDF',{Or}{[ex.thumbicon],[ex.srcicon]},[ex.srclink]{Or}{[ex.thumbicon],[ex.srcicon]}[ex./srclink]}

should output:
<gsf:switch><gsf:metadata name="[ex.FileFormat]"/><gsf:when test="equals" test-value="PDF"><gsf:choose-metadata><gsf:metadata name="thumbicon" /><gsf:metadata name="srcicon" /></gsf:choose-metadata></gsf:when><gsf:otherwise><gsf:link type='source'></gsf:otherwise></gsf:switch>

Hitting Enter inserts a newline. Use Ctrl-Z (Win), Ctrl-D (Lin/Mac) to terminate input.

To run the same from a script and do so silently, so that the only output is the result string:
> echo "I                           
was
here" | ./formatconverter --silent
***********************************************************************/
void print_usage() {
  cout << endl << "Usage: formatconverter [options]" << endl;
  cout << "\tOptions: --help, [--silent] [--documentNode|--classifierNode]" << endl << endl;
}

int main(int argc, char **argv) {
  text_t argstr;
  text_tset metadata;
  bool getParents;
  format_t *formatlistptr = new format_t();
  text_t resultstring;

  text_t nodeType = "";
  bool silent = false;

  if(argc > 1) {

    if((strcmp(argv[1], "--help") == 0)) {
      print_usage();
      return 0;
    }

    else {
      for(int i = 1; i < argc; i++) {
	if (strcmp(argv[i], "--silent") == 0) { silent = true; }
	else if(strcmp(argv[i], "--documentNode") == 0) { nodeType = "document"; } 
	else if(strcmp(argv[i], "--classifierNode") == 0) { nodeType = "classifier"; }
	else { 
	  print_usage(); 
	  return 0;
	}
      }
    }
  }

  if(!silent) {
    cout << "Enter EOF (Windows: Ctrl-Z+ENTER | Linux: Ctrl-D | Mac OS X: Ctrl-D) to terminate input>\n";
  }
  
  // better to read in a line at a time
  // http://stackoverflow.com/questions/13148887/yet-another-c-cin-loop-issue
  // terminating input: http://www.cplusplus.com/forum/beginner/49993/
  // http://stackoverflow.com/questions/16132971/how-to-send-ctrlz-in-c
  //http://www.cplusplus.com/reference/ios/ios_base/iostate/
  //http://www.cplusplus.com/reference/ios/ios_base/iostate/

  for (string line; getline(cin, line); )
    {
      argstr.appendcstr(line.c_str()); 
      argstr += "\n";
    }

  parse_formatstring (argstr, formatlistptr, metadata, getParents);  
  resultstring = get_GS3_formatstring (formatlistptr, nodeType);

  delete formatlistptr;

  if(silent) {
    cout << resultstring << endl;
  } else {
    cout << "Input: " << argstr << endl;
    cout << "Transform result: " << resultstring << endl;
    cout << "Done\n";
  }

  return 0;
}
