/**********************************************************************
 *
 * os_process_unix.h -- Unix version of osprocess.  See os_process.h
 *                 for more details
 *
 * Copyright (C) 2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef OS_PROCESS_UNIX_H
#define OS_PROCESS_UNIX_H

#ifndef __WIN32__ // i.e. Unix

#include "os_process.h"

class osprocessunix : public osprocess
{
   
 public:
  osprocessunix(OSProcessPipeMode mode,
		char* prog_name, char* argv[]=NULL, char* envp[]=NULL);
  virtual ~osprocessunix();
  
  virtual int read(char* buffer, const int buffer_len);
  virtual int write(char* buffer, const int buffer_len);
  
  virtual void wait();

  virtual bool close_write_pipe(OSProcessWarnStatus warn_status=withWarning);
  virtual bool close_read_pipe(OSProcessWarnStatus warn_status=withWarning);

 protected:

  static const int READ_PIPE_INDEX=0;
  static const int WRITE_PIPE_INDEX=1;

  static const int FD_STDIN=0;
  static const int FD_STDOUT=1;
  static const int FD_STDERR=2;

  pid_t pid_;

  int child_stdin_write_;
  int child_stdout_read_;
};

#endif

#endif

