/**********************************************************************
 *
 * string_pool.cpp -- 
 * Copyright (C) 2003 DL Consulting Ltd
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include <iostream>
using namespace std;

#include "string_pool.h"

string_pool::string_pool () {
}

string_pool::~string_pool () {
  vector<char *>::const_iterator here = pool.begin();
  vector<char *>::const_iterator end = pool.end();
  while (here != end) {
    delete(*here);
    ++here;
  }
}

char *string_pool::get_cstr_from_pool(const text_t &str) {
  char *cstr = str.getcstr();
  pool.push_back(cstr);
  return cstr;
}
