###########################################################################
#
# win32 makefile -- getgw
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999-2008  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################
#
# To compile all these up on their own, just need a .bat file containing:
#
# CL /MT starthttpdchild.cpp kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib
#
# CL /MT starthttpd.cpp kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib
#
# CL /MT stophttpd.cpp kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib
#
# See:
# http://c.ittoolbox.com/groups/technical-functional/cpp-l/error-c2065-_beginthread-undeclared-identifier-how-to-solve-this-239497
# http://www.gamedev.net/community/forums/topic.asp?topic_id=304779
# http://www.codeguru.com/forum/showthread.php?t=179647
# http://support.microsoft.com/kb/138400
###########################################################################

GSDLHOME = ..\..\..


GSDL_VC4 = 0
LOCAL_LIBRARY = 0
DEBUG = 0
DLL = 0
DLLDEBUG = 0

!IF $(DEBUG)
CXXFLAGS = -DEBUG -Z7 /errorReport:prompt
LDFLAGS = -DEBUG -Z7 /errorReport:prompt
!ELSE
CXXFLAGS =
LDFLAGS =
!ENDIF

!IF $(GSDL_VC4)
CXXFLAGS = $(CXXFLAGS) -GX
!ELSE
CXXFLAGS = $(CXXFLAGS) -EHsc
!ENDIF

CXXFLAGS = $(CXXFLAGS) -MT 

CC = cl
DEFS = -D__WIN32__ -DHAVE_CONFIG_H -DPARADOCNUM -D_LITTLE_ENDIAN -DSHORT_SUFFIX -D_CRT_SECURE_NO_DEPRECATE
WINLIBS = kernel32.lib user32.lib gdi32.lib winspool.lib \
          comdlg32.lib advapi32.lib shell32.lib ole32.lib \
          oleaut32.lib uuid.lib

!IF $(GSDL_VC4)
DEFS = $(DEFS) -DGSDL_NAMESPACE_BROKEN -DGSDL_USE_IOS_H -D__STL_NO_NEW_IOSTREAMS
INCLUDES = $(INCLUDES) -I"$(COMMON_PACKAGES_DIR)\windows\stlport\stlport"
!ENDIF

!IF $(LOCAL_LIBRARY)
DEFS = $(DEFS) -DGSDL_LOCAL_LIBRARY
!ENDIF


COMPILE = $(CC) -nologo -c $(CXXFLAGS) $(DEFS) $(INCLUDES)
LINK = $(CC) -nologo $(LDFLAGS) -Fe"$@"

.SUFFIXES:
.SUFFIXES: .cpp .obj
.cpp.obj:
	$(COMPILE) $< 

OBJECTS = starthttpdchild.obj starthttpd.obj stophttpd.obj
EXEC    = starthttpdchild.exe starthttpd.exe stophttpd.exe

all: $(EXEC)

install: $(EXEC)
	if NOT EXIST "$(GSDLHOME)\bin\windows" mkdir "$(GSDLHOME)\bin\windows"
	for %%f in ($(EXEC)) do (copy %%f "$(GSDLHOME)\bin\windows")

clean:
	del *.obj
	del $(EXEC)

distclean:
	del *.obj
	del $(EXEC)
	del "$(GSDLHOME)\bin\windows\starthttpdchild.exe"	
	del "$(GSDLHOME)\bin\windows\starthttpd.exe"
	del "$(GSDLHOME)\bin\windows\stophttpd.exe"

starthttpdchild.exe: starthttpdchild.obj
	$(LINK) starthttpdchild.obj $(WINLIBS)

starthttpd.exe: starthttpd.obj
	$(LINK) starthttpd.obj $(WINLIBS) 

stophttpd.exe: stophttpd.obj
	$(LINK)  stophttpd.obj $(WINLIBS)
