/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.log;

import de.qfs.lib.log.Log;
import de.qfs.lib.log.LogLevelListener;
import de.qfs.lib.log.LogLevels;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Logger {
    public int level;
    public static final int DEFAULT_LOG_LEVEL = 4;
    private String owner;
    private static LogLevels levels = new LogLevels();

    public Logger(String string) {
        this.owner = string;
        this.level = Logger.getLogLevel(this);
    }

    public Logger(Object object) {
        this(object.getClass().getName());
    }

    public Logger(Class clazz) {
        this(clazz.getName());
    }

    public static void setDefaultLogLevel(int n) {
        if (levels != null) {
            levels.setDefaultLogLevel(n);
        }
    }

    public static void setLogLevel(String string, int n) {
        if (levels != null) {
            levels.setLogLevel(string, n);
        }
    }

    public static void removeLogLevel(String string) {
        if (levels != null) {
            levels.removeLogLevel(string);
        }
    }

    public static int getLogLevel(Logger logger) {
        if (levels != null) {
            return levels.getLogLevel(logger);
        }
        return 4;
    }

    public static void setLogLevels(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("log-")) continue;
            try {
                int n = Integer.parseInt((String)hashtable.get(string));
                if (string.equals("log-default")) {
                    Logger.setDefaultLogLevel(n);
                    continue;
                }
                Logger.setLogLevel(string.substring(4), n);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public static void setLogLevels(ResourceBundle resourceBundle) {
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!string.startsWith("log-")) continue;
            try {
                int n = Integer.parseInt(resourceBundle.getString(string));
                if (string.equals("log-default")) {
                    Logger.setDefaultLogLevel(n);
                    continue;
                }
                Logger.setLogLevel(string.substring(4), n);
            }
            catch (MissingResourceException missingResourceException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static void addLogLevelListener(LogLevelListener logLevelListener) {
        levels.addLogLevelListener(logLevelListener);
    }

    public static void removeLogLevelListener(LogLevelListener logLevelListener) {
        levels.removeLogLevelListener(logLevelListener);
    }

    public static Object[] getLogLevels() {
        return levels.getLogLevels();
    }

    public static void setLogLevel(LogLevelListener logLevelListener, String string, int n) {
        levels.setLogLevel(logLevelListener, string, n);
    }

    public static void removeLogLevel(LogLevelListener logLevelListener, String string) {
        levels.removeLogLevel(logLevelListener, string);
    }

    public final void log(int n, String string, String string2) {
        Log.log(n, System.currentTimeMillis(), this.owner, string, string2);
    }

    public final void log(String string, Throwable throwable) {
        Log.log(1, this.owner, string, throwable);
    }

    public final void log(String string, Throwable throwable, String string2) {
        Log.log(1, this.owner, string, throwable, string2);
    }

    public final void log(int n, String string, Throwable throwable) {
        Log.log(n, this.owner, string, throwable);
    }

    public final void log(int n, String string, Throwable throwable, String string2) {
        Log.log(n, this.owner, string, throwable, string2);
    }

    public void dumpStack(int n, String string, String string2) {
        try {
            throw new Exception(string2);
        }
        catch (Exception exception) {
            this.log(n, string, exception);
            return;
        }
    }

    public final void err(String string, String string2) {
        if (this.level >= 1) {
            Log.log(1, System.currentTimeMillis(), this.owner, string, string2);
        }
    }

    public final void err(String string, Throwable throwable) {
        if (this.level >= 1) {
            Log.log(1, this.owner, string, throwable);
        }
    }

    public final void err(String string, Throwable throwable, String string2) {
        if (this.level >= 1) {
            Log.log(1, this.owner, string, throwable, string2);
        }
    }

    public final void wrn(String string, String string2) {
        if (this.level >= 3) {
            Log.log(3, System.currentTimeMillis(), this.owner, string, string2);
        }
    }

    public final void wrn(String string, Throwable throwable) {
        if (this.level >= 3) {
            Log.log(3, this.owner, string, throwable);
        }
    }

    public final void wrn(String string, Throwable throwable, String string2) {
        if (this.level >= 3) {
            Log.log(3, this.owner, string, throwable, string2);
        }
    }

    public final void msg(String string, String string2) {
        if (this.level >= 5) {
            Log.log(5, System.currentTimeMillis(), this.owner, string, string2);
        }
    }

    public final void msg(String string, Throwable throwable) {
        if (this.level >= 5) {
            Log.log(5, this.owner, string, throwable);
        }
    }

    public final void msg(String string, Throwable throwable, String string2) {
        if (this.level >= 5) {
            Log.log(5, this.owner, string, throwable, string2);
        }
    }

    public final void mtd(String string, String string2) {
        if (this.level >= 7) {
            Log.log(7, System.currentTimeMillis(), this.owner, string, string2);
        }
    }

    public final void mtd(String string, Throwable throwable) {
        if (this.level >= 7) {
            Log.log(7, this.owner, string, throwable);
        }
    }

    public final void mtd(String string, Throwable throwable, String string2) {
        if (this.level >= 7) {
            Log.log(7, this.owner, string, throwable, string2);
        }
    }

    public final void dbg(String string, String string2) {
        if (this.level >= 9) {
            Log.log(9, System.currentTimeMillis(), this.owner, string, string2);
        }
    }

    public final void dbg(String string, Throwable throwable) {
        if (this.level >= 9) {
            Log.log(9, this.owner, string, throwable);
        }
    }

    public final void dbg(String string, Throwable throwable, String string2) {
        if (this.level >= 9) {
            Log.log(9, this.owner, string, throwable, string2);
        }
    }

    public String getOwnerName() {
        return this.owner;
    }
}

