/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.pcx;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.pcx.PCXHeader;
import com.sun.jimi.core.decoder.pcx.PCXImage;
import com.sun.jimi.core.util.LEDataInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class PCXDecoder
extends JimiDecoderBase {
    private AdaptiveRasterImage f1;
    private InputStream f2;
    private LEDataInputStream f3;
    private int f4;
    private int f5;
    private PCXHeader f6;
    private PCXImage f7;

    public void initDecoder(InputStream inputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException {
        this.f2 = inputStream;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 2048);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        try {
            int n2;
            while ((n2 = bufferedInputStream.read(byArray)) != -1) {
                n += n2;
                byteArrayOutputStream.write(byArray);
            }
        }
        catch (IOException iOException) {}
        this.f3 = new LEDataInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        this.f5 = n;
        this.f1 = adaptiveRasterImage;
        this.f4 = 0;
    }

    protected void loadImage() throws JimiException {
        try {
            PCXDecoder pCXDecoder = this;
            pCXDecoder.m1(pCXDecoder.f7);
            this.f1.setChannel(0L);
            int n = 0;
            while (n < this.f7.getHeight()) {
                int n2 = n * this.f7.getWidth();
                this.f1.setChannel(0, n, this.f7.getImageData(), n2, this.f7.getWidth());
                this.setProgress(n * 100 / this.f7.getHeight());
                ++n;
            }
            this.f4 |= 4;
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.f4 |= 1;
            throw new JimiException("No more images");
        }
        catch (JimiException jimiException) {
            this.f4 |= 1;
            throw jimiException;
        }
    }

    public boolean driveDecoder() throws JimiException {
        try {
            this.f6 = new PCXHeader(this.f3, this.f5);
            this.f4 |= 2;
            this.f7 = new PCXImage(this.f3, this.f6);
            this.loadImage();
            this.f1.addFullCoverage();
        }
        catch (IOException iOException) {
            this.f4 |= 1;
            throw new JimiException("IO error reading PCX file");
        }
        catch (JimiException jimiException) {
            this.f4 |= 1;
            throw jimiException;
        }
        return false;
    }

    public void freeDecoder() throws JimiException {
        this.f2 = null;
        this.f3 = null;
        this.f1 = null;
    }

    public int getState() {
        return this.f4;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.f1;
    }

    private void m1(PCXImage pCXImage) throws JimiException {
        this.f1.setSize(pCXImage.getWidth(), pCXImage.getHeight());
        this.f1.setColorModel(this.f6.getColorModel());
        this.f1.setPixels();
    }
}

