/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util.lzw;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class BitInput {
    InputStream in_;
    int bits_;
    int bitsCount_;
    int byteCount_;
    int numBits_;
    int numBitsMask_;
    boolean blocks_;

    public void setNumBits(int n) {
        this.numBits_ = n;
        this.numBitsMask_ = (1 << this.numBits_) - 1;
    }

    public int read() throws IOException {
        int n;
        while (this.bitsCount_ < this.numBits_) {
            if (this.blocks_) {
                if (this.byteCount_ == 0) {
                    this.byteCount_ = this.in_.read();
                    if (this.byteCount_ == -1) {
                        throw new EOFException();
                    }
                    this.byteCount_ &= 0xFF;
                }
                --this.byteCount_;
            }
            if ((n = this.in_.read()) == -1) {
                throw new EOFException();
            }
            this.bits_ = this.blocks_ ? this.bits_ & (1 << this.bitsCount_) - 1 | (n & 0xFF) << this.bitsCount_ : this.bits_ << 8 & 0xFFFFFF00 | n & 0xFF;
            this.bitsCount_ += 8;
        }
        if (this.blocks_) {
            n = this.bits_ & this.numBitsMask_;
            this.bits_ >>>= this.numBits_;
        } else {
            n = this.bits_ >>> this.bitsCount_ - this.numBits_ & this.numBitsMask_;
        }
        this.bitsCount_ -= this.numBits_;
        return n;
    }

    public void gifFinishBlocks() throws IOException {
        if (this.blocks_) {
            while (true) {
                if (this.byteCount_ == 0) {
                    this.byteCount_ = this.in_.read();
                    if (this.byteCount_ == -1) {
                        throw new EOFException();
                    }
                    this.byteCount_ &= 0xFF;
                    if (this.byteCount_ == 0) break;
                }
                if (this.byteCount_ == 0) continue;
                this.in_.read();
                --this.byteCount_;
            }
        }
    }

    public BitInput(InputStream inputStream, boolean bl) {
        this.in_ = inputStream;
        this.blocks_ = bl;
        this.bits_ = 0;
        this.bitsCount_ = 0;
        this.byteCount_ = 0;
    }
}

