/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Misc {
    public static final String NEWLINE;

    public static String debugUnicodeString(String str) {
        String result = "";
        for (int i = 0; i < str.length(); ++i) {
            int charCode = str.codePointAt(i);
            result = charCode >= 20 && charCode <= 126 || charCode == 9 || charCode == 10 || charCode == 13 ? result + str.charAt(i) : result + "x{" + String.format("%04x", charCode) + "}";
        }
        return result;
    }

    public static void printHash(HashMap map) {
        Set entries = map.entrySet();
        for (Map.Entry m : entries) {
            String name = (String)m.getKey();
            String string = (String)m.getValue();
        }
    }

    public static void printStackTrace() {
        StackTraceElement[] els;
        System.err.println("\n@@@@ stacktrace:");
        for (StackTraceElement ste : els = new Throwable().getStackTrace()) {
            System.err.println("   " + ste);
        }
    }

    public static void printCaller() {
        int parent = 1;
        Misc.printCaller(parent++);
    }

    public static void printCaller(int ancestor) {
        StackTraceElement[] callstack = Thread.currentThread().getStackTrace();
        StackTraceElement requestor = callstack[2];
        StackTraceElement caller_requested = callstack[ancestor + 3];
        System.err.println("@@@ Function " + requestor + " called by:\n    " + caller_requested + " at " + ancestor + " ancestors back");
    }

    public static boolean isWindows() {
        Properties props = System.getProperties();
        String os_name = props.getProperty("os.name", "");
        return os_name.startsWith("Windows");
    }

    public static boolean isWindows9x() {
        Properties props = System.getProperties();
        String os_name = props.getProperty("os.name", "");
        return os_name.startsWith("Windows") && os_name.indexOf("9") != -1;
    }

    public static boolean isMac() {
        Properties props = System.getProperties();
        String os_name = props.getProperty("os.name", "");
        return os_name.startsWith("Mac OS");
    }

    public static String getGsdlOS() {
        if (Misc.isWindows()) {
            return "windows";
        }
        if (Misc.isMac()) {
            return "darwin";
        }
        return "linux";
    }

    public static boolean isBigEndian() {
        return System.getProperty("sun.cpu.endian").equals("big");
    }

    public static BufferedReader makeHttpConnection(String url_string) throws MalformedURLException, IOException {
        BufferedReader reader = null;
        URL url = new URL(url_string);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        InputStream input = connection.getInputStream();
        reader = new BufferedReader(new InputStreamReader(input));
        return reader;
    }

    public static void main(String[] args) {
        Misc.isBigEndian();
    }

    static {
        double java_version = Double.parseDouble(System.getProperty("java.specification.version"));
        NEWLINE = java_version >= 1.7 ? System.getProperty("line.separator") : (Misc.isWindows() ? "\r\n" : "\n");
    }
}

