/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.util;

import org.apache.log4j.Logger;
import org.greenstone.util.SafeProcess;

public abstract class RunTarget
extends Thread {
    protected String targetCmd = "";
    protected static Logger logger = Logger.getLogger((String)RunTarget.class.getName());
    protected int state = -1;
    public static int SUCCESS = 0;
    public static int FAILED = 1;
    protected String targetSuccess;
    protected String targetFailed;
    protected String targetFinished;

    @Override
    public void run() {
        try {
            this.state = -1;
            String targetCmd = this.getTargetCmd();
            logger.info((Object)("Target: " + targetCmd));
            SafeProcess process = new SafeProcess(targetCmd);
            process.setSplitStdOutputNewLines(true);
            process.runProcess();
            String output = process.getStdOutput();
            String[] lines = output.split("[\\r\\n]+");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i].trim();
                if (line.equals(this.targetSuccess)) {
                    this.state = 0;
                }
                if (line.equals(this.targetFailed)) {
                    this.state = 1;
                }
                if (line.startsWith(this.targetFinished)) break;
            }
            if (this.state < 0) {
                logger.info((Object)("Unexpected end of input when running target: " + targetCmd));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e);
            this.state = 1;
        }
    }

    public int getTargetState() {
        return this.state;
    }

    public abstract void setTargetCmd(String var1);

    public String getTargetCmd() {
        return this.targetCmd;
    }
}

