/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.action;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.action.Action;
import org.greenstone.gsdl3.util.GSPath;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.OID;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BrowseAction
extends Action {
    static Logger logger = Logger.getLogger((String)BrowseAction.class.getName());
    public static final String CLASSIFIER_ARG = "cl";
    public static final String SIBLING_ARG = "sib";

    public Node process(Node message_node) {
        Element message = XMLConverter.nodeToElement(message_node);
        Element request = (Element)GSXML.getChildByTagName(message, "request");
        Element result = this.doc.createElement("message");
        Element response = this.classifierBrowse(request);
        result.appendChild(response);
        return result;
    }

    protected Element classifierBrowse(Element request) {
        NodeList doc_nodes;
        Element page_response = this.doc.createElement("response");
        Element cgi_paramList = (Element)GSXML.getChildByTagName(request, "paramList");
        HashMap params = GSXML.extractParams(cgi_paramList, false);
        String service_name = (String)params.get("s");
        String collection = (String)params.get("c");
        if (collection == null || collection.equals("")) {
            logger.error((Object)"classifierBrowse, need to specify a collection!");
            return page_response;
        }
        boolean get_siblings = false;
        String sibs = (String)params.get(SIBLING_ARG);
        if (sibs != null && sibs.equals("1")) {
            get_siblings = true;
        }
        String lang = request.getAttribute("lang");
        String uid = request.getAttribute("uid");
        String to = GSPath.appendLink(collection, service_name);
        Element info_message = this.doc.createElement("message");
        Element info_request = GSXML.createBasicRequest(this.doc, "describe", to, lang, uid);
        info_message.appendChild(info_request);
        Element format_request = GSXML.createBasicRequest(this.doc, "format", to, lang, uid);
        info_message.appendChild(format_request);
        Element info_response = (Element)this.mr.process(info_message);
        NodeList responses = info_response.getElementsByTagName("response");
        Element service_response = (Element)responses.item(0);
        Element format_response = (Element)responses.item(1);
        Element service_description = (Element)GSXML.getChildByTagName(service_response, "service");
        page_response.appendChild(this.doc.importNode(service_description, true));
        String request_type = (String)params.get("rt");
        if (request_type.equals("d")) {
            return page_response;
        }
        String classifier_node = (String)params.get(CLASSIFIER_ARG);
        if (classifier_node == null || classifier_node.equals("")) {
            return page_response;
        }
        String top_id = OID.getTop(classifier_node);
        HashSet metadata_names = new HashSet();
        Element format_elem = (Element)GSXML.getChildByTagName(format_response, "format");
        if (format_elem != null) {
            Element this_format = GSXML.getNamedElement(format_elem, "classifier", "name", top_id);
            if (this_format == null) {
                this_format = (Element)GSXML.getChildByTagName(format_elem, "default");
            }
            if (this_format != null) {
                Element new_format = GSXML.duplicateWithNewName(this.doc, this_format, "format", false);
                new_format.setAttribute("type", "browse");
                page_response.appendChild(new_format);
                this.extractMetadataNames(new_format, metadata_names);
            }
        }
        logger.info((Object)("extracted meta names, " + metadata_names.toString()));
        Element classify_message = this.doc.createElement("message");
        Element classify_request = GSXML.createBasicRequest(this.doc, "process", to, lang, uid);
        classify_message.appendChild(classify_request);
        Element param_list = this.doc.createElement("paramList");
        classify_request.appendChild(param_list);
        Element param = this.doc.createElement("param");
        param_list.appendChild(param);
        param.setAttribute("name", "structure");
        param.setAttribute("value", "ancestors");
        param = this.doc.createElement("param");
        param_list.appendChild(param);
        param.setAttribute("name", "structure");
        param.setAttribute("value", "children");
        if (get_siblings) {
            param = this.doc.createElement("param");
            param_list.appendChild(param);
            param.setAttribute("name", "structure");
            param.setAttribute("value", "siblings");
        }
        Element classifier_list = this.doc.createElement("classifierNodeList");
        Element classifier = this.doc.createElement("classifierNode");
        classifier.setAttribute("nodeID", classifier_node);
        classifier_list.appendChild(classifier);
        classify_request.appendChild(classifier_list);
        Element classify_response = (Element)this.mr.process(classify_message);
        String path = GSPath.appendLink("response", "classifierNodeList");
        path = GSPath.appendLink(path, "classifierNode");
        path = GSPath.appendLink(path, "nodeStructure");
        path = GSPath.appendLink(path, "classifierNode");
        Element cl_structure = (Element)GSXML.getNodeByPath(classify_response, path);
        if (cl_structure == null) {
            logger.error((Object)"classifier structure request returned no structure");
            return page_response;
        }
        Element page_classifier = GSXML.duplicateWithNewName(this.doc, cl_structure, "classifier", true);
        page_response.appendChild(page_classifier);
        page_classifier.setAttribute("name", top_id);
        Element metadata_message = this.doc.createElement("message");
        boolean did_classifier = false;
        boolean did_documents = false;
        NodeList cl_nodes = page_classifier.getElementsByTagName("classifierNode");
        if (cl_nodes.getLength() > 0) {
            did_classifier = true;
            Element cl_meta_request = GSXML.createBasicRequest(this.doc, "process", to + "MetadataRetrieve", lang, uid);
            metadata_message.appendChild(cl_meta_request);
            Element new_cl_nodes_list = this.doc.createElement("classifierNodeList");
            cl_meta_request.appendChild(new_cl_nodes_list);
            for (int c = 0; c < cl_nodes.getLength(); ++c) {
                Element cl = this.doc.createElement("classifierNode");
                cl.setAttribute("nodeID", ((Element)cl_nodes.item(c)).getAttribute("nodeID"));
                new_cl_nodes_list.appendChild(cl);
            }
            Element cl_param_list = null;
            if (metadata_names.isEmpty()) {
                cl_param_list = this.doc.createElement("paramList");
                Element p = this.doc.createElement("param");
                cl_param_list.appendChild(p);
                p.setAttribute("name", "metadata");
                p.setAttribute("value", "Title");
            } else {
                cl_param_list = this.createMetadataParamList(metadata_names);
            }
            cl_meta_request.appendChild(cl_param_list);
        }
        if ((doc_nodes = page_classifier.getElementsByTagName("documentNode")).getLength() > 0) {
            did_documents = true;
            Element doc_meta_request = GSXML.createBasicRequest(this.doc, "process", GSPath.appendLink(collection, "DocumentMetadataRetrieve"), lang, uid);
            metadata_message.appendChild(doc_meta_request);
            Element doc_list = this.doc.createElement("documentNodeList");
            doc_meta_request.appendChild(doc_list);
            for (int c = 0; c < doc_nodes.getLength(); ++c) {
                Element d = this.doc.createElement("documentNode");
                d.setAttribute("nodeID", ((Element)doc_nodes.item(c)).getAttribute("nodeID"));
                doc_list.appendChild(d);
            }
            Element doc_param_list = this.doc.createElement("paramList");
            Element p = this.doc.createElement("param");
            doc_param_list.appendChild(p);
            p.setAttribute("name", "metadata");
            p.setAttribute("value", "all");
            doc_meta_request.appendChild(doc_param_list);
        }
        Element metadata_response = (Element)this.mr.process(metadata_message);
        if (did_classifier) {
            path = GSPath.appendLink("response", "classifierNodeList");
            NodeList meta_response_cls = GSXML.getNodeByPath(metadata_response, path).getChildNodes();
            for (int i = 0; i < cl_nodes.getLength(); ++i) {
                GSXML.mergeMetadataLists(cl_nodes.item(i), meta_response_cls.item(i));
            }
        }
        if (did_documents) {
            NodeList meta_response_docs = null;
            if (!did_classifier) {
                path = GSPath.appendLink("response", "documentNodeList");
                meta_response_docs = GSXML.getNodeByPath(metadata_response, path).getChildNodes();
            } else {
                meta_response_docs = GSXML.getChildByTagName(metadata_response.getElementsByTagName("response").item(1), "documentNodeList").getChildNodes();
            }
            for (int i = 0; i < doc_nodes.getLength(); ++i) {
                GSXML.mergeMetadataLists(doc_nodes.item(i), meta_response_docs.item(i));
            }
        }
        logger.debug((Object)("(BrowseAction) Page:\n" + XMLConverter.getPrettyString(page_response)));
        return page_response;
    }

    protected Element unknownBrowse(Element page, Element request, String browse_type) {
        logger.error((Object)("unknown browse subtype: " + browse_type));
        return null;
    }
}

