/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.action.Action;
import org.greenstone.gsdl3.util.GSParams;
import org.greenstone.gsdl3.util.GSPath;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentAction
extends Action {
    static Logger logger = Logger.getLogger((String)DocumentAction.class.getName());
    public static final String SIBLING_ARG = "sib";
    public static final String GOTO_PAGE_ARG = "gp";
    public static final String ENRICH_DOC_ARG = "end";
    protected boolean provide_annotations = false;
    protected boolean highlight_query_terms = false;

    public boolean configure() {
        String annotate;
        super.configure();
        String highlight = (String)this.config_params.get("highlightQueryTerms");
        if (highlight != null && highlight.equals("true")) {
            this.highlight_query_terms = true;
        }
        if ((annotate = (String)this.config_params.get("displayAnnotationService")) != null && annotate.equals("true")) {
            this.provide_annotations = true;
        }
        return true;
    }

    public Node process(Node message_node) {
        String to;
        String sibling_num;
        Element message = XMLConverter.nodeToElement(message_node);
        Element result = this.doc.createElement("message");
        Element page_response = this.doc.createElement("response");
        result.appendChild(page_response);
        Element request = (Element)GSXML.getChildByTagName(message, "request");
        Element cgi_paramList = (Element)GSXML.getChildByTagName(request, "paramList");
        HashMap params = GSXML.extractParams(cgi_paramList, false);
        HashMap service_params = (HashMap)params.get("s0");
        String has_rl = null;
        String has_href = null;
        has_href = (String)params.get("href");
        has_rl = (String)params.get("rl");
        String collection = (String)params.get("c");
        String lang = request.getAttribute("lang");
        String uid = request.getAttribute("uid");
        String document_name = (String)params.get("d");
        if ((document_name == null || document_name.equals("")) && (has_href == null || has_href.equals(""))) {
            logger.error((Object)"no document specified!");
            return result;
        }
        String document_type = (String)params.get("dt");
        if (document_type == null) {
            document_type = "simple";
        }
        boolean get_siblings = false;
        String sibs = (String)params.get(SIBLING_ARG);
        if (sibs != null && sibs.equals("1")) {
            get_siblings = true;
        }
        if ((sibling_num = (String)params.get(GOTO_PAGE_ARG)) != null && !sibling_num.equals("")) {
            document_name = document_name + "." + sibling_num + ".ss";
        }
        boolean expand_document = false;
        String ed_arg = (String)params.get("ed");
        if (ed_arg != null && ed_arg.equals("1")) {
            expand_document = true;
        }
        boolean expand_contents = false;
        if (expand_document) {
            expand_contents = true;
        } else {
            String ec_arg = (String)params.get("ec");
            if (ec_arg != null && ec_arg.equals("1")) {
                expand_contents = true;
            }
        }
        this.getBackgroundData(page_response, collection, lang, uid);
        Element format_elem = (Element)GSXML.getChildByTagName(page_response, "format");
        Element the_document = this.doc.createElement("document");
        page_response.appendChild(the_document);
        the_document.setAttribute("docType", document_type);
        Element basic_doc_list = this.doc.createElement("documentNodeList");
        Element current_doc = this.doc.createElement("documentNode");
        basic_doc_list.appendChild(current_doc);
        if (document_name.length() != 0) {
            current_doc.setAttribute("nodeID", document_name);
        } else if (has_href.length() != 0) {
            current_doc.setAttribute("nodeID", has_href);
            current_doc.setAttribute("externalURL", has_rl);
        }
        Element ds_param_list = this.doc.createElement("paramList");
        if (service_params != null) {
            GSXML.addParametersToList(this.doc, ds_param_list, service_params);
        }
        Element ds_param = null;
        boolean get_structure = false;
        boolean get_structure_info = false;
        if (document_type.equals("paged")) {
            get_structure_info = true;
            ds_param = this.doc.createElement("param");
            ds_param_list.appendChild(ds_param);
            ds_param.setAttribute("name", "info");
            ds_param.setAttribute("value", "numSiblings");
            ds_param = this.doc.createElement("param");
            ds_param_list.appendChild(ds_param);
            ds_param.setAttribute("name", "info");
            ds_param.setAttribute("value", "numChildren");
            ds_param = this.doc.createElement("param");
            ds_param_list.appendChild(ds_param);
            ds_param.setAttribute("name", "info");
            ds_param.setAttribute("value", "siblingPosition");
        } else if (document_type.equals("hierarchy")) {
            get_structure = true;
            if (expand_contents) {
                ds_param = this.doc.createElement("param");
                ds_param_list.appendChild(ds_param);
                ds_param.setAttribute("name", "structure");
                ds_param.setAttribute("value", "entire");
            } else {
                ds_param = this.doc.createElement("param");
                ds_param_list.appendChild(ds_param);
                ds_param.setAttribute("name", "structure");
                ds_param.setAttribute("value", "ancestors");
                ds_param = this.doc.createElement("param");
                ds_param_list.appendChild(ds_param);
                ds_param.setAttribute("name", "structure");
                ds_param.setAttribute("value", "children");
                if (get_siblings) {
                    ds_param = this.doc.createElement("param");
                    ds_param_list.appendChild(ds_param);
                    ds_param.setAttribute("name", "structure");
                    ds_param.setAttribute("value", "siblings");
                }
            }
        }
        boolean has_dummy = false;
        if (get_structure || get_structure_info) {
            Element ds_message = this.doc.createElement("message");
            to = GSPath.appendLink(collection, "DocumentStructureRetrieve");
            Element ds_request = GSXML.createBasicRequest(this.doc, "process", to, lang, uid);
            ds_message.appendChild(ds_request);
            ds_request.appendChild(ds_param_list);
            ds_request.appendChild(basic_doc_list);
            Element ds_response_message = (Element)this.mr.process(ds_message);
            if (this.processErrorElements(ds_response_message, page_response)) {
                return result;
            }
            String path = GSPath.appendLink("response", "documentNodeList");
            path = GSPath.appendLink(path, "documentNode");
            Element ds_response_struct_info = (Element)GSXML.getNodeByPath(ds_response_message, path = GSPath.appendLink(path, "nodeStructureInfo"));
            if (ds_response_struct_info != null) {
                the_document.appendChild(this.doc.importNode(ds_response_struct_info, true));
            }
            path = GSPath.appendLink("response", "documentNodeList");
            path = GSPath.appendLink(path, "documentNode");
            Element ds_response_structure = (Element)GSXML.getNodeByPath(ds_response_message, path = GSPath.appendLink(path, "nodeStructure"));
            if (ds_response_structure != null) {
                NodeList structs = ds_response_structure.getChildNodes();
                for (int i = 0; i < structs.getLength(); ++i) {
                    the_document.appendChild(this.doc.importNode(structs.item(i), true));
                }
            } else {
                Element doc_node = this.doc.createElement("documentNode");
                if (document_name.length() != 0) {
                    doc_node.setAttribute("nodeID", document_name);
                } else if (has_href.length() != 0) {
                    doc_node.setAttribute("nodeID", has_href);
                    doc_node.setAttribute("externalURL", has_rl);
                }
                the_document.appendChild(doc_node);
                has_dummy = true;
            }
        } else {
            Element doc_node = this.doc.createElement("documentNode");
            if (document_name.length() != 0) {
                doc_node.setAttribute("nodeID", document_name);
            } else if (has_href.length() != 0) {
                doc_node.setAttribute("nodeID", has_href);
                doc_node.setAttribute("externalURL", has_rl);
            }
            the_document.appendChild(doc_node);
            has_dummy = true;
        }
        Element dm_message = this.doc.createElement("message");
        to = GSPath.appendLink(collection, "DocumentMetadataRetrieve");
        Element dm_request = GSXML.createBasicRequest(this.doc, "process", to, lang, uid);
        dm_message.appendChild(dm_request);
        HashSet<String> meta_names = new HashSet<String>();
        meta_names.add("Title");
        if (format_elem != null) {
            this.extractMetadataNames(format_elem, meta_names);
        }
        Element dm_param_list = this.createMetadataParamList(meta_names);
        if (service_params != null) {
            GSXML.addParametersToList(this.doc, dm_param_list, service_params);
        }
        dm_request.appendChild(dm_param_list);
        Element dm_doc_list = this.doc.createElement("documentNodeList");
        dm_request.appendChild(dm_doc_list);
        NodeList doc_nodes = the_document.getElementsByTagName("documentNode");
        for (int i = 0; i < doc_nodes.getLength(); ++i) {
            Element doc_node = (Element)doc_nodes.item(i);
            String doc_node_id = doc_node.getAttribute("nodeID");
            Element dm_doc_node = this.doc.createElement("documentNode");
            dm_doc_list.appendChild(dm_doc_node);
            dm_doc_node.setAttribute("nodeID", doc_node_id);
            dm_doc_node.setAttribute("nodeType", doc_node.getAttribute("nodeType"));
        }
        Element doc_meta_request = GSXML.createBasicRequest(this.doc, "process", to, lang, uid);
        dm_message.appendChild(doc_meta_request);
        Element doc_meta_param_list = this.doc.createElement("paramList");
        if (service_params != null) {
            GSXML.addParametersToList(this.doc, doc_meta_param_list, service_params);
        }
        doc_meta_request.appendChild(doc_meta_param_list);
        Element doc_param = this.doc.createElement("param");
        doc_meta_param_list.appendChild(doc_param);
        doc_param.setAttribute("name", "metadata");
        doc_param.setAttribute("value", "archivedir");
        Element doc_list = this.doc.createElement("documentNodeList");
        doc_meta_request.appendChild(doc_list);
        Element doc_node = this.doc.createElement("documentNode");
        if (document_name.length() != 0) {
            doc_node.setAttribute("nodeID", document_name + ".rt");
        } else if (has_href.length() != 0) {
            doc_node.setAttribute("nodeID", has_href + ".rt");
            doc_node.setAttribute("externalURL", has_rl);
        }
        doc_list.appendChild(doc_node);
        Element dm_response_message = (Element)this.mr.process(dm_message);
        if (this.processErrorElements(dm_response_message, page_response)) {
            return result;
        }
        String path = GSPath.appendLink("response", "documentNodeList");
        Element dm_response_doc_list = (Element)GSXML.getNodeByPath(dm_response_message, path);
        NodeList dm_response_docs = dm_response_doc_list.getChildNodes();
        for (int i = 0; i < doc_nodes.getLength(); ++i) {
            GSXML.mergeMetadataLists(doc_nodes.item(i), dm_response_docs.item(i));
        }
        Element doc_meta_response = (Element)dm_response_message.getElementsByTagName("response").item(1);
        Element doc_meta_list = (Element)GSXML.getNodeByPath(doc_meta_response, "documentNodeList/documentNode/metadataList");
        if (doc_meta_list != null) {
            the_document.appendChild(this.doc.importNode(doc_meta_list, true));
        }
        Element dc_message = this.doc.createElement("message");
        to = GSPath.appendLink(collection, "DocumentContentRetrieve");
        Element dc_request = GSXML.createBasicRequest(this.doc, "process", to, lang, uid);
        dc_message.appendChild(dc_request);
        Element dc_param_list = this.doc.createElement("paramList");
        if (service_params != null) {
            GSXML.addParametersToList(this.doc, dc_param_list, service_params);
        }
        dc_request.appendChild(dc_param_list);
        if (expand_document) {
            dc_request.appendChild(dm_doc_list);
        } else {
            dc_request.appendChild(basic_doc_list);
        }
        logger.debug((Object)("request = " + XMLConverter.getString(dc_message)));
        Element dc_response_message = (Element)this.mr.process(dc_message);
        if (this.processErrorElements(dc_response_message, page_response)) {
            return result;
        }
        Element dc_response_doc_list = (Element)GSXML.getNodeByPath(dc_response_message, path);
        if (expand_document) {
            NodeList dc_response_docs = dc_response_doc_list.getChildNodes();
            for (int i = 0; i < doc_nodes.getLength(); ++i) {
                Node content = GSXML.getChildByTagName((Element)dc_response_docs.item(i), "nodeContent");
                if (content == null) continue;
                doc_nodes.item(i).appendChild(this.doc.importNode(content, true));
            }
        } else {
            String service_selected;
            Element dc_response_doc = (Element)GSXML.getChildByTagName(dc_response_doc_list, "documentNode");
            Element dc_response_doc_content = (Element)GSXML.getChildByTagName(dc_response_doc, "nodeContent");
            Element dc_response_doc_external = (Element)GSXML.getChildByTagName(dc_response_doc, "external");
            if (dc_response_doc_content == null) {
                if (dc_response_doc_external != null) {
                    String modified_doc_id = dc_response_doc.getAttribute("nodeID");
                    the_document.setAttribute("selectedNode", modified_doc_id);
                    the_document.setAttribute("external", dc_response_doc_external.getAttribute("external_link"));
                }
                return result;
            }
            if (this.highlight_query_terms) {
                dc_response_doc.removeChild(dc_response_doc_content);
                dc_response_doc_content = this.highlightQueryTerms(request, dc_response_doc_content);
                dc_response_doc.appendChild(dc_response_doc.getOwnerDocument().importNode(dc_response_doc_content, true));
            }
            if (this.provide_annotations && (service_selected = (String)params.get(ENRICH_DOC_ARG)) != null && service_selected.equals("1")) {
                String enrich_service = (String)params.get("s");
                Element enrich_message = this.doc.createElement("message");
                Element enrich_request = GSXML.createBasicRequest(this.doc, "process", enrich_service, lang, uid);
                enrich_message.appendChild(enrich_request);
                HashMap e_service_params = (HashMap)params.get("s1");
                if (e_service_params != null) {
                    Element enrich_pl = this.doc.createElement("paramList");
                    GSXML.addParametersToList(this.doc, enrich_pl, e_service_params);
                    enrich_request.appendChild(enrich_pl);
                }
                Element e_doc_list = this.doc.createElement("documentNodeList");
                enrich_request.appendChild(e_doc_list);
                e_doc_list.appendChild(this.doc.importNode(dc_response_doc, true));
                Node enrich_response = this.mr.process(enrich_message);
                String[] links = new String[]{"response", "documentNodeList", "documentNode", "nodeContent"};
                path = GSPath.createPath(links);
                dc_response_doc_content = (Element)GSXML.getNodeByPath(enrich_response, path);
            }
            String modified_doc_id = dc_response_doc.getAttribute("nodeID");
            the_document.setAttribute("selectedNode", modified_doc_id);
            if (has_dummy) {
                Element dummy_node = (Element)doc_nodes.item(0);
                dummy_node.setAttribute("nodeID", modified_doc_id);
                dummy_node.appendChild(this.doc.importNode(dc_response_doc_content, true));
                if (document_type.equals("simple")) {
                    the_document.removeChild(dummy_node);
                    NodeList dummy_children = dummy_node.getChildNodes();
                    for (int i = dummy_children.getLength() - 1; i >= 0; --i) {
                        the_document.appendChild(dummy_children.item(i));
                    }
                }
            } else {
                for (int i = 0; i < doc_nodes.getLength(); ++i) {
                    Node dn = doc_nodes.item(i);
                    String dn_id = ((Element)dn).getAttribute("nodeID");
                    if (!dn_id.equals(modified_doc_id)) continue;
                    dn.appendChild(this.doc.importNode(dc_response_doc_content, true));
                    break;
                }
            }
        }
        logger.debug((Object)("(DocumentAction) Page:\n" + XMLConverter.getPrettyString(result)));
        return result;
    }

    public boolean getActionParameters(GSParams params) {
        params.addParameter(GOTO_PAGE_ARG, false);
        params.addParameter(ENRICH_DOC_ARG, false);
        return true;
    }

    protected boolean getBackgroundData(Element page_response, String collection, String lang, String uid) {
        Element info_response;
        NodeList responses;
        Element format_resp;
        Element format_elem;
        Element info_message = this.doc.createElement("message");
        String path = GSPath.appendLink(collection, "DocumentContentRetrieve");
        Element format_request = GSXML.createBasicRequest(this.doc, "format", path, lang, uid);
        info_message.appendChild(format_request);
        if (this.provide_annotations) {
            Element enrich_services_request = GSXML.createBasicRequest(this.doc, "describe", "", lang, uid);
            enrich_services_request.setAttribute("info", "serviceList");
            info_message.appendChild(enrich_services_request);
        }
        if ((format_elem = (Element)GSXML.getChildByTagName(format_resp = (Element)(responses = (info_response = (Element)this.mr.process(info_message)).getElementsByTagName("response")).item(0), "format")) != null) {
            logger.debug((Object)"doc action found a format statement");
            format_elem.setAttribute("type", "display");
            page_response.appendChild(this.doc.importNode(format_elem, true));
        }
        if (this.provide_annotations) {
            Element services_resp = (Element)responses.item(1);
            Element enrich_message = this.doc.createElement("message");
            NodeList e_services = services_resp.getElementsByTagName("service");
            boolean service_found = false;
            for (int j = 0; j < e_services.getLength(); ++j) {
                if (!((Element)e_services.item(j)).getAttribute("type").equals("enrich")) continue;
                Element s = GSXML.createBasicRequest(this.doc, "describe", ((Element)e_services.item(j)).getAttribute("name"), lang, uid);
                enrich_message.appendChild(s);
                service_found = true;
            }
            if (service_found) {
                Element enrich_response = (Element)this.mr.process(enrich_message);
                NodeList e_responses = enrich_response.getElementsByTagName("response");
                Element service_list = this.doc.createElement("serviceList");
                for (int i = 0; i < e_responses.getLength(); ++i) {
                    Element e_resp = (Element)e_responses.item(i);
                    Element e_service = (Element)this.doc.importNode(GSXML.getChildByTagName(e_resp, "service"), true);
                    e_service.setAttribute("name", e_resp.getAttribute("from"));
                    service_list.appendChild(e_service);
                }
                page_response.appendChild(service_list);
            }
        }
        return true;
    }

    protected Element highlightQueryTerms(Element request, Element dc_response_doc_content) {
        Element cgi_param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        HashMap params = GSXML.extractParams(cgi_param_list, false);
        HashMap previous_params = (HashMap)params.get("p");
        if (previous_params == null) {
            return dc_response_doc_content;
        }
        String service_name = (String)previous_params.get("s");
        if (service_name == null || !service_name.endsWith("Query")) {
            logger.error((Object)"invalid service, not doing highlighting");
            return dc_response_doc_content;
        }
        String collection = (String)params.get("c");
        String lang = request.getAttribute("lang");
        String uid = request.getAttribute("uid");
        String to = GSPath.appendLink(collection, service_name);
        Element mr_query_message = this.doc.createElement("message");
        Element mr_query_request = GSXML.createBasicRequest(this.doc, "process", to, lang, uid);
        mr_query_message.appendChild(mr_query_request);
        HashMap service_params = (HashMap)params.get("s1");
        Element query_param_list = this.doc.createElement("paramList");
        GSXML.addParametersToList(this.doc, query_param_list, service_params);
        mr_query_request.appendChild(query_param_list);
        Element mr_query_response = (Element)this.mr.process(mr_query_message);
        String path = GSPath.appendLink("response", "termList");
        Element query_term_list_element = (Element)GSXML.getNodeByPath(mr_query_response, path);
        if (query_term_list_element == null) {
            logger.error((Object)"No query term information.\n");
            return dc_response_doc_content;
        }
        String content = GSXML.getNodeText(dc_response_doc_content);
        String metadata_path = GSPath.appendLink("response", "metadataList");
        Element metadata_list = (Element)GSXML.getNodeByPath(mr_query_response, metadata_path);
        HashSet<String> query_term_variants = new HashSet<String>();
        NodeList equivalent_terms_nodelist = query_term_list_element.getElementsByTagName("equivTermList");
        for (int i = 0; i < equivalent_terms_nodelist.getLength(); ++i) {
            Element equivalent_terms_element = (Element)equivalent_terms_nodelist.item(i);
            String[] equivalent_terms = GSXML.getAttributeValuesFromList(equivalent_terms_element, "name");
            for (int j = 0; j < equivalent_terms.length; ++j) {
                query_term_variants.add(equivalent_terms[j]);
            }
        }
        ArrayList phrase_query_term_variants_hierarchy = new ArrayList();
        Element query_element = GSXML.getNamedElement(metadata_list, "metadata", "name", "query");
        String performed_query = GSXML.getNodeText(query_element) + " ";
        ArrayList phrase_query_p_term_variants_list = new ArrayList();
        int term_start = 0;
        boolean in_term = false;
        boolean in_phrase = false;
        for (int i = 0; i < performed_query.length(); ++i) {
            char character = performed_query.charAt(i);
            boolean is_character_letter_or_digit = Character.isLetterOrDigit(character);
            if (!in_term && is_character_letter_or_digit) {
                in_term = true;
                term_start = i;
            } else if (in_term && !is_character_letter_or_digit) {
                in_term = false;
                String term = performed_query.substring(term_start, i);
                Element term_element = GSXML.getNamedElement(query_term_list_element, "term", "name", term);
                if (term_element != null) {
                    HashSet<String> phrase_query_p_term_x_variants = new HashSet<String>();
                    NodeList term_equivalent_terms_nodelist = term_element.getElementsByTagName("equivTermList");
                    for (int j = 0; j < term_equivalent_terms_nodelist.getLength(); ++j) {
                        Element term_equivalent_terms_element = (Element)term_equivalent_terms_nodelist.item(j);
                        String[] term_equivalent_terms = GSXML.getAttributeValuesFromList(term_equivalent_terms_element, "name");
                        for (int k = 0; k < term_equivalent_terms.length; ++k) {
                            phrase_query_p_term_x_variants.add(term_equivalent_terms[k]);
                        }
                    }
                    phrase_query_p_term_variants_list.add(phrase_query_p_term_x_variants);
                    if (!in_phrase) {
                        phrase_query_term_variants_hierarchy.add(phrase_query_p_term_variants_list);
                        phrase_query_p_term_variants_list = new ArrayList();
                    }
                }
            }
            if (character != '\"') continue;
            if (!in_phrase) {
                in_phrase = true;
            } else if (in_phrase) {
                in_phrase = false;
                phrase_query_term_variants_hierarchy.add(phrase_query_p_term_variants_list);
            }
            phrase_query_p_term_variants_list = new ArrayList();
        }
        return this.highlightQueryTermsInternal(content, query_term_variants, phrase_query_term_variants_hierarchy);
    }

    private Element highlightQueryTermsInternal(String content, HashSet query_term_variants, ArrayList phrase_query_term_variants_hierarchy) {
        String word;
        char[] content_characters = new char[content.length()];
        content.getChars(0, content.length(), content_characters, 0);
        ArrayList<WordMatch> word_matches = new ArrayList<WordMatch>();
        int word_start = 0;
        boolean in_word = false;
        boolean preceding_word_matched = false;
        for (int i = 0; i < content_characters.length; ++i) {
            boolean is_character_letter_or_digit = Character.isLetterOrDigit(content_characters[i]);
            if (!in_word && is_character_letter_or_digit) {
                in_word = true;
                word_start = i;
                continue;
            }
            if (!in_word || is_character_letter_or_digit) continue;
            in_word = false;
            String word2 = new String(content_characters, word_start, i - word_start);
            if (query_term_variants.contains(word2)) {
                word_matches.add(new WordMatch(word2, word_start, i, preceding_word_matched));
                preceding_word_matched = true;
                continue;
            }
            preceding_word_matched = false;
        }
        if (in_word && query_term_variants.contains(word = new String(content_characters, word_start, content_characters.length - word_start))) {
            word_matches.add(new WordMatch(word, word_start, content_characters.length, preceding_word_matched));
        }
        ArrayList<Integer> highlight_start_positions = new ArrayList<Integer>();
        ArrayList<Integer> highlight_end_positions = new ArrayList<Integer>();
        ArrayList<PartialPhraseMatch> partial_phrase_matches = new ArrayList<PartialPhraseMatch>();
        for (int i = 0; i < word_matches.size(); ++i) {
            WordMatch word_match = (WordMatch)word_matches.get(i);
            if (word_match.preceding_word_matched) {
                for (int j = partial_phrase_matches.size() - 1; j >= 0; --j) {
                    PartialPhraseMatch partial_phrase_match = (PartialPhraseMatch)partial_phrase_matches.remove(j);
                    ArrayList phrase_query_p_term_variants_list = (ArrayList)phrase_query_term_variants_hierarchy.get(partial_phrase_match.query_phrase_number);
                    HashSet phrase_query_p_term_x_variants = (HashSet)phrase_query_p_term_variants_list.get(partial_phrase_match.num_words_matched);
                    if (!phrase_query_p_term_x_variants.contains(word_match.word)) continue;
                    ++partial_phrase_match.num_words_matched;
                    if (partial_phrase_match.num_words_matched == phrase_query_p_term_variants_list.size()) {
                        int last_highlight_index;
                        int last_highlight_end;
                        if (!highlight_end_positions.isEmpty() && (last_highlight_end = ((Integer)highlight_end_positions.get(last_highlight_index = highlight_end_positions.size() - 1)).intValue()) > partial_phrase_match.start_position) {
                            int last_highlight_start = (Integer)highlight_start_positions.remove(last_highlight_index);
                            highlight_end_positions.remove(last_highlight_index);
                            partial_phrase_match.start_position = last_highlight_start;
                        }
                        highlight_start_positions.add(new Integer(partial_phrase_match.start_position));
                        highlight_end_positions.add(new Integer(word_match.end_position));
                        continue;
                    }
                    partial_phrase_matches.add(partial_phrase_match);
                }
            } else {
                partial_phrase_matches.clear();
            }
            for (int p = 0; p < phrase_query_term_variants_hierarchy.size(); ++p) {
                ArrayList phrase_query_p_term_variants_list = (ArrayList)phrase_query_term_variants_hierarchy.get(p);
                HashSet phrase_query_p_term_1_variants = (HashSet)phrase_query_p_term_variants_list.get(0);
                if (!phrase_query_p_term_1_variants.contains(word_match.word)) continue;
                if (phrase_query_p_term_variants_list.size() == 1) {
                    highlight_start_positions.add(new Integer(word_match.start_position));
                    highlight_end_positions.add(new Integer(word_match.end_position));
                    continue;
                }
                partial_phrase_matches.add(new PartialPhraseMatch(word_match.start_position, p));
            }
        }
        Element content_element = this.doc.createElement("nodeContent");
        int last_wrote = 0;
        for (int i = 0; i < highlight_start_positions.size(); ++i) {
            int highlight_start = (Integer)highlight_start_positions.get(i);
            int highlight_end = (Integer)highlight_end_positions.get(i);
            if (last_wrote < highlight_start) {
                String preceding_text = new String(content_characters, last_wrote, highlight_start - last_wrote);
                content_element.appendChild(this.doc.createTextNode(preceding_text));
            }
            if (highlight_end <= last_wrote) continue;
            String highlight_text = new String(content_characters, highlight_start, highlight_end - highlight_start);
            Element annotation_element = GSXML.createTextElement(this.doc, "annotation", highlight_text);
            annotation_element.setAttribute("type", "query_term");
            content_element.appendChild(annotation_element);
            last_wrote = highlight_end;
        }
        if (last_wrote < content_characters.length) {
            String remaining_text = new String(content_characters, last_wrote, content_characters.length - last_wrote);
            content_element.appendChild(this.doc.createTextNode(remaining_text));
        }
        return content_element;
    }

    private static class PartialPhraseMatch {
        public int start_position;
        public int query_phrase_number;
        public int num_words_matched;

        public PartialPhraseMatch(int start_position, int query_phrase_number) {
            this.start_position = start_position;
            this.query_phrase_number = query_phrase_number;
            this.num_words_matched = 1;
        }
    }

    private static class WordMatch {
        public String word;
        public int start_position;
        public int end_position;
        public boolean preceding_word_matched;

        public WordMatch(String word, int start_position, int end_position, boolean preceding_word_matched) {
            this.word = word;
            this.start_position = start_position;
            this.end_position = end_position;
            this.preceding_word_matched = preceding_word_matched;
        }
    }
}

