/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.service.ServiceRack;
import org.greenstone.gsdl3.util.GSPath;
import org.greenstone.gsdl3.util.GSXML;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractSearch
extends ServiceRack {
    static Logger logger = Logger.getLogger((String)AbstractSearch.class.getName());
    protected static final String TEXT_QUERY_SERVICE = "TextQuery";
    protected static final String INDEX_PARAM = "index";
    protected static final String QUERY_PARAM = "query";
    protected static final String INDEX_SUBCOLLECTION_PARAM = "indexSubcollection";
    protected static final String INDEX_LANGUAGE_PARAM = "indexLanguage";
    protected static final String MAXDOCS_PARAM = "maxDocs";
    protected static final String HITS_PER_PAGE_PARAM = "hitsPerPage";
    protected static final String START_PAGE_PARAM = "startPage";
    protected static final String INDEX_SUBCOLLECTION_ELEM = "indexSubcollection";
    protected static final String INDEX_LANGUAGE_ELEM = "indexLanguage";
    protected static final String CASE_PARAM = "case";
    protected static final String STEM_PARAM = "stem";
    protected static final String ACCENT_PARAM = "accent";
    protected static final String BOOLEAN_PARAM_ON = "1";
    protected static final String BOOLEAN_PARAM_OFF = "0";
    protected static final String MATCH_PARAM = "matchMode";
    protected static final String MATCH_PARAM_ALL = "all";
    protected static final String MATCH_PARAM_SOME = "some";
    protected boolean does_multi_index_search = false;
    protected boolean does_paging = false;
    protected boolean does_chunking = false;
    protected String default_document_type = null;
    protected String default_index = "";
    protected String default_index_subcollection = "";
    protected String default_index_language = "";
    protected String default_max_docs = "100";
    protected String default_hits_per_page = "10";

    public boolean configure(Element info, Element extra_info) {
        String value;
        Element doc_type_opt;
        Element display_format;
        String path;
        if (!super.configure(info, extra_info)) {
            return false;
        }
        logger.info((Object)"Configuring AbstractSearch...");
        this.config_info = info;
        Element tq_service = this.doc.createElement("service");
        tq_service.setAttribute("type", QUERY_PARAM);
        tq_service.setAttribute("name", TEXT_QUERY_SERVICE);
        this.short_service_info.appendChild(tq_service);
        Element format = (Element)GSXML.getChildByTagName(info, "format");
        if (format == null) {
            path = GSPath.appendLink("search", "format");
            Element search_elem = (Element)GSXML.getChildByTagName(extra_info, "search");
            NodeList format_elems = null;
            if (search_elem != null) {
                format_elems = search_elem.getElementsByTagName("format");
            }
            for (int i = 0; i < format_elems.getLength() && (format = (Element)format_elems.item(i)).getElementsByTagName("gsf:template").getLength() == 0; ++i) {
            }
        }
        if (format != null) {
            this.format_info_map.put(TEXT_QUERY_SERVICE, this.doc.importNode(format, true));
        }
        if ((display_format = (Element)GSXML.getNodeByPath(extra_info, path = GSPath.appendLink("display", "format"))) != null && (doc_type_opt = GSXML.getNamedElement(display_format, "gsf:option", "name", "documentType")) != null && !(value = doc_type_opt.getAttribute("value")).equals("")) {
            this.default_document_type = value;
        }
        return true;
    }

    protected Element getServiceDescription(String service, String lang, String subset) {
        if (!service.equals(TEXT_QUERY_SERVICE)) {
            return null;
        }
        Element tq_service = this.doc.createElement("service");
        tq_service.setAttribute("type", QUERY_PARAM);
        tq_service.setAttribute("name", TEXT_QUERY_SERVICE);
        if (subset == null || subset.equals("displayItemList")) {
            tq_service.appendChild(GSXML.createDisplayTextElement(this.doc, "name", this.getServiceName(TEXT_QUERY_SERVICE, lang)));
            tq_service.appendChild(GSXML.createDisplayTextElement(this.doc, "submit", this.getServiceSubmit(TEXT_QUERY_SERVICE, lang)));
            tq_service.appendChild(GSXML.createDisplayTextElement(this.doc, "description", this.getServiceDescription(TEXT_QUERY_SERVICE, lang)));
        }
        if (subset == null || subset.equals("paramList")) {
            Element param_list = this.doc.createElement("paramList");
            this.addCustomQueryParams(param_list, lang);
            this.addStandardQueryParams(param_list, lang);
            tq_service.appendChild(param_list);
        }
        return tq_service;
    }

    protected String getServiceName(String service_id, String lang) {
        return this.getTextString(service_id + ".name", lang);
    }

    protected String getServiceDescription(String service_id, String lang) {
        return this.getTextString(service_id + ".description", lang);
    }

    protected String getServiceSubmit(String service_id, String lang) {
        return this.getTextString(service_id + ".submit", lang);
    }

    protected void addStandardQueryParams(Element param_list, String lang) {
        if (!this.default_index.equals("")) {
            this.createParameter(INDEX_PARAM, param_list, lang);
        }
        if (!this.default_index_subcollection.equals("")) {
            this.createParameter("indexSubcollection", param_list, lang);
        }
        if (!this.default_index_language.equals("")) {
            this.createParameter("indexLanguage", param_list, lang);
        }
        if (this.does_chunking) {
            this.createParameter(MAXDOCS_PARAM, param_list, lang);
        }
        if (this.does_paging) {
            this.createParameter(HITS_PER_PAGE_PARAM, param_list, lang);
            this.createParameter(START_PAGE_PARAM, param_list, lang);
        }
        this.createParameter(QUERY_PARAM, param_list, lang);
    }

    protected void addCustomQueryParams(Element param_list, String lang) {
    }

    protected void createParameter(String name, Element param_list, String lang) {
        Element param = null;
        if (name.equals(QUERY_PARAM)) {
            param = GSXML.createParameterDescription(this.doc, QUERY_PARAM, this.getTextString("param.query", lang), "string", null, null, null);
            param_list.appendChild(param);
        } else if (name.equals(INDEX_PARAM)) {
            ArrayList index_ids = new ArrayList();
            ArrayList index_names = new ArrayList();
            this.getIndexData(index_ids, index_names, lang);
            String param_type = "enum_single";
            if (this.does_multi_index_search) {
                param_type = "enum_multi";
            }
            param = GSXML.createParameterDescription2(this.doc, INDEX_PARAM, this.getTextString("param.index", lang), param_type, this.default_index, index_ids, index_names);
            param_list.appendChild(param);
        } else if (name.equals("indexSubcollection")) {
            Element index_sub_list = (Element)GSXML.getChildByTagName(this.config_info, "indexSubcollectionList");
            if (index_sub_list == null) {
                return;
            }
            ArrayList index_sub_ids = new ArrayList();
            ArrayList index_sub_names = new ArrayList();
            this.getIndexSubcollectionData(index_sub_ids, index_sub_names, lang);
            String param_type = "enum_single";
            if (this.does_multi_index_search) {
                param_type = "enum_multi";
            }
            param = GSXML.createParameterDescription2(this.doc, "indexSubcollection", this.getTextString("param.indexSubcollection", lang), param_type, this.default_index_subcollection, index_sub_ids, index_sub_names);
            param_list.appendChild(param);
        } else if (name.equals("indexLanguage")) {
            Element index_lang_list = (Element)GSXML.getChildByTagName(this.config_info, "indexLanguageList");
            if (index_lang_list == null) {
                return;
            }
            ArrayList index_lang_ids = new ArrayList();
            ArrayList index_lang_names = new ArrayList();
            this.getIndexLanguageData(index_lang_ids, index_lang_names, lang);
            String param_type = "enum_single";
            if (this.does_multi_index_search) {
                param_type = "enum_multi";
            }
            param = GSXML.createParameterDescription2(this.doc, "indexLanguage", this.getTextString("param.indexLanguage", lang), param_type, this.default_index_language, index_lang_ids, index_lang_names);
            param_list.appendChild(param);
        } else if (name.equals(MAXDOCS_PARAM)) {
            param = GSXML.createParameterDescription(this.doc, name, this.getTextString("param." + name, lang), "integer", this.default_max_docs, null, null);
            param_list.appendChild(param);
        } else if (name.equals(HITS_PER_PAGE_PARAM)) {
            param = GSXML.createParameterDescription(this.doc, name, this.getTextString("param." + name, lang), "integer", this.default_hits_per_page, null, null);
            param_list.appendChild(param);
        } else if (name.equals(CASE_PARAM) || name.equals(STEM_PARAM) || name.equals(ACCENT_PARAM)) {
            String[] bool_ops = new String[]{BOOLEAN_PARAM_OFF, BOOLEAN_PARAM_ON};
            String[] bool_texts = new String[]{this.getTextString("param.boolean.off", lang), this.getTextString("param.boolean.on", lang)};
            param = GSXML.createParameterDescription(this.doc, name, this.getTextString("param." + name, lang), "boolean", BOOLEAN_PARAM_ON, bool_ops, bool_texts);
            param_list.appendChild(param);
        } else if (name.equals(MATCH_PARAM)) {
            String[] vals = new String[]{MATCH_PARAM_SOME, MATCH_PARAM_ALL};
            String[] val_texts = new String[]{this.getTextString("param.matchMode.some", lang), this.getTextString("param.matchMode.all", lang)};
            param = GSXML.createParameterDescription(this.doc, MATCH_PARAM, this.getTextString("param.matchMode", lang), "enum_single", MATCH_PARAM_SOME, vals, val_texts);
            param_list.appendChild(param);
        } else if (name.equals(START_PAGE_PARAM)) {
            param = GSXML.createParameterDescription(this.doc, START_PAGE_PARAM, "", "invisible", BOOLEAN_PARAM_ON, null, null);
            param_list.appendChild(param);
        }
    }

    protected Element createDocNode(String node_id, String rank) {
        Element node = this.doc.createElement("documentNode");
        node.setAttribute("nodeID", node_id);
        node.setAttribute("rank", rank);
        String doc_type = null;
        doc_type = this.default_document_type != null ? this.default_document_type : this.getDocType(node_id);
        node.setAttribute("docType", doc_type);
        String node_type = this.getNodeType(node_id, doc_type);
        node.setAttribute("nodeType", node_type);
        return node;
    }

    protected String getNodeType(String node_id, String doc_type) {
        if (doc_type.equals("simple")) {
            return "leaf";
        }
        if (!this.hasParent(node_id)) {
            return "root";
        }
        if (doc_type.equals("paged")) {
            return "leaf";
        }
        if (!this.hasChildren(node_id)) {
            return "leaf";
        }
        return "internal";
    }

    protected String getDocType(String node_id) {
        return "simple";
    }

    protected boolean hasChildren(String node_id) {
        return false;
    }

    protected boolean hasParent(String node_id) {
        return false;
    }

    protected abstract Element processTextQuery(Element var1);

    protected abstract void getIndexData(ArrayList var1, ArrayList var2, String var3);

    protected void getIndexSubcollectionData(ArrayList index_ids, ArrayList index_names, String lang) {
    }

    protected void getIndexLanguageData(ArrayList index_ids, ArrayList index_names, String lang) {
    }
}

