/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Vector;
import java.util.regex.Pattern;
import org.greenstone.gsdl3.service.ServiceRack;
import org.greenstone.gsdl3.util.DerbyWrapper;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.UserQueryResult;
import org.greenstone.gsdl3.util.UserTermInfo;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Authentication
extends ServiceRack {
    protected static final String AUTHENTICATION_SERVICE = "Authentication";

    public boolean configure(Element info, Element extra_info) {
        logger.info((Object)"Configuring Authentication...");
        this.config_info = info;
        Element authentication_service = this.doc.createElement("service");
        authentication_service.setAttribute("type", "authen");
        authentication_service.setAttribute("name", AUTHENTICATION_SERVICE);
        this.short_service_info.appendChild(authentication_service);
        return true;
    }

    protected Element getServiceDescription(String service_id, String lang, String subset) {
        Element authen_service = this.doc.createElement("service");
        if (!service_id.equals(AUTHENTICATION_SERVICE)) {
            return null;
        }
        authen_service.setAttribute("type", "authen");
        authen_service.setAttribute("name", AUTHENTICATION_SERVICE);
        if (subset == null || subset.equals("displayItemList")) {
            authen_service.appendChild(GSXML.createDisplayTextElement(this.doc, "name", this.getServiceName(service_id, lang)));
            authen_service.appendChild(GSXML.createDisplayTextElement(this.doc, "description", this.getServiceDescription(service_id, lang)));
        }
        return authen_service;
    }

    protected String getServiceName(String service_id, String lang) {
        return this.getTextString(service_id + ".name", lang);
    }

    protected String getServiceSubmit(String service_id, String lang) {
        return this.getTextString(service_id + ".submit", lang);
    }

    protected String getServiceDescription(String service_id, String lang) {
        return this.getTextString(service_id + ".description", lang);
    }

    protected void addCustomParams(String service, Element param_list, String lang) {
    }

    protected void createParameter(String name, Element param_list, String lang) {
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Element processAuthentication(Element request) throws SQLException, UnsupportedEncodingException {
        Vector userInfo;
        Element user_node;
        Element result = this.doc.createElement("response");
        result.setAttribute("from", AUTHENTICATION_SERVICE);
        result.setAttribute("type", "process");
        String lang = request.getAttribute("lang");
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        if (param_list == null) {
            logger.error((Object)"AddUsers request had no paramList.");
            return result;
        }
        String aup = null;
        String un = "";
        String pw = "";
        String asn = "";
        String uan = "";
        String cm = "";
        String umun = "";
        String umpw = "";
        String umas = "";
        String umgp = "";
        String umc = "";
        String oumun = "";
        String umpw1 = "";
        String umpw2 = "";
        String unpwlist = "";
        String service = "";
        NodeList params = param_list.getElementsByTagName("param");
        for (int i = 0; i < params.getLength(); ++i) {
            Element param = (Element)params.item(i);
            String p_name = param.getAttribute("name");
            String p_value = GSXML.getValue(param);
            if (p_name.equals("aup")) {
                aup = p_value;
                continue;
            }
            if (p_name.equals("un")) {
                un = p_value;
                continue;
            }
            if (p_name.equals("pw")) {
                pw = p_value;
                continue;
            }
            if (p_name.equals("umun")) {
                umun = p_value;
                continue;
            }
            if (p_name.equals("umpw")) {
                umpw = p_value;
                continue;
            }
            if (p_name.equals("umas")) {
                umas = p_value;
                continue;
            }
            if (p_name.equals("umgp")) {
                umgp = p_value;
                continue;
            }
            if (p_name.equals("umc")) {
                umc = p_value;
                continue;
            }
            if (p_name.equals("asn")) {
                asn = p_value;
                continue;
            }
            if (p_name.equals("uan")) {
                uan = p_value;
                continue;
            }
            if (p_name.equals("cm")) {
                cm = p_value;
                continue;
            }
            if (p_name.equals("umpw1")) {
                umpw1 = p_value;
                continue;
            }
            if (p_name.equals("umpw2")) {
                umpw2 = p_value;
                continue;
            }
            if (p_name.equals("oumun")) {
                oumun = p_value;
                continue;
            }
            if (!p_name.equals("unpwlist")) continue;
            unpwlist = p_value;
        }
        Element authen_node = this.doc.createElement("authenticationNode");
        result.appendChild(authen_node);
        result.appendChild(this.getCollectList(this.site_home + File.separatorChar + "collect"));
        Element service_node = this.doc.createElement("service");
        authen_node.appendChild(service_node);
        service_node.setAttribute("aup", aup);
        UserQueryResult userQueryResult = null;
        String usersDB_dir = this.site_home + File.separatorChar + "etc" + File.separatorChar + "usersDB";
        DerbyWrapper derbyWrapper = new DerbyWrapper();
        File usersDB_file = new File(usersDB_dir);
        if (!usersDB_file.exists()) {
            boolean success;
            String etc_dir = this.site_home + File.separatorChar + "etc";
            File etc_file = new File(etc_dir);
            if (!etc_file.exists() && !(success = etc_file.mkdir())) {
                logger.error((Object)("Couldn't create the etc dir under " + this.site_home + "."));
                return result;
            }
            derbyWrapper.connectDatabase(usersDB_dir, true);
            derbyWrapper.createDatabase();
        } else {
            derbyWrapper.connectDatabase(usersDB_dir, false);
        }
        if (aup.equals("Login")) {
            if (uan.equals("")) {
                service_node.setAttribute("info", "Login");
                derbyWrapper.closeDatabase();
                return result;
            }
            String groups = "";
            if (uan.equals("1") && asn.equals("0")) {
                if (un.length() == 0 && pw.length() == 0) {
                    service_node.setAttribute("asn", "0");
                    service_node.setAttribute("info", "Login");
                    derbyWrapper.closeDatabase();
                    return result;
                }
                if (un.length() == 0 || pw.length() == 0) {
                    service_node.setAttribute("asn", "0");
                    service_node.setAttribute("info", "Login");
                    service_node.setAttribute("err", "un-pw-err");
                    derbyWrapper.closeDatabase();
                    return result;
                }
                userQueryResult = derbyWrapper.findUser(un, pw);
                service_node.setAttribute("name", AUTHENTICATION_SERVICE);
                service_node.setAttribute("un", un);
                if (userQueryResult == null) {
                    service_node.setAttribute("asn", "0");
                    service_node.setAttribute("err", "un-pw-err");
                    service_node.setAttribute("info", "Login");
                    derbyWrapper.closeDatabase();
                    return result;
                }
                Vector userInfo2 = userQueryResult.users_;
                groups = ((UserTermInfo)userInfo2.get((int)0)).groups_;
                String accountstatus = ((UserTermInfo)userInfo2.get((int)0)).accountstatus_;
                if (accountstatus.trim().equals("false")) {
                    service_node.setAttribute("asn", "0");
                    service_node.setAttribute("err", "as-false");
                    service_node.setAttribute("info", "Login");
                    derbyWrapper.closeDatabase();
                    return result;
                }
                String[] groups_array = groups.split(",");
                for (int i = 0; i < groups_array.length; ++i) {
                    if (!groups_array[i].trim().toLowerCase().equals("administrator")) continue;
                    asn = "1";
                    service_node.setAttribute("asn", "1");
                    break;
                }
                if (!asn.equals("1")) {
                    asn = "2";
                    service_node.setAttribute("asn", "2");
                }
            }
            if (!asn.equals("0")) {
                service_node.setAttribute("info", "Login");
                service_node.setAttribute("un", un);
                service_node.setAttribute("pw", pw);
                service_node.setAttribute("asn", asn);
                service_node.setAttribute("umgp", groups);
                derbyWrapper.closeDatabase();
                return result;
            }
        }
        if (aup.equals("ListUsers")) {
            if (asn.equals("") && un.equals("")) {
                service_node.setAttribute("info", "Login");
                derbyWrapper.closeDatabase();
                return result;
            }
            if (asn.equals("2")) {
                service_node.setAttribute("info", "Login");
                service_node.setAttribute("err", "no-permission");
                service_node.setAttribute("un", un);
                service_node.setAttribute("asn", asn);
                derbyWrapper.closeDatabase();
                return result;
            }
            if (asn.equals("1")) {
                userQueryResult = derbyWrapper.findUser(null, null);
                derbyWrapper.closeDatabase();
                service_node.setAttribute("name", AUTHENTICATION_SERVICE);
                service_node.setAttribute("un", un);
                service_node.setAttribute("asn", asn);
                if (userQueryResult != null && userQueryResult.getSize() > 0) {
                    service_node.setAttribute("info", "all-un");
                    user_node = this.getUserNode(userQueryResult);
                    service_node.appendChild(user_node);
                    derbyWrapper.closeDatabase();
                    return result;
                }
                service_node.setAttribute("err", "no-un");
                derbyWrapper.closeDatabase();
                return result;
            }
        }
        if (aup.equals("AddStudents")) {
            String[] users = unpwlist.split("]");
            for (int i = 0; i < users.length; ++i) {
                String group;
                String password;
                String[] user = users[i].split(",");
                String uname = user[0];
                String add_user = derbyWrapper.addUser(uname, password = user[1], group = user[2].split(":")[0], "true", "");
                if (!add_user.equals("succeed")) continue;
                userQueryResult = derbyWrapper.findUser(null, null);
                derbyWrapper.closeDatabase();
                service_node.setAttribute("info", "all-un");
                Element user_node2 = this.getUserNode(userQueryResult);
                service_node.appendChild(user_node2);
                derbyWrapper.closeDatabase();
                return result;
            }
        }
        if (aup.equals("AddUser")) {
            if (asn.equals("") && un.equals("")) {
                service_node.setAttribute("info", "Login");
                derbyWrapper.closeDatabase();
                return result;
            }
            if (asn.equals("2")) {
                service_node.setAttribute("info", "Login");
                service_node.setAttribute("err", "no-permission");
                service_node.setAttribute("un", un);
                service_node.setAttribute("asn", asn);
                derbyWrapper.closeDatabase();
                return result;
            }
            if (asn.equals("1")) {
                service_node.setAttribute("name", AUTHENTICATION_SERVICE);
                service_node.setAttribute("un", un);
                service_node.setAttribute("asn", asn);
                if (umun.length() == 0 && umpw.length() == 0 && umgp.length() == 0 && umas.length() == 0 && umc.length() == 0) {
                    service_node.setAttribute("info", "adduser_interface");
                    derbyWrapper.closeDatabase();
                    return result;
                }
                if (umun == null || umun.length() < 2 || umun.length() > 30 || !Pattern.matches("[a-zA-Z0-9//_//.]+", umun)) {
                    service_node.setAttribute("err", "un-err");
                    service_node.setAttribute("info", "adduser_interface");
                    derbyWrapper.closeDatabase();
                    return result;
                }
                if (umpw == null || umpw.length() < 3 || umpw.length() > 8 || !Pattern.matches("[\\p{ASCII}]+", umpw)) {
                    service_node.setAttribute("err", "pw-err");
                    service_node.setAttribute("info", "adduser_interface");
                    derbyWrapper.closeDatabase();
                    return result;
                }
                umgp = umgp.replaceAll(" ", "");
                userQueryResult = derbyWrapper.findUser(umun, null);
                if (userQueryResult != null) {
                    service_node.setAttribute("err", "un-exist");
                    service_node.setAttribute("info", "adduser_interface");
                    derbyWrapper.closeDatabase();
                    return result;
                }
                String add_user = derbyWrapper.addUser(umun, umpw, umgp, umas, umc);
                if (add_user.equals("succeed")) {
                    userQueryResult = derbyWrapper.findUser(null, null);
                    derbyWrapper.closeDatabase();
                    service_node.setAttribute("info", "all-un");
                    Element user_node3 = this.getUserNode(userQueryResult);
                    service_node.appendChild(user_node3);
                    derbyWrapper.closeDatabase();
                    return result;
                }
                derbyWrapper.closeDatabase();
                service_node.setAttribute("err", add_user);
                derbyWrapper.closeDatabase();
                return result;
            }
        }
        if (aup.equals("EditUser")) {
            service_node.setAttribute("name", AUTHENTICATION_SERVICE);
            service_node.setAttribute("un", un);
            service_node.setAttribute("asn", asn);
            if (cm.length() == 0) {
                service_node.setAttribute("info", "edituser-interface");
                userQueryResult = derbyWrapper.findUser(umun, null);
                derbyWrapper.closeDatabase();
                userInfo = userQueryResult.users_;
                String username = ((UserTermInfo)userInfo.get((int)0)).username_;
                String password = ((UserTermInfo)userInfo.get((int)0)).password_;
                String groups = ((UserTermInfo)userInfo.get((int)0)).groups_;
                String accountstatus = ((UserTermInfo)userInfo.get((int)0)).accountstatus_;
                String comment = ((UserTermInfo)userInfo.get((int)0)).comment_;
                service_node.setAttribute("oumun", oumun);
                service_node.setAttribute("umun", username);
                service_node.setAttribute("umpw", password);
                service_node.setAttribute("umgp", groups);
                service_node.setAttribute("umas", accountstatus);
                service_node.setAttribute("umc", comment);
                derbyWrapper.closeDatabase();
                return result;
            }
            if (cm.toLowerCase().equals("submit")) {
                if (oumun.equals(umun)) {
                    if (umpw.length() == 0) {
                        derbyWrapper.modifyUserInfo(umun, null, umgp, umas, umc);
                        userQueryResult = derbyWrapper.findUser(null, null);
                        derbyWrapper.closeDatabase();
                        service_node.setAttribute("info", "all-un");
                        user_node = this.getUserNode(userQueryResult);
                        service_node.appendChild(user_node);
                        derbyWrapper.closeDatabase();
                        return result;
                    }
                    if (umpw.length() != 0 && umpw.length() >= 3 && umpw.length() <= 8 && Pattern.matches("[\\p{ASCII}]+", umpw)) {
                        umgp = umgp.replaceAll(" ", "");
                        derbyWrapper.modifyUserInfo(umun, umpw, umgp, umas, umc);
                        userQueryResult = derbyWrapper.listAllUser();
                        derbyWrapper.closeDatabase();
                        service_node.setAttribute("info", "all-un");
                        user_node = this.getUserNode(userQueryResult);
                        service_node.appendChild(user_node);
                        derbyWrapper.closeDatabase();
                        return result;
                    }
                    service_node.setAttribute("err", "umpw-err");
                    service_node.setAttribute("info", "edituser-interface");
                    service_node.setAttribute("umun", umun);
                    service_node.setAttribute("umpw", umpw);
                    service_node.setAttribute("umgp", umgp);
                    service_node.setAttribute("umas", umas);
                    service_node.setAttribute("umc", umc);
                    service_node.setAttribute("oumun", oumun);
                    derbyWrapper.closeDatabase();
                    return result;
                }
                if (umun.length() == 0 || umun.length() < 2 || umun.length() > 30 || !Pattern.matches("[a-zA-Z0-9//_//.]+", umun)) {
                    service_node.setAttribute("err", "umun-err");
                    service_node.setAttribute("umun", umun);
                    service_node.setAttribute("umpw", umpw);
                    service_node.setAttribute("umgp", umgp);
                    service_node.setAttribute("umas", umas);
                    service_node.setAttribute("umc", umc);
                    service_node.setAttribute("oumun", oumun);
                    service_node.setAttribute("info", "edituser-interface");
                    derbyWrapper.closeDatabase();
                    return result;
                }
                if (umpw.length() == 0) {
                    service_node.setAttribute("err", "ini-umpw-err");
                    service_node.setAttribute("info", "edituser-interface");
                    service_node.setAttribute("umun", umun);
                    service_node.setAttribute("umpw", umpw);
                    service_node.setAttribute("umgp", umgp);
                    service_node.setAttribute("umas", umas);
                    service_node.setAttribute("umc", umc);
                    service_node.setAttribute("oumun", oumun);
                    derbyWrapper.closeDatabase();
                    return result;
                }
                if (umpw.length() < 3 || umpw.length() > 8 || !Pattern.matches("[\\p{ASCII}]+", umpw)) {
                    service_node.setAttribute("err", "umpw-err");
                    service_node.setAttribute("info", "edituser-interface");
                    service_node.setAttribute("umun", umun);
                    service_node.setAttribute("umpw", umpw);
                    service_node.setAttribute("umgp", umgp);
                    service_node.setAttribute("umas", umas);
                    service_node.setAttribute("umc", umc);
                    service_node.setAttribute("oumun", oumun);
                    derbyWrapper.closeDatabase();
                    return result;
                }
                umgp = umgp.replaceAll(" ", "");
                userQueryResult = derbyWrapper.findUser(umun, null);
                if (userQueryResult != null) {
                    service_node.setAttribute("err", "un-exist");
                    service_node.setAttribute("info", "edituser-interface");
                    service_node.setAttribute("umun", "");
                    service_node.setAttribute("umpw", "");
                    service_node.setAttribute("umgp", umgp);
                    service_node.setAttribute("umas", umas);
                    service_node.setAttribute("umc", umc);
                    service_node.setAttribute("oumun", oumun);
                    derbyWrapper.closeDatabase();
                    return result;
                }
                derbyWrapper.addUser(umun, umpw, umgp, umas, umc);
                userQueryResult = derbyWrapper.listAllUser();
                derbyWrapper.closeDatabase();
                service_node.setAttribute("info", "all-un");
                user_node = this.getUserNode(userQueryResult);
                service_node.appendChild(user_node);
                derbyWrapper.closeDatabase();
                return result;
            }
            if (cm.toLowerCase().equals("cancel")) {
                userQueryResult = derbyWrapper.listAllUser();
                derbyWrapper.closeDatabase();
                service_node.setAttribute("info", "all-un");
                user_node = this.getUserNode(userQueryResult);
                service_node.appendChild(user_node);
                derbyWrapper.closeDatabase();
                return result;
            }
        }
        if (aup.equals("ModifyPassword")) {
            if (un.equals("")) {
                service_node.setAttribute("info", "Login");
                derbyWrapper.closeDatabase();
                return result;
            }
            service_node.setAttribute("name", AUTHENTICATION_SERVICE);
            service_node.setAttribute("un", un);
            service_node.setAttribute("asn", asn);
            userQueryResult = derbyWrapper.findUser(un, null);
            userInfo = userQueryResult.users_;
            pw = ((UserTermInfo)userInfo.get((int)0)).password_;
            if (umpw1.length() == 0 && umpw2.length() == 0 && umpw.length() == 0) {
                service_node.setAttribute("info", "modify_interface");
                derbyWrapper.closeDatabase();
                return result;
            }
            if (!pw.equals(umpw) && umpw.length() > 0) {
                service_node.setAttribute("info", "modify_interface");
                service_node.setAttribute("err", "pw-umpw-nm-err");
                derbyWrapper.closeDatabase();
                return result;
            }
            if (umpw1.length() == 0 || umpw2.length() == 0) {
                service_node.setAttribute("info", "modify_interface");
                service_node.setAttribute("err", "umpw1-umpw2-null-err");
                derbyWrapper.closeDatabase();
                return result;
            }
            if (!umpw1.equals(umpw2)) {
                service_node.setAttribute("info", "modify_interface");
                service_node.setAttribute("err", "umpw1-umpw2-nm-err");
                derbyWrapper.closeDatabase();
                return result;
            }
            if (umpw.length() == 0) {
                service_node.setAttribute("info", "modify_interface");
                service_node.setAttribute("err", "umpw-null-err");
                derbyWrapper.closeDatabase();
                return result;
            }
            if (umpw1 == null || umpw1.length() < 3 || umpw1.length() > 8 || !Pattern.matches("[\\p{ASCII}]+", umpw1)) {
                service_node.setAttribute("info", "modify_interface");
                service_node.setAttribute("err", "umpw1-err");
                derbyWrapper.closeDatabase();
                return result;
            }
            if (umpw2 == null || umpw2.length() < 3 || umpw2.length() > 8 || !Pattern.matches("[\\p{ASCII}]+", umpw2)) {
                service_node.setAttribute("info", "modify_interface");
                service_node.setAttribute("err", "umpw2-err");
                derbyWrapper.closeDatabase();
                return result;
            }
            String modify_user_info = derbyWrapper.modifyUserInfo(un, umpw1, null, null, null);
            if (modify_user_info.equals("succeed")) {
                service_node.setAttribute("err", "");
                derbyWrapper.closeDatabase();
                return result;
            }
            service_node.setAttribute("err", modify_user_info);
            derbyWrapper.closeDatabase();
            return result;
        }
        if (!aup.equals("DeleteUser")) return result;
        service_node.setAttribute("un", un);
        service_node.setAttribute("asn", asn);
        service_node.setAttribute("umun", umun);
        if (cm.equals("yes")) {
            String delete_user = derbyWrapper.deleteUser(umun);
            if (delete_user.equals("succeed")) {
                service_node.setAttribute("err", "");
                userQueryResult = derbyWrapper.listAllUser();
                service_node.setAttribute("info", "all-un");
                Element user_node4 = this.getUserNode(userQueryResult);
                service_node.appendChild(user_node4);
                return result;
            }
            service_node.setAttribute("err", delete_user);
            derbyWrapper.closeDatabase();
            return result;
        }
        if (cm.equals("no")) {
            service_node.setAttribute("err", "");
            userQueryResult = derbyWrapper.listAllUser();
            service_node.setAttribute("info", "all-un");
            user_node = this.getUserNode(userQueryResult);
            service_node.appendChild(user_node);
            derbyWrapper.closeDatabase();
            return result;
        }
        service_node.setAttribute("info", "confirm");
        derbyWrapper.closeDatabase();
        return result;
    }

    private Element getUserNode(UserQueryResult userQueryResult) {
        Element user_list_node = this.doc.createElement("userNodeList");
        Vector userInfo = userQueryResult.users_;
        for (int i = 0; i < userQueryResult.getSize(); ++i) {
            Element user_node = this.doc.createElement("userNode");
            String username = ((UserTermInfo)userInfo.get((int)i)).username_;
            String password = ((UserTermInfo)userInfo.get((int)i)).password_;
            String groups = ((UserTermInfo)userInfo.get((int)i)).groups_;
            String accountstatus = ((UserTermInfo)userInfo.get((int)i)).accountstatus_;
            String comment = ((UserTermInfo)userInfo.get((int)i)).comment_;
            user_node.setAttribute("umun", username);
            user_node.setAttribute("umpw", password);
            user_node.setAttribute("umgp", groups);
            user_node.setAttribute("umas", accountstatus);
            user_node.setAttribute("umc", comment);
            user_list_node.appendChild(user_node);
        }
        return user_list_node;
    }

    private Element getCollectList(String collect) {
        Element collect_list_node = this.doc.createElement("collectionList");
        File[] collect_dir = new File(collect).listFiles();
        if (collect_dir != null && collect_dir.length > 0) {
            for (int i = 0; i < collect_dir.length; ++i) {
                if (!collect_dir[i].isDirectory() || collect_dir[i].getName().startsWith(".svn")) continue;
                Element collect_node = this.doc.createElement("collection");
                collect_node.setAttribute("name", collect_dir[i].getName());
                collect_list_node.appendChild(collect_node);
            }
        }
        return collect_list_node;
    }
}

