/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.swing.Timer;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.service.ServiceRack;
import org.greenstone.gsdl3.util.GSPath;
import org.greenstone.gsdl3.util.GSXML;
import org.w3c.dom.Element;

public class BerryBasket
extends ServiceRack {
    static Logger logger = Logger.getLogger((String)BerryBasket.class.getName());
    protected static final String ADD_ITEM_SERVICE = "AddItem";
    protected static final String DISPLAY_ITEMS_SERVICE = "DisplayList";
    protected static final String ITEM_NUM_SERVICE = "ItemNum";
    protected static final String DELETE_ITEMS_SERVICE = "DeleteItems";
    protected static final String SEND_MAIL_SERVICE = "SendMail";
    protected static final String DELETE_ITEM_SERVICE = "DeleteItem";
    protected static final String ITEM_PARAM = "item";
    protected static final String delimiter = "|";
    protected static final int delay = 1800000;
    protected Hashtable userMap = new Hashtable();
    protected Hashtable timerMap = new Hashtable();
    protected String username = "";
    protected String password = "";

    private Hashtable updateDocMap(Element request) {
        String id = request.getAttribute("uid");
        if (this.userMap.containsKey(id)) {
            if (this.timerMap.containsKey(id)) {
                UserTimer timer = (UserTimer)this.timerMap.get(id);
                timer.restart();
            }
            return (Hashtable)this.userMap.get(id);
        }
        UserTimer timer = new UserTimer(1800000, id);
        this.timerMap.put(id, timer);
        timer.start();
        Hashtable newDocs = new Hashtable();
        this.userMap.put(id, newDocs);
        return newDocs;
    }

    public boolean configure(Element info, Element extra_info) {
        logger.info((Object)"Configuring BerryBasket...");
        this.config_info = info;
        Element add_service = this.doc.createElement("service");
        add_service.setAttribute("type", "gather");
        add_service.setAttribute("name", ADD_ITEM_SERVICE);
        this.short_service_info.appendChild(add_service);
        Element disp_service = this.doc.createElement("service");
        disp_service.setAttribute("type", "gather");
        disp_service.setAttribute("name", DISPLAY_ITEMS_SERVICE);
        this.short_service_info.appendChild(disp_service);
        Element num_service = this.doc.createElement("service");
        num_service.setAttribute("type", "gather");
        num_service.setAttribute("name", ITEM_NUM_SERVICE);
        this.short_service_info.appendChild(num_service);
        Element delete_service = this.doc.createElement("service");
        delete_service.setAttribute("type", "gather");
        delete_service.setAttribute("name", DELETE_ITEMS_SERVICE);
        this.short_service_info.appendChild(delete_service);
        Element deleteone_service = this.doc.createElement("service");
        deleteone_service.setAttribute("type", "gather");
        deleteone_service.setAttribute("name", DELETE_ITEM_SERVICE);
        this.short_service_info.appendChild(deleteone_service);
        Element mail_service = this.doc.createElement("service");
        mail_service.setAttribute("type", "gather");
        mail_service.setAttribute("name", SEND_MAIL_SERVICE);
        this.short_service_info.appendChild(mail_service);
        return true;
    }

    protected Element getServiceDescription(String service_id, String lang, String subset) {
        if (service_id.equals(ADD_ITEM_SERVICE)) {
            Element add_service = this.doc.createElement("service");
            add_service.setAttribute("type", "gather");
            add_service.setAttribute("name", ADD_ITEM_SERVICE);
            return add_service;
        }
        if (service_id.equals(DISPLAY_ITEMS_SERVICE)) {
            Element disp_service = this.doc.createElement("service");
            disp_service.setAttribute("type", "gather");
            disp_service.setAttribute("name", DISPLAY_ITEMS_SERVICE);
            return disp_service;
        }
        if (service_id.equals(ITEM_NUM_SERVICE)) {
            Element num_service = this.doc.createElement("service");
            num_service.setAttribute("type", "gather");
            num_service.setAttribute("name", ITEM_NUM_SERVICE);
            return num_service;
        }
        if (service_id.equals(DELETE_ITEMS_SERVICE)) {
            Element del_service = this.doc.createElement("service");
            del_service.setAttribute("type", "gather");
            del_service.setAttribute("name", DELETE_ITEMS_SERVICE);
            return del_service;
        }
        if (service_id.equals(DELETE_ITEM_SERVICE)) {
            Element delone_service = this.doc.createElement("service");
            delone_service.setAttribute("type", "gather");
            delone_service.setAttribute("name", DELETE_ITEM_SERVICE);
            return delone_service;
        }
        if (service_id.equals(SEND_MAIL_SERVICE)) {
            Element mail_service = this.doc.createElement("service");
            mail_service.setAttribute("type", "gather");
            mail_service.setAttribute("name", SEND_MAIL_SERVICE);
            return mail_service;
        }
        return null;
    }

    protected Element processAddItem(Element request) {
        Hashtable docsMap = this.updateDocMap(request);
        Element result = this.doc.createElement("response");
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        if (param_list == null) {
            logger.error((Object)"BerryBasket Error: AddItem request had no paramList.");
            return result;
        }
        HashMap params = GSXML.extractParams(param_list, false);
        String item = (String)params.get(ITEM_PARAM);
        String collection = "";
        int pos = item.indexOf(":");
        if (pos != -1) {
            collection = item.substring(0, pos);
            item = item.substring(pos + 1);
        }
        if (docsMap.containsKey(collection)) {
            Hashtable items = (Hashtable)docsMap.get(collection);
            if (!items.containsKey(item)) {
                Item newItem = this.generateItem(collection, item);
                items.put(item, newItem);
                result.appendChild(newItem.wrapIntoElement());
            }
        } else {
            Hashtable<String, Item> items = new Hashtable<String, Item>();
            Item newItem = this.generateItem(collection, item);
            items.put(item, newItem);
            docsMap.put(collection, items);
            result.appendChild(newItem.wrapIntoElement());
        }
        return result;
    }

    private Item generateItem(String collection, String id) {
        String rootTitle;
        Item item = new Item(collection, id);
        String to = GSPath.appendLink(collection, "DocumentMetadataRetrieve");
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(id);
        Element response = this.getDocumentMetadata(to, "en", "dumy", tmp.iterator());
        Element doc_node = (Element)response.getElementsByTagName("documentNode").item(0);
        String node_id = doc_node.getAttribute("nodeID");
        Element metadata_list = (Element)doc_node.getElementsByTagName("metadataList").item(0);
        Element metadata = GSXML.getNamedElement(metadata_list, "metadata", "name", "Title");
        if (metadata != null) {
            item.title = GSXML.getNodeText(metadata).trim();
        }
        if ((metadata = GSXML.getNamedElement(metadata_list, "metadata", "name", "Date")) != null) {
            item.date = GSXML.getNodeText(metadata).trim();
        }
        if ((metadata = GSXML.getNamedElement(metadata_list, "metadata", "name", "root_Title")) != null && !(rootTitle = GSXML.getNodeText(metadata).trim()).equals(item.title)) {
            item.rootTitle = rootTitle;
        }
        return item;
    }

    protected Element processDeleteItems(Element request) {
        Hashtable docsMap = this.updateDocMap(request);
        Element result = this.doc.createElement("response");
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        if (param_list == null) {
            logger.error((Object)"BerryBasket Error: DeleteItem request had no paramList.");
            return result;
        }
        HashMap params = GSXML.extractParams(param_list, false);
        String param = (String)params.get("items");
        if (param == null) {
            return result;
        }
        String[] items = param.split("\\|");
        for (int i = 0; i < items.length; ++i) {
            String item = items[i];
            if (item.trim().length() == 0) continue;
            String collection = "";
            int pos = item.indexOf(":");
            if (pos != -1) {
                collection = item.substring(0, pos);
                item = item.substring(pos + 1);
            }
            if (!docsMap.containsKey(collection)) continue;
            Hashtable itemMap = (Hashtable)docsMap.get(collection);
            if (itemMap.containsKey(item)) {
                itemMap.remove(item);
            }
            if (itemMap.size() != 0) continue;
            docsMap.remove(collection);
        }
        return result;
    }

    protected Element processDeleteItem(Element request) {
        Hashtable docsMap = this.updateDocMap(request);
        Element result = this.doc.createElement("response");
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        if (param_list == null) {
            logger.error((Object)"BerryBasket Error: DeleteItem request had no paramList.");
            return result;
        }
        HashMap params = GSXML.extractParams(param_list, false);
        String param = (String)params.get(ITEM_PARAM);
        if (param == null) {
            return result;
        }
        String item = param;
        String collection = "";
        int pos = item.indexOf(":");
        if (pos != -1) {
            collection = item.substring(0, pos);
            item = item.substring(pos + 1);
        }
        if (docsMap.containsKey(collection)) {
            Hashtable itemMap = (Hashtable)docsMap.get(collection);
            if (itemMap.containsKey(item)) {
                itemMap.remove(item);
            }
            if (itemMap.size() == 0) {
                docsMap.remove(collection);
            }
        }
        return result;
    }

    protected Element processItemNum(Element request) {
        Hashtable docsMap = this.updateDocMap(request);
        Element result = this.doc.createElement("response");
        int size = 0;
        String ids = "";
        Iterator keys = docsMap.keySet().iterator();
        while (keys.hasNext()) {
            Hashtable items = (Hashtable)docsMap.get((String)keys.next());
            size += items.size();
            for (Item item : items.values()) {
                result.appendChild(item.wrapIntoElement());
            }
        }
        Element selement = this.doc.createElement("size");
        selement.setAttribute("value", size + "");
        result.appendChild(selement);
        return result;
    }

    private Element getDocumentMetadata(String to, String lang, String uid, Iterator ids) {
        Element dm_message = this.doc.createElement("message");
        Element dm_request = GSXML.createBasicRequest(this.doc, "process", to, lang, uid);
        dm_message.appendChild(dm_request);
        HashSet<String> meta_names = new HashSet<String>();
        meta_names.add("Title");
        meta_names.add("root_Title");
        meta_names.add("Date");
        Element param_list = this.doc.createElement("paramList");
        Element param = null;
        for (String name : meta_names) {
            param = this.doc.createElement("param");
            param_list.appendChild(param);
            param.setAttribute("name", "metadata");
            param.setAttribute("value", name);
        }
        dm_request.appendChild(param_list);
        Element dm_doc_list = this.doc.createElement("documentNodeList");
        dm_request.appendChild(dm_doc_list);
        while (ids.hasNext()) {
            Element dm_doc_node = this.doc.createElement("documentNode");
            dm_doc_list.appendChild(dm_doc_node);
            dm_doc_node.setAttribute("nodeID", (String)ids.next());
        }
        return (Element)this.router.process(dm_message);
    }

    protected Element processDisplayList(Element request) {
        Hashtable docsMap = this.updateDocMap(request);
        Element result = this.doc.createElement("response");
        for (String collection : docsMap.keySet()) {
            Hashtable items = (Hashtable)docsMap.get(collection);
            Iterator itemItr = items.values().iterator();
            Element collectionNode = this.doc.createElement("collection");
            collectionNode.setAttribute("name", collection);
            result.appendChild(collectionNode);
            while (itemItr.hasNext()) {
                Item item = (Item)itemItr.next();
                Element itemElement = this.doc.createElement(ITEM_PARAM);
                collectionNode.appendChild(itemElement);
                itemElement.setAttribute("name", item.docid);
                itemElement.setAttribute("collection", item.collection);
                itemElement.setAttribute("title", item.title);
                itemElement.setAttribute("date", item.date);
                itemElement.setAttribute("root_title", item.rootTitle);
            }
        }
        return result;
    }

    public Element processSendMail(Element request) {
        Element result = this.doc.createElement("response");
        Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        GSXML.printXMLNode(param_list);
        if (param_list == null) {
            logger.error((Object)"BerryBasket Error: SendMail request had no paramList.");
            return result;
        }
        HashMap params = GSXML.extractParams(param_list, false);
        String to = (String)params.get("address");
        String subject = (String)params.get("subject");
        String mailhost = (String)params.get("host");
        String content = (String)params.get("content");
        String cc = (String)params.get("cc");
        String bcc = (String)params.get("bcc");
        this.username = (String)params.get("user");
        this.password = (String)params.get("password");
        String mailer = "msgsend";
        try {
            Properties props = System.getProperties();
            if (mailhost != null && mailhost.trim().equals("")) {
                props.put("mail.smtp.host", mailhost);
            } else {
                props.put("mail.smtp.host", "webmail.cs.waikato.ac.nz");
            }
            Authenticator auth = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    if (BerryBasket.this.username == null || BerryBasket.this.username.equals("")) {
                        BerryBasket.this.username = "xxxxx";
                        BerryBasket.this.password = "xxxxx";
                    }
                    return new PasswordAuthentication(BerryBasket.this.username, BerryBasket.this.password);
                }
            };
            Session session = Session.getInstance((Properties)props, (Authenticator)auth);
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom();
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to, (boolean)false));
            if (cc != null) {
                msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)cc, (boolean)false));
            }
            if (bcc != null) {
                msg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)bcc, (boolean)false));
            }
            msg.setSubject(subject);
            msg.setText(content.replaceAll("-------", "&"));
            msg.setHeader("X-Mailer", mailer);
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
            logger.info((Object)"\nMail was sent successfully.");
            result.appendChild(this.doc.createTextNode("Mail was sent successfully."));
        }
        catch (Exception e) {
            e.printStackTrace();
            result.appendChild(this.doc.createTextNode(e.getMessage()));
        }
        return result;
    }

    private class UserTimer
    extends Timer
    implements ActionListener {
        String id;

        public UserTimer(int delay, String id) {
            super(delay, null);
            this.id = "";
            this.addActionListener(this);
            this.id = id;
        }

        public void actionPerformed(ActionEvent e) {
            BerryBasket.this.userMap.remove(this.id);
            BerryBasket.this.timerMap.remove(this.id);
            this.stop();
        }
    }

    protected class Item {
        public String collection;
        public String docid;
        public String title = "";
        public String query = "";
        public String date = "";
        public String rootTitle = "";

        public Item(String coll, String id) {
            this.collection = coll;
            this.docid = id;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Item)) {
                return false;
            }
            Item item = (Item)o;
            String id = this.collection + ":" + this.docid;
            String idin = item.collection + ":" + item.docid;
            return id.equals(idin);
        }

        public String toString() {
            return this.collection + ":" + this.docid + ":" + "[" + (!this.rootTitle.equals("") ? this.rootTitle + ":" : "") + this.title + "]";
        }

        public Element wrapIntoElement() {
            Element itemElement = BerryBasket.this.doc.createElement(BerryBasket.ITEM_PARAM);
            itemElement.setAttribute("name", this.docid);
            itemElement.setAttribute("collection", this.collection);
            itemElement.setAttribute("title", this.title);
            itemElement.setAttribute("date", this.date);
            itemElement.setAttribute("root_title", this.rootTitle);
            return itemElement;
        }
    }
}

